/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerFileSearchUtil;
import com.intellij.docker.cli.DockerBuildCliBuilder;
import com.intellij.docker.cli.DockerRunCliBuilder;
import com.intellij.docker.deployment.ui.DockerContainerSettingsUI;
import com.intellij.docker.deployment.ui.DockerDeploymentSourcePathCombo;
import com.intellij.docker.deployment.ui.DockerEnvVarFieldWithBrowseButton;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class DockerDeploymentEditor
extends SettingsEditor<DockerDeploymentConfiguration> {
    private final boolean myImageNotFileSource;
    private final Project myProject;
    private JPanel myMainPanel;
    private JBLabel myImageLabel;
    private JTextField myImageTextField;
    private JTextField myContainerNameTextField;
    private JBLabel mySourcePathLabel;
    private ComboboxWithBrowseButton mySourcePathCombo;
    private JBCheckBox myShouldRunContainerCheckbox;
    private TextFieldWithBrowseButton myBuildArgsField;
    private JLabel myBuildArgsLabel;
    private JPanel myContainerOptionsPanel;
    private ExpandableTextField myCommandPreviewField;
    private JTextField myHiddenPathJsonFileField;
    private DockerContainerSettingsUI myContainerSettingsUI;

    public DockerDeploymentEditor(@NotNull Project project, boolean imageNotFileSource) {
        if (project == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myImageNotFileSource = imageNotFileSource;
        this.$$$setupUI$$$();
        if (this.myImageNotFileSource) {
            this.myImageLabel.setText("Image ID:");
            this.mySourcePathCombo.setVisible(false);
            this.mySourcePathLabel.setVisible(false);
            this.myShouldRunContainerCheckbox.setVisible(false);
            this.myBuildArgsField.setVisible(false);
            this.myBuildArgsLabel.setVisible(false);
        } else {
            this.myImageLabel.setText("Image tag:");
            this.mySourcePathLabel.setVisible(true);
            this.mySourcePathCombo.setVisible(true);
            this.myShouldRunContainerCheckbox.setVisible(true);
            this.myBuildArgsField.setVisible(true);
            this.myBuildArgsLabel.setVisible(true);
            this.getSourcePathCombo().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    DockerDeploymentEditor.this.onSourcePathChanged();
                }
            });
            this.getSourcePathCombo().addBrowseFolderActionListener(project, "Dockerfile", "Specify Dockerfile to build and run", FileChooserDescriptorFactory.createSingleFileDescriptor());
            for (VirtualFile nextDockerfile : DockerFileSearchUtil.getDockerFiles(project, false)) {
                this.getSourcePathCombo().addPredefinedFile(project, nextDockerfile);
            }
        }
        this.myCommandPreviewField.setForeground(UIUtil.getInactiveTextColor());
        this.myHiddenPathJsonFileField.setVisible(false);
    }

    protected void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(1);
        }
        if (!this.myImageNotFileSource) {
            ((DockerDeploymentSourcePathCombo)this.mySourcePathCombo).resetUiFrom(configuration);
            this.myShouldRunContainerCheckbox.setSelected(!configuration.isBuildOnly());
        }
        this.myImageTextField.setText(configuration.getImageTag());
        this.myContainerNameTextField.setText(configuration.getContainerName());
        this.resetBuildArgsFrom(configuration);
        this.myContainerSettingsUI.resetEditorFrom(configuration);
        this.myHiddenPathJsonFileField.setText(configuration.getJSONFilePath());
    }

    private void resetBuildArgsFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(2);
        }
        if (this.myImageNotFileSource) {
            return;
        }
        this.getBuildArgsField().setEnvVars(configuration.getBuildArgs());
    }

    protected void applyEditorTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(3);
        }
        this.updatePreview();
        configuration.setImageTag(this.myImageTextField.getText());
        configuration.setContainerName(this.myContainerNameTextField.getText());
        if (!this.myImageNotFileSource) {
            this.getSourcePathCombo().applyUiTo(configuration);
            configuration.setBuildOnly(!this.myShouldRunContainerCheckbox.isSelected());
        }
        this.applyBuildArgsTo(configuration);
        this.myContainerSettingsUI.applyEditorTo(configuration);
        if (!StringUtil.isEmptyOrSpaces((String)this.myHiddenPathJsonFileField.getText())) {
            throw new RuntimeConfigurationWarning(DockerBundle.getText("DockerDeploymentEditor.error.json.file.is.not.supported", new Object[0]), () -> {
                if (configuration == null) {
                    DockerDeploymentEditor.$$$reportNull$$$0(7);
                }
                this.migrateUnsupportedJSONFile(configuration);
            });
        }
        configuration.setJSONFilePath(this.myHiddenPathJsonFileField.getText());
    }

    private void migrateUnsupportedJSONFile(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(4);
        }
        Optional.ofNullable(configuration.getJSONFilePath()).map(FileUtil::toSystemDependentName).map(arg_0 -> ((LocalFileSystem)LocalFileSystem.getInstance()).findFileByPath(arg_0)).ifPresent(vFile -> FileEditorManager.getInstance((Project)this.myProject).openFile(vFile, true));
        this.myHiddenPathJsonFileField.setText(null);
    }

    private void applyBuildArgsTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(5);
        }
        if (this.myImageNotFileSource) {
            configuration.setBuildArgs(null);
        } else {
            configuration.setBuildArgs(this.getBuildArgsField().getEnvVars());
        }
    }

    private void updatePreview() {
        String imageTag = this.myImageTextField.getText();
        if (StringUtil.isEmptyOrSpaces((String)imageTag)) {
            imageTag = "<image_tag>";
        }
        LinkedList<String> allLines = new LinkedList<String>();
        if (!this.myImageNotFileSource) {
            DockerBuildCliBuilder builder = new DockerBuildCliBuilder();
            builder.setDockerFile(this.getSourcePathCombo().getValueToApply());
            for (Map.Entry<String, String> argEntry : this.getBuildArgsField().getPairs().entrySet()) {
                if (argEntry.getKey() == null) continue;
                builder.addBuildArg(argEntry.getKey(), argEntry.getValue());
            }
            builder.setImageTag(imageTag);
            List<String> buildLines = builder.buildPreviewLines();
            allLines.add(buildLines.stream().collect(Collectors.joining(" ")));
        }
        if (this.myImageNotFileSource || this.myShouldRunContainerCheckbox.isSelected()) {
            DockerRunCliBuilder runBuilder = this.myContainerSettingsUI.prepareRunCliBuilder(imageTag);
            runBuilder.setContainerTag(this.myContainerNameTextField.getText());
            allLines.addAll(runBuilder.buildPreviewLines(!allLines.isEmpty()));
        }
        this.getCommandPreviewField().setSplittedText(allLines);
    }

    private void createUIComponents() {
        this.mySourcePathCombo = new DockerDeploymentSourcePathCombo();
        this.myBuildArgsField = new BuildArgsField();
        this.myContainerSettingsUI = new DockerContainerSettingsUI(this.myProject);
        this.myContainerOptionsPanel = this.myContainerSettingsUI.getMainPanel();
        this.myCommandPreviewField = new CommandPreviewField();
    }

    private void onSourcePathChanged() {
        String path = this.getSourcePathCombo().getValueToApply();
        File file = DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(this.myProject, path);
        this.myContainerSettingsUI.setContextFolder(file == null ? null : file.getParentFile());
    }

    private DockerDeploymentSourcePathCombo getSourcePathCombo() {
        return (DockerDeploymentSourcePathCombo)this.mySourcePathCombo;
    }

    private DockerEnvVarFieldWithBrowseButton getBuildArgsField() {
        return (BuildArgsField)this.myBuildArgsField;
    }

    private CommandPreviewField getCommandPreviewField() {
        return (CommandPreviewField)this.myCommandPreviewField;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerDeploymentEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerDeploymentEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetBuildArgsFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "migrateUnsupportedJSONFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyBuildArgsTo";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyEditorTo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        JTextField jTextField2;
        JTextField jTextField3;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySourcePathLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Dockerfile:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.mySourcePathCombo;
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myImageTextField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myContainerNameTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myImageLabel = jBLabel = new JBLabel();
        jBLabel.setText("Image tag:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Container name:");
        jPanel.add((Component)jBLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myShouldRunContainerCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Run built image");
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myBuildArgsField;
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myBuildArgsLabel = jLabel = new JLabel();
        jLabel.setText("Build args:");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.myContainerOptionsPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setEnabled(false);
        jBLabel4.setText("Command preview:");
        jPanel.add((Component)jBLabel4, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ExpandableTextField expandableTextField = this.myCommandPreviewField;
        expandableTextField.setEditable(false);
        expandableTextField.setEnabled(true);
        jPanel.add((Component)expandableTextField, new GridConstraints(6, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myHiddenPathJsonFileField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(7, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel2.setLabelFor((Component)comboboxWithBrowseButton);
        jBLabel.setLabelFor(jTextField3);
        jBLabel3.setLabelFor(jTextField2);
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel4.setLabelFor((Component)expandableTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class CommandPreviewField
    extends ExpandableTextField {
        private final ExternalSplitter mySplitter;

        public CommandPreviewField() {
            this(new ExternalSplitter());
        }

        public CommandPreviewField(ExternalSplitter splitter) {
            super((Function)splitter, ParametersListUtil.DEFAULT_LINE_JOINER);
            this.mySplitter = splitter;
        }

        public void setSplittedText(@NotNull List<String> split) {
            String text;
            boolean changed;
            if (split == null) {
                CommandPreviewField.$$$reportNull$$$0(0);
            }
            if (changed = this.mySplitter.setTextAndCustomSplit(text = (String)ParametersListUtil.DEFAULT_LINE_JOINER.fun(split), split)) {
                super.setText(text);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "split", "com/intellij/docker/deployment/ui/DockerDeploymentEditor$CommandPreviewField", "setSplittedText"));
        }

        static class ExternalSplitter
        implements Function<String, List<String>> {
            private String myExpectedText;
            private List<String> myExpectedSplit;

            ExternalSplitter() {
            }

            public boolean setTextAndCustomSplit(@NotNull String expectedText, @NotNull List<String> expectedSplit) {
                boolean changed;
                if (expectedText == null) {
                    ExternalSplitter.$$$reportNull$$$0(0);
                }
                if (expectedSplit == null) {
                    ExternalSplitter.$$$reportNull$$$0(1);
                }
                boolean bl = changed = !expectedText.equals(this.myExpectedText);
                if (changed) {
                    this.myExpectedText = expectedText;
                    this.myExpectedSplit = expectedSplit;
                }
                return changed;
            }

            public List<String> fun(String text) {
                if (this.myExpectedText == null) {
                    throw new IllegalStateException("I am not ready to split anything");
                }
                if (!text.equals(this.myExpectedText)) {
                    // empty if block
                }
                return this.myExpectedSplit;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expectedText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expectedSplit";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/deployment/ui/DockerDeploymentEditor$CommandPreviewField$ExternalSplitter";
                objectArray[2] = "setTextAndCustomSplit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class BuildArgsField
    extends DockerEnvVarFieldWithBrowseButton {
        public BuildArgsField() {
            super(DockerBundle.getText("DockerDeploymentEditor.BuildArgsField.dialogTitle", new Object[0]), DockerBundle.getText("DockerDeploymentEditor.BuildArgsField.dialogEmptyText", new Object[0]));
        }
    }
}

