/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeConfigurationUtil {
    private static final List<String> DOCKER_COMPOSE_SUPPORTED_FILENAMES = ImmutableList.of((Object)"docker-compose.yml", (Object)"docker-compose.yaml");
    private static final String DOCKER_COMPOSE_OVERRIDE_FILENAME = "docker-compose.override.yml";
    private static final String DEFAULT_DOCKER_COMPOSE_PROJECT_NAME = "default";

    private DockerComposeConfigurationUtil() {
    }

    @NotNull
    public static List<Path> findConfigurationFiles(@NotNull List<String> configurationPathnames) throws FileNotFoundException {
        if (configurationPathnames == null) {
            DockerComposeConfigurationUtil.$$$reportNull$$$0(0);
        }
        if (configurationPathnames.isEmpty()) {
            throw new IllegalArgumentException("Configuration path name list must not be empty");
        }
        String mainConfigurationPathname = configurationPathnames.get(0);
        if (Files.isDirectory(Paths.get(mainConfigurationPathname, new String[0]), new LinkOption[0])) {
            List<Path> list = DockerComposeConfigurationUtil.findConfigurationFiles(mainConfigurationPathname);
            if (list == null) {
                DockerComposeConfigurationUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<Path> list = Stream.concat(Stream.of(Paths.get(mainConfigurationPathname, new String[0])), configurationPathnames.stream().skip(1L).map(pathname -> Paths.get(pathname, new String[0])).filter(path -> Files.exists(path, new LinkOption[0]))).collect(Collectors.toList());
        if (list == null) {
            DockerComposeConfigurationUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<Path> findConfigurationFiles(@NotNull String configurationPathname) throws FileNotFoundException {
        Path path;
        if (configurationPathname == null) {
            DockerComposeConfigurationUtil.$$$reportNull$$$0(3);
        }
        if (Files.isDirectory(path = Paths.get(configurationPathname, new String[0]), new LinkOption[0])) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Path configurationPath = DockerComposeConfigurationUtil.findDockerComposeConfigurationPath(path);
            builder.add((Object)configurationPath);
            Path overrideConfiguration = configurationPath.resolveSibling(DOCKER_COMPOSE_OVERRIDE_FILENAME);
            if (Files.isRegularFile(overrideConfiguration, new LinkOption[0])) {
                builder.add((Object)overrideConfiguration);
            }
            ImmutableList immutableList = builder.build();
            if (immutableList == null) {
                DockerComposeConfigurationUtil.$$$reportNull$$$0(4);
            }
            return immutableList;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            List<Path> list = Collections.singletonList(path);
            if (list == null) {
                DockerComposeConfigurationUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        throw new FileNotFoundException(String.format("Neither folder nor file \"%s\" exists", path));
    }

    @NotNull
    private static Path findDockerComposeConfigurationPath(@NotNull Path folder) throws FileNotFoundException {
        if (folder == null) {
            DockerComposeConfigurationUtil.$$$reportNull$$$0(6);
        }
        for (String filename : DOCKER_COMPOSE_SUPPORTED_FILENAMES) {
            Path configurationPath = folder.resolve(filename);
            if (!Files.isRegularFile(configurationPath, new LinkOption[0])) continue;
            Path path = configurationPath;
            if (path == null) {
                DockerComposeConfigurationUtil.$$$reportNull$$$0(7);
            }
            return path;
        }
        throw new FileNotFoundException(String.format("Can't find a suitable configuration file in this directory. Supported filenames: %s", Joiner.on((String)", ").join(DOCKER_COMPOSE_SUPPORTED_FILENAMES)));
    }

    @NotNull
    public static String getDockerComposeProjectName(@NotNull Path composeFilePath) {
        Path parent;
        if (composeFilePath == null) {
            DockerComposeConfigurationUtil.$$$reportNull$$$0(8);
        }
        if ((parent = composeFilePath.toAbsolutePath().getParent()) == null || parent.getFileName() == null) {
            if (DEFAULT_DOCKER_COMPOSE_PROJECT_NAME == null) {
                DockerComposeConfigurationUtil.$$$reportNull$$$0(9);
            }
            return DEFAULT_DOCKER_COMPOSE_PROJECT_NAME;
        }
        String string = parent.getFileName().toString();
        if (string == null) {
            DockerComposeConfigurationUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static boolean isNamedVolumeBind(@NotNull String bindPath) {
        if (bindPath == null) {
            DockerComposeConfigurationUtil.$$$reportNull$$$0(11);
        }
        if ((bindPath = bindPath.trim()).isEmpty()) {
            return false;
        }
        if (DockerComposeConfigurationUtil.isWindowsAbsolutePath(bindPath)) {
            return false;
        }
        return !bindPath.startsWith("/") && !bindPath.startsWith("~") && !bindPath.startsWith(".");
    }

    private static boolean isWindowsAbsolutePath(@NotNull String path) {
        if (path == null) {
            DockerComposeConfigurationUtil.$$$reportNull$$$0(12);
        }
        return SystemInfo.isWindows && FileUtil.isAbsolute((String)path);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String escapeDollarSigns(@Nullable String string) {
        return string != null ? string.replaceAll("\\$", "\\$\\$") : null;
    }

    @Contract(value="null -> null; !null -> !null")
    public static Map<String, String> escapeDollarSigns(@Nullable Map<String, String> envs) {
        if (envs == null) {
            return null;
        }
        return envs.entrySet().stream().collect(Collectors.toMap(entry -> DockerComposeConfigurationUtil.escapeDollarSigns((String)entry.getKey()), entry -> DockerComposeConfigurationUtil.escapeDollarSigns((String)entry.getValue())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationPathnames";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationPathname";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composeFilePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/configuration/util/DockerComposeConfigurationUtil";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurationFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findDockerComposeConfigurationPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposeProjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationFiles";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDockerComposeConfigurationPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDockerComposeProjectName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isNamedVolumeBind";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isWindowsAbsolutePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

