/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeEnvironment;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeConfigurationParser {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>\\d+)(\\.\\d+)?");
    public static final String VERSION_3 = "3";
    @NotNull
    private final ObjectMapper myMapper;

    public DockerComposeConfigurationParser() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        SimpleModule module = new SimpleModule();
        module.addDeserializer(DockerComposeConfiguration.class, (JsonDeserializer)new DockerComposeConfigurationDeserializer());
        module.addDeserializer(DockerComposeEnvironment.class, (JsonDeserializer)new DockerComposeEnvironmentDeserializer());
        mapper.registerModule((Module)module);
        this.myMapper = mapper;
    }

    @NotNull
    DockerComposeConfiguration parseBean(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            DockerComposeConfigurationParser.$$$reportNull$$$0(0);
        }
        DockerComposeConfiguration dockerComposeConfiguration = (DockerComposeConfiguration)this.myMapper.readValue(reader, DockerComposeConfiguration.class);
        if (dockerComposeConfiguration == null) {
            DockerComposeConfigurationParser.$$$reportNull$$$0(1);
        }
        return dockerComposeConfiguration;
    }

    @NotNull
    public DockerComposeConfiguration parseBean(@NotNull String dockerComposeFilePath) throws IOException {
        if (dockerComposeFilePath == null) {
            DockerComposeConfigurationParser.$$$reportNull$$$0(2);
        }
        DockerComposeConfiguration dockerComposeConfiguration = this.parseBean(dockerComposeFilePath, false);
        if (dockerComposeConfiguration == null) {
            DockerComposeConfigurationParser.$$$reportNull$$$0(3);
        }
        return dockerComposeConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DockerComposeConfiguration parseBean(@NotNull String dockerComposeFilePath, boolean ensureIsUpToDate) throws IOException {
        if (dockerComposeFilePath == null) {
            DockerComposeConfigurationParser.$$$reportNull$$$0(4);
        }
        if (ensureIsUpToDate) {
            DockerComposeConfigurationParser.saveDockerComposeFile(dockerComposeFilePath);
        }
        FileReader reader = new FileReader(dockerComposeFilePath);
        DockerComposeConfiguration dockerComposeConfiguration = this.parseBean(reader);
        DockerComposeConfiguration dockerComposeConfiguration2 = dockerComposeConfiguration;
        if (dockerComposeConfiguration2 == null) {
            DockerComposeConfigurationParser.$$$reportNull$$$0(5);
        }
        return dockerComposeConfiguration2;
        finally {
            reader.close();
        }
    }

    private static void saveDockerComposeFile(@NotNull String dockerComposeFilePath) {
        VirtualFile file;
        if (dockerComposeFilePath == null) {
            DockerComposeConfigurationParser.$$$reportNull$$$0(6);
        }
        if ((file = LocalFileSystem.getInstance().findFileByPath(dockerComposeFilePath)) != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                FileDocumentManager documentManager = FileDocumentManager.getInstance();
                Document document = documentManager.getDocument(file);
                if (document != null && documentManager.isDocumentUnsaved(document)) {
                    documentManager.saveDocument(document);
                }
            });
        }
    }

    @NotNull
    public static DockerComposeConfigurationParser newInstance() {
        DockerComposeConfigurationParser dockerComposeConfigurationParser = new DockerComposeConfigurationParser();
        if (dockerComposeConfigurationParser == null) {
            DockerComposeConfigurationParser.$$$reportNull$$$0(7);
        }
        return dockerComposeConfigurationParser;
    }

    @Nullable
    public static String getMajorVersion(@NotNull String version) {
        Matcher matcher;
        if (version == null) {
            DockerComposeConfigurationParser.$$$reportNull$$$0(8);
        }
        return (matcher = VERSION_PATTERN.matcher(version)).matches() ? matcher.group("major") : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/configuration/beans/DockerComposeConfigurationParser";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeFilePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/configuration/beans/DockerComposeConfigurationParser";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBean";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseBean";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveDockerComposeFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMajorVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DockerComposeEnvironmentDeserializer
    extends JsonDeserializer<DockerComposeEnvironment> {
        private DockerComposeEnvironmentDeserializer() {
        }

        public DockerComposeEnvironment deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            TreeNode node = jp.readValueAsTree();
            if (node.isArray()) {
                List list = (List)DockerComposeConfigurationParser.this.myMapper.convertValue((Object)node, (JavaType)context.getTypeFactory().constructCollectionType(List.class, String.class));
                return DockerComposeEnvironment.fromList(list);
            }
            if (node.isObject()) {
                Map map = (Map)DockerComposeConfigurationParser.this.myMapper.convertValue((Object)node, (JavaType)context.getTypeFactory().constructMapType(Map.class, String.class, Object.class));
                return DockerComposeEnvironment.fromMap(map);
            }
            throw context.mappingException("Environment is expected to be either dictionary or list");
        }
    }

    private class DockerComposeConfigurationDeserializer
    extends JsonDeserializer<DockerComposeConfiguration> {
        private DockerComposeConfigurationDeserializer() {
        }

        public DockerComposeConfiguration deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            JsonNode versionField = node.get("version");
            if (versionField != null && versionField.isTextual()) {
                String version = versionField.textValue();
                String majorVersion = DockerComposeConfigurationParser.getMajorVersion(version);
                if ("2".equals(majorVersion) || DockerComposeConfigurationParser.VERSION_3.equals(majorVersion)) {
                    return (DockerComposeConfiguration)DockerComposeConfigurationParser.this.myMapper.treeToValue((TreeNode)node, DockerComposeConfigurationV2.class);
                }
                throw context.mappingException("Unsupported docker compose configuration version: %s", new Object[]{version});
            }
            return (DockerComposeConfiguration)DockerComposeConfigurationParser.this.myMapper.treeToValue((TreeNode)node, DockerComposeConfigurationV1.class);
        }
    }
}

