/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.cli;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerSettings;
import com.intellij.docker.compose.cli.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeDownCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeRunCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStartCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStopCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeUpCliBuilder;
import com.intellij.docker.machine.DockerMachineConfigurable;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b\u001a-\u0010\u0014\u001a\u0002H\u0015\"\u000e\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u0002H\u0015H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\u0018\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\f\u0010\u001f\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\u000e\u0010 \u001a\u0004\u0018\u00010\u001c*\u00020\u001cH\u0002\u001a)\u0010!\u001a\u0002H\u0015\"\u000e\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u0016*\u0002H\u00152\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"DEFAULT_TIMEOUT_SECONDS", "", "HTTPS_URL_SCHEMA", "", "HTTP_URL_SCHEMA", "TCP_URL_SCHEMA", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "buildDownCommand", "Lcom/intellij/docker/compose/cli/DockerComposeDownCliBuilder;", "dockerRuntime", "Lcom/intellij/docker/remote/run/runtime/RemoteDockerRuntime;", "buildRunCommand", "Lcom/intellij/docker/compose/cli/DockerComposeRunCliBuilder;", "buildStartCommand", "Lcom/intellij/docker/compose/cli/DockerComposeStartCliBuilder;", "buildStopCommand", "Lcom/intellij/docker/compose/cli/DockerComposeStopCliBuilder;", "buildUpCommand", "Lcom/intellij/docker/compose/cli/DockerComposeUpCliBuilder;", "initBuilder", "T", "Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "builder", "(Lcom/intellij/docker/remote/run/runtime/RemoteDockerRuntime;Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;)Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "notifyDockerComposeExecutionFailed", "", "project", "Lcom/intellij/openapi/project/Project;", "e", "Lcom/intellij/execution/process/ProcessNotCreatedException;", "fixApiUrlSchema", "notDisposedOrNull", "setupDockerEngineParameters", "configuration", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;Lcom/intellij/docker/DockerCloudConfiguration;)Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "intellij.clouds.docker"})
@JvmName(name="DockerComposeCliUtil")
public final class DockerComposeCliUtil {
    private static final NotificationGroup notificationGroup = new NotificationGroup("Docker Compose", NotificationDisplayType.BALLOON, true);
    public static final int DEFAULT_TIMEOUT_SECONDS = 10;
    private static final String HTTP_URL_SCHEMA = "http://";
    private static final String HTTPS_URL_SCHEMA = "https://";
    private static final String TCP_URL_SCHEMA = "tcp://";

    @NotNull
    public static final DockerComposeRunCliBuilder buildRunCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkParameterIsNotNull((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeRunCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeRunCliBuilder());
    }

    @NotNull
    public static final DockerComposeUpCliBuilder buildUpCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkParameterIsNotNull((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeUpCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeUpCliBuilder());
    }

    @NotNull
    public static final DockerComposeDownCliBuilder buildDownCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkParameterIsNotNull((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeDownCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeDownCliBuilder());
    }

    @NotNull
    public static final DockerComposeStartCliBuilder buildStartCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkParameterIsNotNull((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeStartCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeStartCliBuilder());
    }

    @NotNull
    public static final DockerComposeStopCliBuilder buildStopCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkParameterIsNotNull((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeStopCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeStopCliBuilder());
    }

    private static final <T extends AbstractDockerComposeCmdCliBuilder<T>> T initBuilder(RemoteDockerRuntime dockerRuntime, T builder) {
        DockerSettings dockerSettings = DockerSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)dockerSettings, (String)"DockerSettings.getInstance()");
        String dockerComposePath = dockerSettings.getDockerComposePath();
        DockerCloudConfiguration dockerCloudConfiguration = dockerRuntime.getAccount();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dockerCloudConfiguration), (String)"dockerRuntime.account");
        T t = DockerComposeCliUtil.setupDockerEngineParameters(builder, dockerCloudConfiguration);
        String string = dockerComposePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dockerComposePath");
        return t.withDockerComposeExecutable(string);
    }

    private static final <T extends AbstractDockerComposeCmdCliBuilder<T>> T setupDockerEngineParameters(@NotNull T $receiver, DockerCloudConfiguration configuration) {
        CharSequence charSequence;
        String string = configuration.getApiUrl();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.apiUrl");
        $receiver.withDockerHost(DockerComposeCliUtil.fixApiUrlSchema(string));
        String string2 = StringKt.nullize((String)configuration.getCertificatesPath(), (boolean)true);
        if (string2 != null) {
            String it = charSequence = string2;
            $receiver.withDockerCertPath(it);
            $receiver.withDockerTlsVerify("1");
        }
        if (SystemInfo.isWindows) {
            String string3 = configuration.getMachine();
            if (string3 != null) {
                charSequence = string3;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    $receiver.withComposeConvertWindowsPaths(true);
                }
            }
        }
        return $receiver;
    }

    @NotNull
    public static final String fixApiUrlSchema(@NotNull String $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (StringsKt.startsWith$default((String)$receiver, (String)HTTP_URL_SCHEMA, (boolean)false, (int)2, null)) {
            String string2 = $receiver;
            int n = HTTP_URL_SCHEMA.length();
            StringBuilder stringBuilder = new StringBuilder().append(TCP_URL_SCHEMA);
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string3;
            string = stringBuilder.append(string4).toString();
        } else if (StringsKt.startsWith$default((String)$receiver, (String)HTTPS_URL_SCHEMA, (boolean)false, (int)2, null)) {
            String string5 = $receiver;
            int n = HTTPS_URL_SCHEMA.length();
            StringBuilder stringBuilder = new StringBuilder().append(TCP_URL_SCHEMA);
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String string7 = string6;
            string = stringBuilder.append(string7).toString();
        } else {
            string = $receiver;
        }
        return string;
    }

    public static final void notifyDockerComposeExecutionFailed(@Nullable Project project, @NotNull ProcessNotCreatedException e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        String title = "Docker Compose Execution Failed";
        String content = e.getLocalizedMessage();
        notificationGroup.createNotification(title, content, NotificationType.WARNING, null).addAction((AnAction)new NotificationAction(project, "Show Settings..."){
            final /* synthetic */ Project $project;

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                Project project = this.$project;
                ShowSettingsUtil.getInstance().showSettingsDialog((Project)(project != null ? DockerComposeCliUtil.access$notDisposedOrNull(project) : null), DockerMachineConfigurable.class);
            }
            {
                this.$project = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }).notify(project);
    }

    private static final Project notDisposedOrNull(@NotNull Project $receiver) {
        return $receiver.isDisposed() ? null : $receiver;
    }

    @Nullable
    public static final /* synthetic */ Project access$notDisposedOrNull(@NotNull Project $receiver) {
        return DockerComposeCliUtil.notDisposedOrNull($receiver);
    }
}

