/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.cli;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u001c\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/compose/cli/DockerComposeCli;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "versionCommand", "", "extractDockerComposeVersion", "stdout", "getVersion", "dockerComposeExePath", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runCommand", "Lcom/intellij/execution/process/ProcessOutput;", "cmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.clouds.docker"})
public final class DockerComposeCli {
    private static final Logger log;
    private static final String versionCommand = "--version";
    private static final Pattern pattern;
    public static final DockerComposeCli INSTANCE;

    @NotNull
    public final String getVersion(@NotNull String dockerComposeExePath, @Nullable ProgressIndicator indicator) throws ExecutionException {
        GeneralCommandLine cmd;
        Intrinsics.checkParameterIsNotNull((Object)dockerComposeExePath, (String)"dockerComposeExePath");
        GeneralCommandLine generalCommandLine = cmd = new GeneralCommandLine().withExePath(dockerComposeExePath).withParameters(new String[]{versionCommand});
        Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"cmd");
        ProcessOutput processOutput = this.runCommand(indicator, generalCommandLine);
        if (processOutput.getExitCode() != 0 || processOutput.isTimeout()) {
            if (processOutput.isTimeout()) {
                log.debug("" + processOutput.getStderr() + "\nTimed out");
                throw (Throwable)new ExecutionException("docker-compose version command timed out");
            }
            log.debug("" + processOutput.getStderr() + "\nExit code " + processOutput.getExitCode());
            throw (Throwable)new ExecutionException("docker-compose version command finished with non-zero exit code " + processOutput.getExitCode());
        }
        String string = processOutput.getStdout();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processOutput.stdout");
        return this.extractDockerComposeVersion(string);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String getVersion$default(DockerComposeCli dockerComposeCli, String string, ProgressIndicator progressIndicator, int n, Object object) throws ExecutionException {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return dockerComposeCli.getVersion(string, progressIndicator);
    }

    @NotNull
    public final String extractDockerComposeVersion(@NotNull String stdout) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)stdout, (String)"stdout");
        Matcher matcher = pattern.matcher(stdout);
        if (matcher.find()) {
            String string = matcher.group("version");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(\"version\")");
            return string;
        }
        throw (Throwable)new ExecutionException("Could not find version in docker-compose output: " + stdout);
    }

    private final ProcessOutput runCommand(ProgressIndicator indicator, GeneralCommandLine cmd) throws ExecutionException {
        Process process;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(cmd.getCommandLineList(null));
        try {
            Process process2 = processBuilder.start();
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"processBuilder.start()");
            process = process2;
        }
        catch (IOException e) {
            throw (Throwable)new ExecutionException((Throwable)e);
        }
        CapturingProcessHandler processHandler = new CapturingProcessHandler(process, cmd.getCharset(), cmd.getCommandLineString());
        if (indicator != null) {
            ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator);
            Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"processHandler.runProces\u2026gressIndicator(indicator)");
            return processOutput;
        }
        ProcessOutput processOutput = processHandler.runProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"processHandler.runProcess()");
        return processOutput;
    }

    private DockerComposeCli() {
    }

    static {
        DockerComposeCli dockerComposeCli;
        INSTANCE = dockerComposeCli = new DockerComposeCli();
        log = Logger.getInstance(DockerComposeCli.class);
        versionCommand = versionCommand;
        pattern = Pattern.compile("docker-compose version (?<version>.+), build (?<build>.+)");
    }
}

