/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.cli;

import com.intellij.docker.compose.cli.DockerComposeCommandProcessHandler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 %*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0005H\u0004J\b\u0010\u0018\u001a\u00020\u0005H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0007J\u0013\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010!\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\"\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001eJ\u0019\u0010#\u001a\u00028\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00028\u0000X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "T", "", "()V", "composeConvertWindowsPaths", "", "dockerCertPath", "", "dockerComposeExecutable", "dockerHost", "dockerTlsVerify", "paths", "", "Ljava/nio/file/Path;", "thisBuilder", "getThisBuilder", "()Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "workDirPath", "getWorkDirPath", "()Ljava/nio/file/Path;", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "buildCommandLineBeginning", "isDockerForWinFixRequired", "isDockerForWin", "run", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "withComposeConvertWindowsPaths", "(Z)Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "withDockerCertPath", "(Ljava/lang/String;)Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "withDockerComposeExecutable", "executable", "withDockerHost", "withDockerTlsVerify", "withFiles", "(Ljava/util/List;)Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "Companion", "intellij.clouds.docker"})
public abstract class AbstractDockerComposeCmdCliBuilder<T extends AbstractDockerComposeCmdCliBuilder<T>> {
    private String dockerComposeExecutable;
    private String dockerHost;
    private String dockerTlsVerify;
    private String dockerCertPath;
    private boolean composeConvertWindowsPaths;
    private List<? extends Path> paths;
    private static final String DOCKER_HOST_ENV_VAR = "DOCKER_HOST";
    private static final String DOCKER_TLS_VERIFY_ENV_VAR = "DOCKER_TLS_VERIFY";
    private static final String DOCKER_CERT_PATH_ENV_VAR = "DOCKER_CERT_PATH";
    private static final String COMPOSE_CONVERT_WINDOWS_PATHS_ENV_VAR = "COMPOSE_CONVERT_WINDOWS_PATHS";
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    protected abstract T getThisBuilder();

    @NotNull
    public final T withDockerComposeExecutable(@NotNull String executable) {
        T t;
        Intrinsics.checkParameterIsNotNull((Object)executable, (String)"executable");
        T $receiver = t = this.getThisBuilder();
        ((AbstractDockerComposeCmdCliBuilder)$receiver).dockerComposeExecutable = executable;
        return t;
    }

    @NotNull
    public final T withDockerHost(@NotNull String dockerHost) {
        T t;
        Intrinsics.checkParameterIsNotNull((Object)dockerHost, (String)"dockerHost");
        T $receiver = t = this.getThisBuilder();
        ((AbstractDockerComposeCmdCliBuilder)$receiver).dockerHost = dockerHost;
        return t;
    }

    @NotNull
    public final T withDockerTlsVerify(@NotNull String dockerTlsVerify) {
        T t;
        Intrinsics.checkParameterIsNotNull((Object)dockerTlsVerify, (String)"dockerTlsVerify");
        T $receiver = t = this.getThisBuilder();
        ((AbstractDockerComposeCmdCliBuilder)$receiver).dockerTlsVerify = dockerTlsVerify;
        return t;
    }

    @NotNull
    public final T withDockerCertPath(@NotNull String dockerCertPath) {
        T t;
        Intrinsics.checkParameterIsNotNull((Object)dockerCertPath, (String)"dockerCertPath");
        T $receiver = t = this.getThisBuilder();
        ((AbstractDockerComposeCmdCliBuilder)$receiver).dockerCertPath = dockerCertPath;
        return t;
    }

    @NotNull
    public final T withComposeConvertWindowsPaths(boolean composeConvertWindowsPaths) {
        T t;
        T $receiver = t = this.getThisBuilder();
        ((AbstractDockerComposeCmdCliBuilder)$receiver).composeConvertWindowsPaths = composeConvertWindowsPaths;
        return t;
    }

    @NotNull
    public final T withFiles(@NotNull List<? extends Path> paths) {
        T t;
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
        T $receiver = t = this.getThisBuilder();
        ((AbstractDockerComposeCmdCliBuilder)$receiver).paths = CollectionsKt.toList((Iterable)paths);
        return t;
    }

    @Nullable
    protected final Path getWorkDirPath() {
        Iterable<Path> iterable = this.paths;
        return iterable != null && (iterable = (Path)CollectionsKt.firstOrNull(iterable)) != null ? iterable.getParent() : null;
    }

    @NotNull
    protected final GeneralCommandLine buildCommandLineBeginning(boolean isDockerForWinFixRequired) {
        GeneralCommandLine commandLineBuilder = SystemInfo.isWindows ? new GeneralCommandLine() : (GeneralCommandLine)new PtyCommandLine();
        String string = this.dockerComposeExecutable;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dockerComposeExecutable");
        }
        commandLineBuilder.withExePath(string);
        Path path = this.getWorkDirPath();
        commandLineBuilder.withWorkDirectory(path != null ? ((Object)path).toString() : null);
        List<? extends Path> list = this.paths;
        if (list != null) {
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                Path path2 = (Path)element$iv;
                commandLineBuilder.addParameters(CollectionsKt.listOf((Object[])new String[]{"-f", ((Object)path2).toString()}));
            }
        }
        if (isDockerForWinFixRequired && this.isDockerForWin()) {
            AbstractDockerComposeCmdCliBuilder.Companion.getLOG().debug("Skip setting DOCKER_HOST=" + this.dockerHost + " environment variable due to \"OSError: [Errno 9] Bad file descriptor\" " + "error in `docker-compose up` command");
        } else {
            String it;
            String string2;
            String string3 = this.dockerHost;
            if (string3 != null) {
                it = string2 = string3;
                commandLineBuilder.withEnvironment(DOCKER_HOST_ENV_VAR, it);
            }
            String string4 = this.dockerTlsVerify;
            if (string4 != null) {
                it = string2 = string4;
                commandLineBuilder.withEnvironment(DOCKER_TLS_VERIFY_ENV_VAR, it);
            }
            String string5 = this.dockerCertPath;
            if (string5 != null) {
                it = string2 = string5;
                commandLineBuilder.withEnvironment(DOCKER_CERT_PATH_ENV_VAR, it);
            }
        }
        if (this.composeConvertWindowsPaths) {
            commandLineBuilder.withEnvironment(COMPOSE_CONVERT_WINDOWS_PATHS_ENV_VAR, "1");
        }
        return commandLineBuilder;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ GeneralCommandLine buildCommandLineBeginning$default(AbstractDockerComposeCmdCliBuilder abstractDockerComposeCmdCliBuilder, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildCommandLineBeginning");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return abstractDockerComposeCmdCliBuilder.buildCommandLineBeginning(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDockerForWin() {
        String string;
        if (!SystemInfo.isWindows) return false;
        String string2 = this.dockerHost;
        String string3 = string2;
        if (string2 == null) return false;
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        string3 = string5;
        if (string5 == null) return false;
        string = string3;
        String it = string;
        if (!StringsKt.endsWith$default((String)it, (String)"localhost:2375", (boolean)false, (int)2, null)) {
            if (!StringsKt.endsWith$default((String)it, (String)"127.0.0.1:2375", (boolean)false, (int)2, null)) return false;
        }
        boolean bl = true;
        if (!bl) return false;
        if (this.dockerTlsVerify != null) return false;
        if (this.dockerCertPath != null) return false;
        return true;
    }

    @NotNull
    public abstract GeneralCommandLine buildCommandLine();

    @NotNull
    public final KillableColoredProcessHandler run() throws ExecutionException {
        GeneralCommandLine generalCommandLine = this.buildCommandLine();
        return new DockerComposeCommandProcessHandler(generalCommandLine);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(AbstractDockerComposeCmdCliBuilder.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder$Companion;", "", "()V", "COMPOSE_CONVERT_WINDOWS_PATHS_ENV_VAR", "", "DOCKER_CERT_PATH_ENV_VAR", "DOCKER_HOST_ENV_VAR", "DOCKER_TLS_VERIFY_ENV_VAR", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clouds.docker"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

