/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.docker.agent.cli.DockerCliParserBase;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.NotNull;

public abstract class DockerCliSplitterBase
extends DockerCliParserBase<NormalizedCommandLine> {

    protected static class MemoryOptionPrinter
    extends DockerCliParserBase.MemoryOptionHandler<NormalizedCommandLine> {
        public MemoryOptionPrinter(Option option) {
            super(option, null);
        }

        protected void handleEachValue(String value) {
            this.parseMemory(value);
            ((NormalizedCommandLine)this.getCmd()).registerOneValue(this.getOption(), value);
        }
    }

    protected static class MappedListPrinter
    extends DockerCliParserBase.MappedListHandler<NormalizedCommandLine, String> {
        public MappedListPrinter(Option option) {
            super(option, String.class, Function.identity(), (cmd, strings) -> cmd.registerMany(option, (String[])strings));
        }
    }

    protected static class StringListPrinter
    extends DockerCliParserBase.StringListHandler<NormalizedCommandLine> {
        public StringListPrinter(Option option) {
            this(option, false);
        }

        public StringListPrinter(Option option, boolean preferSeparateLine) {
            super(option, (cmd, strings) -> cmd.registerMany(option, (String[])strings, preferSeparateLine));
        }
    }

    protected static class BooleanValuePrinter
    extends DockerCliParserBase.BooleanOptionHandler<NormalizedCommandLine> {
        public BooleanValuePrinter(Option option) {
            super(option);
        }

        protected void handleBooleanValue(boolean value) {
            ((NormalizedCommandLine)this.getCmd()).registerOneValue(this.getOption(), value);
        }
    }

    protected static class DoubleValuePrinter
    extends DockerCliParserBase.DoubleOptionHandler<NormalizedCommandLine> {
        private static final DecimalFormat FORMAT = new DecimalFormat("#.######");

        public DoubleValuePrinter(Option option) {
            super(option, (cmd, value) -> cmd.registerOneValue(option, FORMAT.format(value)));
        }
    }

    protected static class IntegerValuePrinter
    extends DockerCliParserBase.IntegerOptionHandler<NormalizedCommandLine> {
        public IntegerValuePrinter(Option option) {
            super(option, (cmd, value) -> cmd.registerOneValue(option, (int)value));
        }
    }

    protected static class SingleValuePrinter
    extends DockerCliParserBase.SingleValueHandler<NormalizedCommandLine> {
        public SingleValuePrinter(Option option) {
            super(option);
        }

        protected void handleEachValue(String value) {
            ((NormalizedCommandLine)this.getCmd()).registerOneValue(this.getOption(), value);
        }
    }

    public static class NormalizedCommandLine {
        private final MultiMap<Option, String> myGrouped = MultiMap.createLinked();
        private final Set<Option> myOneValuePerLineOptions = new HashSet<Option>();

        public void registerOneValue(Option option, String value) {
            this.myGrouped.putValue((Object)option, (Object)NormalizedCommandLine.encodeSpaces(value));
        }

        public void registerOneValue(Option option, int value) {
            this.myGrouped.putValue((Object)option, (Object)String.valueOf(value));
        }

        public void registerOneValue(Option option, boolean value) {
            if (option.hasOptionalArg() && value) {
                this.myGrouped.putValue((Object)option, (Object)"");
            } else {
                this.myGrouped.putValue((Object)option, (Object)String.valueOf(value));
            }
        }

        public void registerMany(Option option, String[] value) {
            this.registerMany(option, value, false);
        }

        public void registerMany(Option option, String[] value, boolean preferSeparateLine) {
            for (String next : value) {
                this.myGrouped.putValue((Object)option, (Object)NormalizedCommandLine.encodeSpaces(next));
            }
            if (preferSeparateLine) {
                this.myOneValuePerLineOptions.add(option);
            }
        }

        public List<String> groupByOptions() {
            LinkedList<String> result = new LinkedList<String>();
            for (Map.Entry entry : this.myGrouped.entrySet()) {
                Option nextOption = (Option)entry.getKey();
                String optionKey = nextOption.getOpt() == null ? "--" + nextOption.getLongOpt() : "-" + nextOption.getOpt();
                List pieces = ((Collection)entry.getValue()).stream().map(val -> optionKey + " " + val).collect(Collectors.toList());
                if (this.myOneValuePerLineOptions.contains(nextOption)) {
                    result.addAll(pieces);
                    continue;
                }
                result.add(pieces.stream().collect(Collectors.joining(" ")));
            }
            return result;
        }

        @NotNull
        private static String encodeSpaces(String value) {
            if (value == null) {
                String string = String.valueOf(null);
                if (string == null) {
                    NormalizedCommandLine.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (value.contains(" ")) {
                String string = ParametersListUtil.join((String[])new String[]{value});
                if (string == null) {
                    NormalizedCommandLine.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = value;
            if (string == null) {
                NormalizedCommandLine.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/cli/DockerCliSplitterBase$NormalizedCommandLine", "encodeSpaces"));
        }
    }
}

