/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.PullImageConfigurable;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.stats.DockerUsageKind;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.impl.runtime.ui.tree.actions.ServersTreeAction;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import icons.DockerIcons;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PullImageAction
extends ServersTreeAction<ServersTreeNode> {
    public PullImageAction() {
        super(DockerBundle.getText("PullImageAction.text", new Object[0]), DockerBundle.getText("PullImageAction.description", new Object[0]), DockerIcons.PullImage);
    }

    protected Class<ServersTreeNode> getTargetNodeClass() {
        return ServersTreeNode.class;
    }

    protected boolean isEnabled4(ServersTreeNode node) {
        if (node instanceof ServersTreeStructure.RemoteServerNode) {
            return ((ServersTreeStructure.RemoteServerNode)node).isConnected();
        }
        return PullImageAction.isImagesGroup(node);
    }

    protected void doActionPerformed(final @NotNull ServersToolWindowContent content, AnActionEvent e, ServersTreeNode node) {
        if (content == null) {
            PullImageAction.$$$reportNull$$$0(0);
        }
        final ServerConnection connection = Optional.ofNullable(node).map(PullImageAction::getRemoteServer).map(arg_0 -> ((ServerConnectionManager)ServerConnectionManager.getInstance()).getConnection(arg_0)).orElse(null);
        if (connection == null) {
            return;
        }
        connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

            public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    1.$$$reportNull$$$0(0);
                }
                PullImageAction.doPullImage(content.getProject(), (DockerServerRuntimeInstance)serverRuntimeInstance, (ParameterizedRunnable<String>)new ImageSelectionCase(connection, content));
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverRuntimeInstance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/action/PullImageAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PullImageAction.$$$reportNull$$$0(1);
        }
        UsageTrigger.trigger((String)DockerUsageKind.forActionPerformed((AnAction)this, e));
        super.actionPerformed(e);
    }

    private static void doPullImage(Project project, DockerServerRuntimeInstance serverRuntime, ParameterizedRunnable<String> onSuccess) {
        DockerRepositoryModel model = new DockerRepositoryModel();
        if (!ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PullImageConfigurable(model))) {
            return;
        }
        serverRuntime.pullImage(project, model, onSuccess);
    }

    protected boolean isVisible4(ServersTreeNode node) {
        if (node instanceof ServersTreeStructure.RemoteServerNode) {
            ServersTreeStructure.RemoteServerNode nodeImpl = (ServersTreeStructure.RemoteServerNode)node;
            return nodeImpl.getServer().getType() == DockerCloudType.getInstance();
        }
        return PullImageAction.isImagesGroup(node) && PullImageAction.getRemoteServer(node) != null;
    }

    private static boolean isImagesGroup(ServersTreeNode node) {
        return node instanceof ServersTreeStructure.DeploymentNodeImpl && PullImageAction.isImagesGroup(((ServersTreeStructure.DeploymentNodeImpl)node).getDeployment().getRuntime());
    }

    private static boolean isImagesGroup(@Nullable DeploymentRuntime deploymentRuntime) {
        return deploymentRuntime instanceof DockerGroupRuntime.ImagesGroup;
    }

    protected static RemoteServer<?> getRemoteServer(@Nullable ServersTreeNode node) {
        if (node instanceof ServersTreeStructure.DeploymentNodeImpl) {
            node = ((ServersTreeStructure.DeploymentNodeImpl)node).getServerNode();
        }
        return node instanceof ServersTreeStructure.RemoteServerNode ? ((ServersTreeStructure.RemoteServerNode)node).getServer() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/action/PullImageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doActionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ImageSelectionCase
    implements ParameterizedRunnable<String> {
        private final ServerConnection<?> myConnection;
        private final ServersToolWindowContent myContent;

        public ImageSelectionCase(ServerConnection<?> connection, ServersToolWindowContent content) {
            this.myConnection = connection;
            this.myContent = content;
        }

        public void run(String imageRepoTag) {
            Semaphore semaphore = new Semaphore();
            semaphore.down();
            this.myConnection.computeDeployments(() -> {
                semaphore.up();
                for (Deployment deployment : this.myConnection.getDeployments()) {
                    Set<String> repoTags;
                    DockerApplicationRuntime applicationRuntime = (DockerApplicationRuntime)deployment.getRuntime();
                    if (applicationRuntime == null || (repoTags = applicationRuntime.getImageRepoTags()) == null || !repoTags.contains(imageRepoTag)) continue;
                    UIUtil.invokeLaterIfNeeded(() -> this.myContent.select(this.myConnection, deployment.getName()));
                    break;
                }
            });
            semaphore.waitFor();
        }
    }
}

