/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.IntelliJLogSettings;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerParseCliConfig;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.cli.DockerParseCliCallback;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.machine.DockerConnectionInfo;
import com.intellij.docker.machine.DockerMachine;
import com.intellij.docker.machine.DockerMachineException;
import com.intellij.docker.registry.DockerAgentRepositoryConfigImpl;
import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.RegistryAuthCallback;
import com.intellij.docker.registry.RegistryRuntimeTask;
import com.intellij.docker.runtimes.ComposeDeploymentRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeploymentRuntime;
import com.intellij.docker.runtimes.DockerRuntimesCache;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ParameterizedRunnable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerServerRuntimeInstance
extends CloudServerRuntimeInstance<DockerDeploymentConfiguration, DockerAgent, DockerCloudConfiguration> {
    private static final Logger LOG = Logger.getInstance(DockerServerRuntimeInstance.class);
    private static final String SPECIFICS_MODULE_NAME = "intellij.clouds.docker.agent.impl.rt";
    private static final String SPECIFICS_JAR_PATH = "specifics/dockerSpecifics.jar";
    private final DockerRuntimesCache myRuntimesCache;
    private final List<DockerDeploymentRuntime> myDeploymentRuntimes;

    public DockerServerRuntimeInstance(@NotNull DockerCloudConfiguration configuration, @NotNull ServerTaskExecutor taskExecutor, @NotNull List<File> libraryFiles) throws Exception {
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(0);
        }
        if (taskExecutor == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(1);
        }
        if (libraryFiles == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(2);
        }
        super((CloudAgentConfigBase)configuration, taskExecutor, libraryFiles, Collections.emptyList(), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, DockerAgent.class, "com.intellij.docker.agent.DockerAgentImpl");
        this.myDeploymentRuntimes = new ArrayList<DockerDeploymentRuntime>();
        this.myRuntimesCache = new DockerRuntimesCache(this.getTaskExecutor(), this.getAgentTaskExecutor());
    }

    public AgentTaskExecutor getDockerAgentTaskExecutor() {
        return super.getAgentTaskExecutor();
    }

    public void connect(final ServerConnector.ConnectionCallback<DockerDeploymentConfiguration> callback) {
        try {
            DockerServerRuntimeInstance.updateDockerConnectionParameters((DockerCloudConfiguration)this.getConfiguration());
        }
        catch (DockerMachineException e) {
            callback.errorOccurred(e.getMessage());
        }
        this.getAgentTaskExecutor().execute(() -> {
            ((DockerAgent)this.getAgent()).setLogSettings(IntelliJLogSettings.collect());
            ((DockerAgent)this.getAgent()).connect((DockerAgentConfig)this.getConfiguration(), new CloudAgentLogger(){

                public void debugEx(Exception e) {
                    LOG.debug((Throwable)e);
                }

                public void debug(String message) {
                    LOG.debug(message);
                }
            }, (CloudAgentErrorHandler)this.getAgentTaskExecutor());
            return null;
        }, (CallbackWrapper)new CallbackWrapper<Void>(){

            public void onSuccess(Void result) {
                callback.connected((ServerRuntimeInstance)DockerServerRuntimeInstance.this);
            }

            public void onError(String message) {
                callback.errorOccurred(message);
            }
        });
    }

    private static void updateDockerConnectionParameters(@NotNull DockerCloudConfiguration configuration) {
        String machineName;
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)(machineName = configuration.getMachine()))) {
            DockerConnectionInfo connectionInfo = DockerMachine.currentDockerMachine().getDockerConnectionInfo(machineName);
            configuration.setApiUrl(connectionInfo.getApiUrl());
            configuration.setCertificatesPath(connectionInfo.getCertificatesPath());
        }
    }

    public void deploy(@NotNull DeploymentTask<DockerDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager, @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        if (task == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(4);
        }
        if (logManager == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(6);
        }
        this.getTaskExecutor().submit(() -> {
            if (task == null) {
                DockerServerRuntimeInstance.$$$reportNull$$$0(13);
            }
            if (logManager == null) {
                DockerServerRuntimeInstance.$$$reportNull$$$0(14);
            }
            if (callback == null) {
                DockerServerRuntimeInstance.$$$reportNull$$$0(15);
            }
            for (DockerDeploymentRuntime deploymentRuntime : new ArrayList<DockerDeploymentRuntime>(this.myDeploymentRuntimes)) {
                if (deploymentRuntime.getConfiguration() != task.getConfiguration()) continue;
                this.myDeploymentRuntimes.remove((Object)deploymentRuntime);
            }
            DeploymentSourceType sourceType = task.getSource().getType();
            if (sourceType instanceof DockerComposeDeploymentSourceType) {
                ComposeDeploymentRuntime composeDeploymentRuntime = new ComposeDeploymentRuntime((DockerAgent)this.getAgent(), task, logManager, this.getTaskExecutor(), this.getAgentTaskExecutor(), (DockerCloudConfiguration)this.getConfiguration());
                String deploymentName = this.getDeploymentName(task.getSource(), (DockerDeploymentConfiguration)task.getConfiguration());
                this.myRuntimesCache.registerComposeDeployment(deploymentName, composeDeploymentRuntime);
                composeDeploymentRuntime.deploy(callback);
            } else {
                boolean isImageNotContainer = sourceType instanceof DockerFileDeploymentSourceType && ((DockerDeploymentConfiguration)task.getConfiguration()).isBuildOnly();
                DockerDeploymentRuntime deploymentRuntime = new DockerDeploymentRuntime((DockerAgent)this.getAgent(), task, logManager, this.getTaskExecutor(), this.getAgentTaskExecutor(), (DockerCloudConfiguration)this.getConfiguration(), this.myRuntimesCache.getImageNotContainerGroupRuntime(isImageNotContainer)){

                    @Override
                    public String getContainerName() {
                        return DockerServerRuntimeInstance.this.myRuntimesCache.findContainerName(this.getContainerId());
                    }
                };
                this.myDeploymentRuntimes.add(deploymentRuntime);
                deploymentRuntime.deploy(callback);
            }
        }, (RemoteOperationCallback)callback);
    }

    public void disconnect() {
        this.getTaskExecutor().submit(() -> ((DockerAgent)this.getAgent()).disconnect());
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source, DockerDeploymentConfiguration configuration) {
        if (source == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(7);
        }
        String string = DockerServerRuntimeInstance.doGetDeploymentName(null, source, configuration);
        if (string == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getRuntimeDeploymentName(@NotNull DeploymentRuntime deploymentRuntime, @NotNull DeploymentSource source, DockerDeploymentConfiguration configuration) {
        if (deploymentRuntime == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(9);
        }
        if (source == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(10);
        }
        String string = DockerServerRuntimeInstance.doGetDeploymentName((DockerApplicationRuntime)deploymentRuntime, source, configuration);
        if (string == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static String doGetDeploymentName(@Nullable DockerApplicationRuntime applicationRuntime, @NotNull DeploymentSource source, DockerDeploymentConfiguration configuration) {
        String result;
        DeploymentSourceType type;
        if (source == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(12);
        }
        if ((type = source.getType()) instanceof DockerSingletonDeploymentSourceType) {
            result = ((DockerSingletonDeploymentSourceType)type).getPresentableDeploymentName(configuration, applicationRuntime);
        } else {
            String namePiece = DockerSingletonDeploymentSourceType.getPresentableContainerNamePiece(configuration, applicationRuntime);
            result = namePiece + " Artifact: " + source.getPresentableName();
        }
        return result;
    }

    public void parseCliOptions(DockerParseCliConfig parseCliConfig, DockerAgentPathMapper pathMapper, final DockerParseCliCallback callback) {
        this.getTaskExecutor().submit(() -> this.getAgentTaskExecutor().execute(() -> ((DockerAgent)this.getAgent()).parseCliOptions(parseCliConfig, pathMapper), (CallbackWrapper)new CallbackWrapper<DockerAgentContainerConfig>(){

            public void onSuccess(DockerAgentContainerConfig result) {
                callback.succeeded(result);
            }

            public void onError(String message) {
                callback.errorOccurred(message);
            }
        }), (RemoteOperationCallback)callback);
    }

    public void pullImage(Project project, DockerRepositoryModel repositoryModel, final ParameterizedRunnable<String> onSuccess) {
        final DockerAgentRepositoryConfigImpl repositoryConfig = new DockerAgentRepositoryConfigImpl(repositoryModel);
        final String imageAndTag = repositoryConfig.getQualifiedTag();
        new RegistryRuntimeTask(){

            @Override
            protected OngoingProcess doPerform(DockerAgentProgressCallback progressCallback) {
                return ((DockerAgent)DockerServerRuntimeInstance.this.getAgent()).pullImage(repositoryConfig, progressCallback);
            }

            @Override
            protected void succeeded() {
                onSuccess.run((Object)imageAndTag);
            }
        }.performAsyncWithNotification(project, this.getTaskExecutor(), this.getAgentTaskExecutor(), "Pulling " + imageAndTag, imageAndTag + " pulled successfully");
    }

    public void imageRegistryAuth(DockerRegistry registry, RegistryAuthCallback callback) {
        this.getTaskExecutor().submit(() -> {
            try {
                this.getAgentTaskExecutor().execute(() -> {
                    ((DockerAgent)this.getAgent()).imageRegistryAuth(registry.getAuthConfig());
                    return null;
                });
                callback.succeeded();
            }
            catch (ServerRuntimeException e) {
                callback.errorOccurred(e.getMessage());
            }
        });
    }

    protected List<CloudApplicationRuntime> getApplications() throws ServerRuntimeException {
        return (List)this.getAgentTaskExecutor().execute(() -> {
            DockerAgentApplication[] agentApps = ((DockerAgent)this.getAgent()).getApplications();
            if (agentApps == null) {
                agentApps = new DockerAgentApplication[]{};
            }
            return this.myRuntimesCache.refreshStructure(agentApps);
        });
    }

    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication applicationIdentity) {
        throw new UnsupportedOperationException("should not be called, super.getApplications is overridden");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFiles";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerServerRuntimeInstance";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerServerRuntimeInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeDeploymentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateDockerConnectionParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deploy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentName";
                break;
            }
            case 8: 
            case 11: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeDeploymentName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doGetDeploymentName";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deploy$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

