/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.google.gson.stream.JsonToken;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public final class SourceMapFileType
extends LanguageFileType {
    public static final SourceMapFileType INSTANCE = new SourceMapFileType();
    public static final String DOT_DEFAULT_EXTENSION = ".map";

    public SourceMapFileType() {
        super((Language)JsonLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        if ("SourceMap" == null) {
            SourceMapFileType.$$$reportNull$$$0(0);
        }
        return "SourceMap";
    }

    @NotNull
    public String getDescription() {
        if ("SourceMap" == null) {
            SourceMapFileType.$$$reportNull$$$0(1);
        }
        return "SourceMap";
    }

    @NotNull
    public String getDefaultExtension() {
        if ("map" == null) {
            SourceMapFileType.$$$reportNull$$$0(2);
        }
        return "map";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Json;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javascript/debugger/sourcemap/SourceMapFileType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static final class MyFileTypeDetector
    implements FileTypeRegistry.FileTypeDetector {
        MyFileTypeDetector() {
        }

        @Nullable
        public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (file == null) {
                MyFileTypeDetector.$$$reportNull$$$0(0);
            }
            if (firstBytes == null) {
                MyFileTypeDetector.$$$reportNull$$$0(1);
            }
            if (!file.getName().endsWith(SourceMapFileType.DOT_DEFAULT_EXTENSION) || firstCharsIfText == null) {
                return null;
            }
            try {
                JsonReaderEx jsonReader = new JsonReaderEx(firstCharsIfText);
                if (jsonReader.peek() != JsonToken.BEGIN_OBJECT) {
                    return null;
                }
                jsonReader.beginObject();
                String firstName = jsonReader.nextName();
                return firstName.equals("version") && jsonReader.peek() == JsonToken.NUMBER || firstName.equals("names") && jsonReader.peek() == JsonToken.BEGIN_ARRAY ? INSTANCE : null;
            }
            catch (Exception ignored) {
                return null;
            }
        }

        public int getVersion() {
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstBytes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/debugger/sourcemap/SourceMapFileType$MyFileTypeDetector";
            objectArray[2] = "detect";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyFileTypeFactory
    extends FileTypeFactory {
        MyFileTypeFactory() {
        }

        public void createFileTypes(@NotNull FileTypeConsumer consumer) {
            if (consumer == null) {
                MyFileTypeFactory.$$$reportNull$$$0(0);
            }
            consumer.consume((FileType)INSTANCE, new FileNameMatcher[]{FileNameMatcherFactory.getInstance().createMatcher("*.js.map")});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/debugger/sourcemap/SourceMapFileType$MyFileTypeFactory", "createFileTypes"));
        }
    }
}

