/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.Urls;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.PathKt;
import com.intellij.xdebugger.XDebuggerManager;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerFileHandlerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.io.FileResponses;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/SourceMapDetectorFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "intellij.javascript.debugger"})
final class SourceMapDetectorFileHandler
extends WebServerFileHandler {
    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost, @NotNull HttpHeaders extraHeaders) {
        block14: {
            block13: {
                Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
                Intrinsics.checkParameterIsNotNull((Object)canonicalPath, (String)"canonicalPath");
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                Intrinsics.checkParameterIsNotNull((Object)extraHeaders, (String)"extraHeaders");
                file = pathInfo.getIoFile();
                if (file == null || !StringsKt.endsWith((String)file.getFileName().toString(), (String)".js", (boolean)true)) {
                    return false;
                }
                debugProcesses = XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class);
                if (debugProcesses.isEmpty()) {
                    return false;
                }
                v0 = SourceMapLoaderKt.getSourceMapUrl(file);
                if (v0 == null) {
                    return false;
                }
                sourceMapUrl = v0;
                v1 = NettyKt.getHost((HttpRequest)((HttpRequest)request));
                if (v1 == null) {
                    return false;
                }
                host = v1;
                scriptUrl = Urls.newUrl((String)NettyKt.getUriScheme((Channel)channel), (String)host, (String)WebServerFileHandlerKt.getRequestPath((CharSequence)canonicalPath, (String)projectNameIfNotCustomHost));
                parsedUrl = SourceMapLoaderKt.canonicalizeUrl(sourceMapUrl, scriptUrl);
                if (!JsFileUtil.isOnBuiltInWebServer(parsedUrl)) {
                    return false;
                }
                path = parsedUrl.getPath();
                if (projectNameIfNotCustomHost != null) break block13;
                v2 = path;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"path");
                var15_15 = v2;
                var16_17 = 1;
                v3 = var15_15;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                v4 = v3.substring(var16_17);
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"(this as java.lang.String).substring(startIndex)");
                path = v4;
                break block14;
            }
            if (path.length() <= projectNameIfNotCustomHost.length() + 1) ** GOTO lbl-1000
            v5 = path;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"path");
            if (StringsKt.startsWith$default((String)v5, (String)projectNameIfNotCustomHost, (int)1, (boolean)false, (int)4, null) && path.charAt(projectNameIfNotCustomHost.length() + 1) == '/') {
                var15_15 = path;
                var16_17 = projectNameIfNotCustomHost.length() + 1;
                v6 = var15_15.substring(var16_17);
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"(this as java.lang.String).substring(startIndex)");
                path = v6;
            } else lbl-1000:
            // 2 sources

            {
                v7 = JavaScriptDebugProcessKt.getLOG();
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"LOG");
                $receiver$iv = v7;
                e$iv = null;
                if ($receiver$iv.isDebugEnabled()) {
                    var21_20 = $receiver$iv;
                    var22_21 = "SourceMap " + parsedUrl + " doesn't belong to current project " + projectNameIfNotCustomHost;
                    var21_20.debug(var22_21, (Throwable)e$iv);
                }
                return false;
            }
        }
        v8 = WebServerPathToFileManager.Companion.getInstance(project);
        v9 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"path");
        v10 /* !! */  = WebServerPathToFileManager.getPathInfo$default((WebServerPathToFileManager)v8, (String)v9, (boolean)false, null, (int)6, null);
        if (v10 /* !! */  == null || (v10 /* !! */  = v10 /* !! */ .getIoFile()) == null) {
            return false;
        }
        sourceMapFile /* !! */  = v10 /* !! */ ;
        sourceMapData = PathKt.readChars((Path)sourceMapFile /* !! */ );
        promises = new SmartList();
        for (JavaScriptDebugProcess debugProcess : debugProcesses) {
            if (debugProcess.isFilesOnlyInLocalFileSystem()) continue;
            v11 = debugProcess.getPreloadedSourceMaps();
            v12 = scriptUrl;
            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"scriptUrl");
            if (v11.containsScript(v12)) continue;
            if (JavaScriptDebugProcess.decodeSourceMap$default(debugProcess, sourceMapData, scriptUrl, true, null, true, 8, null) == null) {
                continue;
            }
            if (!debugProcess.getPreloadedSourceMaps().add(parsedUrl, sourceMap, scriptUrl)) continue;
            v13 = debugProcess.getMainVm();
            if (v13 == null) {
                Intrinsics.throwNpe();
            }
            debugProcess.sourceMapFound(v13, sourceMap, null, scriptUrl, (List)promises);
        }
        debugProcess = Promises.all((Collection)((Collection)promises));
        Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.processed((Consumer)new Consumer<Object>(request, channel, file, extraHeaders){
            final /* synthetic */ FullHttpRequest $request$inlined;
            final /* synthetic */ Channel $channel$inlined;
            final /* synthetic */ Path $file$inlined;
            final /* synthetic */ HttpHeaders $extraHeaders$inlined;
            {
                this.$request$inlined = fullHttpRequest;
                this.$channel$inlined = channel;
                this.$file$inlined = path;
                this.$extraHeaders$inlined = httpHeaders;
            }

            public final void consume(@Nullable Object it) {
                FileResponses.INSTANCE.sendFile((HttpRequest)this.$request$inlined, this.$channel$inlined, this.$file$inlined, this.$extraHeaders$inlined);
            }
        }), (String)"(this as Promise<Any?>).processed({ handler() })");
        return true;
    }
}

