/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.settings;

import com.google.common.base.Splitter;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.settings.CustomObjectPresentationState;
import com.intellij.javascript.debugger.settings.JavaScriptDataViewsConfigurableUi;
import com.intellij.javascript.debugger.settings.JavaScriptSteppingConfigurableUi;
import com.intellij.javascript.debugger.settings.SteppingFilter;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Getter;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public class JavaScriptDebuggerSettings
extends XDebuggerSettings<JavaScriptDebuggerSettings>
implements Getter<JavaScriptDebuggerSettings> {
    private static final Splitter STEPPING_FILTER_SPLITTER = Splitter.on((char)';').omitEmptyStrings();
    @Attribute
    public int builtInServerPort = 63342;
    @Attribute
    public boolean builtInServerAvailableExternally = false;
    private boolean steppingFiltersEnabled = true;
    private List<SteppingFilter> steppingFilters = new SmartList();
    private boolean doNotStepIntoLibraryCode = true;
    private CustomObjectPresentationState myObjectPresentation = new CustomObjectPresentationState();
    private List<FileNameMatcher> computedSteppingFilters;

    @Attribute(value="doNotStepIntoLibraryCode")
    public boolean isDoNotStepIntoLibraryCode() {
        return this.doNotStepIntoLibraryCode;
    }

    public void setDoNotStepIntoLibraryCode(boolean value) {
        this.doNotStepIntoLibraryCode = value;
    }

    @Tag(value="stepping-filters-enabled")
    public boolean isSteppingFiltersEnabled() {
        return this.steppingFiltersEnabled;
    }

    public void setSteppingFiltersEnabled(boolean value) {
        this.steppingFiltersEnabled = value;
    }

    @XCollection
    @Tag(value="stepping-filters")
    @NotNull
    public List<SteppingFilter> getSteppingFilters() {
        List<SteppingFilter> list = this.steppingFilters;
        if (list == null) {
            JavaScriptDebuggerSettings.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setSteppingFilters(@NotNull List<SteppingFilter> value) {
        if (value == null) {
            JavaScriptDebuggerSettings.$$$reportNull$$$0(1);
        }
        this.steppingFilters = value;
    }

    @Property(surroundWithTag=false)
    public CustomObjectPresentationState getObjectPresentation() {
        return this.myObjectPresentation;
    }

    public void setObjectPresentation(CustomObjectPresentationState objectPresentation) {
        this.myObjectPresentation = objectPresentation;
    }

    public JavaScriptDebuggerSettings() {
        super("javascript");
    }

    public static JavaScriptDebuggerSettings getInstance() {
        return (JavaScriptDebuggerSettings)JavaScriptDebuggerSettings.getInstance(JavaScriptDebuggerSettings.class);
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            JavaScriptDebuggerSettings.$$$reportNull$$$0(2);
        }
        switch (category) {
            case DATA_VIEWS: {
                List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"debugger.dataViews.javascript", (String)JSDebuggerBundle.message("javascript.debugger.settings.display.name", new Object[0]), (String)"debugger.dataViews.javascript", JavaScriptDataViewsConfigurableUi.class, (Getter)this));
                if (list == null) {
                    JavaScriptDebuggerSettings.$$$reportNull$$$0(3);
                }
                return list;
            }
            case STEPPING: {
                List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"debugger.stepping.javascript", (String)JSDebuggerBundle.message("javascript.debugger.settings.display.name", new Object[0]), JavaScriptSteppingConfigurableUi.class, (Getter)this));
                if (list == null) {
                    JavaScriptDebuggerSettings.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            JavaScriptDebuggerSettings.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        if (configurable == null) {
            JavaScriptDebuggerSettings.$$$reportNull$$$0(6);
        }
        return PlatformUtils.isWebStorm() && JSDebuggerBundle.message("javascript.debugger.settings.display.name", new Object[0]).equals(configurable.getDisplayName());
    }

    @NotNull
    public JavaScriptDebuggerSettings getState() {
        JavaScriptDebuggerSettings javaScriptDebuggerSettings = this;
        if (javaScriptDebuggerSettings == null) {
            JavaScriptDebuggerSettings.$$$reportNull$$$0(7);
        }
        return javaScriptDebuggerSettings;
    }

    public void loadState(@NotNull JavaScriptDebuggerSettings state) {
        if (state == null) {
            JavaScriptDebuggerSettings.$$$reportNull$$$0(8);
        }
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
        if (this.builtInServerAvailableExternally) {
            BuiltInServerOptions.getInstance().builtInServerAvailableExternally = true;
            this.builtInServerAvailableExternally = false;
        }
        if (this.builtInServerPort != 63342) {
            BuiltInServerOptions.getInstance().builtInServerPort = this.builtInServerPort;
            this.builtInServerPort = 63342;
        }
    }

    public Collection<String> getEnabledSteppingFilters() {
        if (!this.isSteppingFiltersEnabled()) {
            return Collections.emptyList();
        }
        SmartList patterns = new SmartList();
        for (SteppingFilter filterState : this.getSteppingFilters()) {
            if (!filterState.isEnabled()) continue;
            patterns.add(filterState.getUrlPattern());
        }
        return patterns;
    }

    @NotNull
    public List<FileNameMatcher> getComputedSteppingFilters() {
        if (this.computedSteppingFilters == null) {
            if (!this.isSteppingFiltersEnabled()) {
                List<FileNameMatcher> list = Collections.emptyList();
                if (list == null) {
                    JavaScriptDebuggerSettings.$$$reportNull$$$0(9);
                }
                return list;
            }
            SmartList result = new SmartList();
            FileNameMatcherFactory fileNameMatcherFactory = FileNameMatcherFactory.getInstance();
            for (SteppingFilter filterState : this.getSteppingFilters()) {
                if (!filterState.isEnabled() || filterState.getUrlPattern() == null) continue;
                for (String wildcard : STEPPING_FILTER_SPLITTER.split((CharSequence)filterState.getUrlPattern())) {
                    result.add(fileNameMatcherFactory.createMatcher(wildcard));
                }
            }
            this.computedSteppingFilters = Collections.unmodifiableList(result);
        }
        List<FileNameMatcher> list = this.computedSteppingFilters;
        if (list == null) {
            JavaScriptDebuggerSettings.$$$reportNull$$$0(10);
        }
        return list;
    }

    public JavaScriptDebuggerSettings get() {
        return this;
    }

    public static void onSettingsChanged(boolean viewSettingsChanged, boolean filtersChanged) {
        if (filtersChanged) {
            JavaScriptDebuggerSettings.getInstance().computedSteppingFilters = null;
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (JavaScriptDebugProcess process : XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class)) {
                if (process.getSession().isStopped() || !viewSettingsChanged) continue;
                process.getSession().rebuildViews();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSteppingFilters";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComputedSteppingFilters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSteppingFilters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurables";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTargetedToProduct";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

