/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.javascript.debugger.scripts.ConsumerOnEdt;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.BaseRemoteFileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Vm;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0014J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/javascript/debugger/scripts/VmFileEditor;", "Lcom/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/javascript/debugger/scripts/VmScriptFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/scripts/VmScriptFile;)V", "isValid", "", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "deselectNotify", "", "dispose", "download", "debugProcess", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "getComponent", "getName", "", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "getTextEditor", "selectNotify", "intellij.javascript.debugger"})
public final class VmFileEditor
extends BaseRemoteFileEditor {
    private TextEditor textEditor;
    private final JBLoadingPanel loadingPanel;
    private volatile boolean isValid;

    private final void download(VmScriptFile file, DebuggerViewSupport debugProcess) {
        ScriptsKt.ensureDownloaded(file, debugProcess.getVm()).done((Consumer)new ConsumerOnEdt<VirtualFile>(this, this.myProject){
            final /* synthetic */ VmFileEditor this$0;

            public void consume(@NotNull Project project, @NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                VmFileEditor.access$getLoadingPanel$p(this.this$0).stopLoading();
                FileEditor fileEditor = TextEditorProvider.getInstance().createEditor(project, file);
                if (fileEditor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
                }
                TextEditor _textEditor = (TextEditor)fileEditor;
                Editor editor = _textEditor.getEditor();
                if (editor instanceof EditorEx) {
                    ((EditorEx)editor).setViewer(true);
                }
                VmFileEditor.access$setTextEditor$p(this.this$0, _textEditor);
                VmFileEditor.access$contentLoaded(this.this$0);
                TextEditor textEditor = VmFileEditor.access$getTextEditor$p(this.this$0);
                if (textEditor == null) {
                    Intrinsics.throwNpe();
                }
                textEditor.addPropertyChangeListener((PropertyChangeListener)((Object)this.this$0));
                JBLoadingPanel jBLoadingPanel = VmFileEditor.access$getLoadingPanel$p(this.this$0);
                TextEditor textEditor2 = VmFileEditor.access$getTextEditor$p(this.this$0);
                if (textEditor2 == null) {
                    Intrinsics.throwNpe();
                }
                jBLoadingPanel.add((Component)textEditor2.getComponent());
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        }).rejected((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ VmFileEditor this$0;

            public final void consume(Throwable error) {
                VmFileEditor.access$getLoadingPanel$p(this.this$0).stopLoading();
                VmFileEditor.access$setValid$p(this.this$0, false);
                VmFileEditor.access$contentRejected(this.this$0);
            }
            {
                this.this$0 = vmFileEditor;
            }
        });
    }

    public boolean isValid() {
        return this.isValid && super.isValid();
    }

    @NotNull
    public JBLoadingPanel getComponent() {
        return this.loadingPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent;
        if (this.textEditor == null) {
            jComponent = (JComponent)this.loadingPanel;
        } else {
            TextEditor textEditor = this.textEditor;
            if (textEditor == null) {
                Intrinsics.throwNpe();
            }
            jComponent = textEditor.getPreferredFocusedComponent();
        }
        return jComponent;
    }

    @NotNull
    public String getName() {
        return "Vm";
    }

    public void selectNotify() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
            final /* synthetic */ VmFileEditor this$0;

            public final void run() {
                if (VmFileEditor.access$getTextEditor$p(this.this$0) != null) {
                    TextEditor textEditor = VmFileEditor.access$getTextEditor$p(this.this$0);
                    if (textEditor == null) {
                        Intrinsics.throwNpe();
                    }
                    textEditor.selectNotify();
                }
            }
            {
                this.this$0 = vmFileEditor;
            }
        });
    }

    public void deselectNotify() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
            final /* synthetic */ VmFileEditor this$0;

            public final void run() {
                block0: {
                    TextEditor textEditor;
                    TextEditor textEditor2 = VmFileEditor.access$getTextEditor$p(this.this$0);
                    if (textEditor2 == null) break block0;
                    TextEditor it = textEditor = textEditor2;
                    it.deselectNotify();
                }
            }
            {
                this.this$0 = vmFileEditor;
            }
        });
    }

    @Nullable
    protected TextEditor getTextEditor() {
        return this.textEditor;
    }

    public void dispose() {
        block0: {
            TextEditor textEditor;
            super.dispose();
            TextEditor textEditor2 = this.textEditor;
            if (textEditor2 == null) break block0;
            TextEditor it = textEditor = textEditor2;
            Disposer.dispose((Disposable)((Disposable)it));
        }
    }

    public VmFileEditor(@NotNull Project project, @NotNull VmScriptFile file) {
        block2: {
            VmFileEditor vmFileEditor;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)((Object)file), (String)"file");
            super(project);
            this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
            this.isValid = true;
            VmFileEditor $receiver = vmFileEditor = this;
            $receiver.loadingPanel.startLoading();
            for (JavaScriptDebugProcess debugProcess : XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class)) {
                Vm vm;
                JavaScriptDebuggerViewSupport viewSupport = debugProcess.getDebuggerViewSupport();
                if (viewSupport.getVm() == null) {
                    continue;
                }
                Promise source = vm.getScriptManager().getSource(file.getScript());
                if (!(Intrinsics.areEqual((Object)source.getState(), (Object)Promise.State.REJECTED) ^ true)) continue;
                $receiver.download(file, (DebuggerViewSupport)viewSupport);
                break block2;
            }
            $receiver.loadingPanel.stopLoading();
            $receiver.isValid = false;
        }
    }

    @NotNull
    public static final /* synthetic */ JBLoadingPanel access$getLoadingPanel$p(VmFileEditor $this) {
        return $this.loadingPanel;
    }

    @Nullable
    public static final /* synthetic */ TextEditor access$getTextEditor$p(VmFileEditor $this) {
        return $this.textEditor;
    }

    public static final /* synthetic */ void access$setTextEditor$p(VmFileEditor $this, @Nullable TextEditor textEditor) {
        $this.textEditor = textEditor;
    }

    public static final /* synthetic */ void access$contentLoaded(VmFileEditor $this) {
        $this.contentLoaded();
    }

    public static final /* synthetic */ boolean access$isValid$p(VmFileEditor $this) {
        return $this.isValid;
    }

    public static final /* synthetic */ void access$setValid$p(VmFileEditor $this, boolean bl) {
        $this.isValid = bl;
    }

    public static final /* synthetic */ void access$contentRejected(VmFileEditor $this) {
        $this.contentRejected();
    }
}

