/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.scripts.SourceContentFile;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import gnu.trove.TIntObjectHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManagerBaseKt;
import org.jetbrains.debugger.Vm;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\r\u001a\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0014\u001a\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t\u001a\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"(\u0010\u0004\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0003*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"FILE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/javascript/debugger/scripts/VmScriptFile;", "kotlin.jvm.PlatformType", "SOURCE_CONTENT_KEY", "Lgnu/trove/TIntObjectHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "createVmFile", "url", "Lcom/intellij/util/Url;", "script", "Lcom/intellij/openapi/util/UserDataHolder;", "normalizedSource", "", "sourceIndex", "", "Lorg/jetbrains/debugger/Script;", "source", "ensureDownloaded", "Lorg/jetbrains/concurrency/Promise;", "file", "vm", "Lorg/jetbrains/debugger/Vm;", "findRemoteFile", "getCachedActualFile", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getResolvedFile", "intellij.javascript.debugger"})
public final class ScriptsKt {
    private static final Key<VmScriptFile> FILE_KEY = Key.create((String)"actual source file");
    private static final Key<TIntObjectHashMap<VirtualFile>> SOURCE_CONTENT_KEY = Key.create((String)"actual source content");

    @NotNull
    public static final Promise<VirtualFile> ensureDownloaded(@NotNull VmScriptFile file, @Nullable Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)file), (String)"file");
        if (file.isLoaded()) {
            return Promises.resolvedPromise((Object)((Object)file));
        }
        if (vm == null) {
            return Promises.rejectedPromise((String)"Vm null");
        }
        Promise promise = vm.getScriptManager().getSource(file.getScript()).then(new Function<T, SUB_RESULT>(file){
            final /* synthetic */ VmScriptFile $file;

            @NotNull
            public final VmScriptFile fun(String it) {
                String string = StringUtilRt.convertLineSeparators((String)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtilRt.convertLineSeparators(it)");
                this.$file.setContent(null, string, true);
                return this.$file;
            }
            {
                this.$file = vmScriptFile;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"vm.scriptManager.getSour\u2026), true)\n      file\n    }");
        return promise;
    }

    @NotNull
    public static final Promise<VirtualFile> getResolvedFile(@NotNull Script script, @NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Promise promise = ScriptsKt.getCachedActualFile(script, vm);
        if (promise == null) {
            Promise promise2 = vm.getScriptManager().getSource(script).then(new Function<T, SUB_RESULT>(script){
                final /* synthetic */ Script $script;

                @NotNull
                public final VirtualFile fun(String it) {
                    return ScriptsKt.createVmFile(this.$script, it);
                }
                {
                    this.$script = script;
                }
            });
            promise = promise2;
            Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"vm.scriptManager.getSour\u2026reateVmFile(script, it) }");
        }
        return promise;
    }

    @Nullable
    public static final Promise<VirtualFile> getCachedActualFile(@NotNull Script script, @Nullable Vm vm) {
        Promise<VirtualFile> promise;
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        VmScriptFile vmScriptFile = (VmScriptFile)((Object)FILE_KEY.get((UserDataHolder)script));
        if (vmScriptFile != null) {
            VmScriptFile vmScriptFile2;
            VmScriptFile it = vmScriptFile2 = vmScriptFile;
            promise = ScriptsKt.ensureDownloaded(it, vm);
        } else {
            promise = null;
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final VirtualFile createVmFile(@NotNull Url url, @NotNull UserDataHolder script, @NotNull String normalizedSource, int sourceIndex) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)normalizedSource, (String)"normalizedSource");
        TIntObjectHashMap map = (TIntObjectHashMap)SOURCE_CONTENT_KEY.get(script);
        if (map == null) {
            map = new TIntObjectHashMap();
            SOURCE_CONTENT_KEY.set(script, (Object)map);
        }
        TIntObjectHashMap tIntObjectHashMap = map;
        synchronized (tIntObjectHashMap) {
            VirtualFile file;
            TIntObjectHashMap tIntObjectHashMap2 = map;
            if (tIntObjectHashMap2 == null) {
                Intrinsics.throwNpe();
            }
            if ((file = (VirtualFile)tIntObjectHashMap2.get(sourceIndex)) == null) {
                file = script instanceof Script ? (VirtualFile)new VmScriptFile(url, (Script)script, normalizedSource) : (VirtualFile)new SourceContentFile(url, normalizedSource);
                TIntObjectHashMap tIntObjectHashMap3 = map;
                if (tIntObjectHashMap3 == null) {
                    Intrinsics.throwNpe();
                }
                tIntObjectHashMap3.put(sourceIndex, (Object)file);
            }
            VirtualFile virtualFile = file;
            return virtualFile;
        }
    }

    @NotNull
    public static final VirtualFile createVmFile(@NotNull Script script, @Nullable String source) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        VmScriptFile file = (VmScriptFile)((Object)FILE_KEY.get((UserDataHolder)script));
        if (source == null) {
            string = "";
        } else {
            String string2 = StringUtilRt.convertLineSeparators((String)source);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtilRt.convertLineSeparators(source)");
        }
        String normalizedSource = string;
        if (file == null) {
            file = new VmScriptFile(script, normalizedSource);
            file = (VmScriptFile)((Object)script.putUserDataIfAbsent(FILE_KEY, (Object)file));
        } else if (source != null) {
            file.setContent(null, normalizedSource, true);
        }
        return (VirtualFile)file;
    }

    @NotNull
    public static final FileType getFileType(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(url.getPath());
        if (type != FileTypes.UNKNOWN) {
            FileType fileType = type;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"type");
            return fileType;
        }
        for (FileUrlMapper fileUrlMapper : (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions()) {
            FileType fileType;
            FileType it;
            if (fileUrlMapper.getFileType(url) == null || (it = fileType) == FileTypes.UNKNOWN) continue;
            return it;
        }
        JavaScriptFileType javaScriptFileType = JavaScriptFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaScriptFileType, (String)"JavaScriptFileType.INSTANCE");
        return (FileType)javaScriptFileType;
    }

    @Nullable
    public static final VirtualFile findRemoteFile(@NotNull Script script, @NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        VirtualFile file = null;
        if (url.isInLocalFileSystem()) {
            file = LocalFileSystem.getInstance().findFileByPath(url.getPath());
        } else if (!ScriptManagerBaseKt.isSpecial((Url)url)) {
            file = VirtualFileManager.getInstance().findFileByUrl(url.toExternalForm());
        }
        return file == null && url == script.getUrl() ? ScriptsKt.createVmFile(script, null) : file;
    }
}

