/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0016\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"GROUP_ID", "Lcom/intellij/internal/statistic/beans/GroupDescriptor;", "getPreferredBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "project", "Lcom/intellij/openapi/project/Project;", "uri", "", "getStatisticsKey", "runConfig", "Lcom/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration;", "intellij.javascript.debugger"})
public final class JSDebugConfigUsagesCollectorKt {
    private static final GroupDescriptor GROUP_ID;

    @NotNull
    public static final String getStatisticsKey(@NotNull Project project, @NotNull JavaScriptDebugConfiguration runConfig) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)runConfig), (String)"runConfig");
        String browserId = runConfig.getEngineId();
        WebBrowser browser = WebBrowserManager.getInstance().findBrowserById(browserId);
        WebBrowser preferredBrowser = JSDebugConfigUsagesCollectorKt.getPreferredBrowser(project, runConfig.getUri());
        List<RemoteUrlMappingBean> mappings = runConfig.getMappings();
        StringBuilder stringBuilder = new StringBuilder().append("browser-");
        Object object = browser;
        if (object == null || (object = object.getName()) == null) {
            object = "default";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(object).append(".preferredBrowser-");
        Object object2 = preferredBrowser;
        if (object2 == null || (object2 = object2.getId()) == null) {
            object2 = "null";
        }
        return stringBuilder2.append(object2).append(mappings.isEmpty() ? ".no_mappings" : ".with_mappings").toString();
    }

    private static final WebBrowser getPreferredBrowser(Project project, String uri) {
        WebBrowser webBrowser;
        DebuggableFileFinderImpl debuggableFileFinderImpl;
        block7: {
            block6: {
                Url url = uri == null ? null : Urls.newFromIdea((CharSequence)uri);
                debuggableFileFinderImpl = url == null ? null : new DebuggableFileFinderImpl(project, url);
                if (debuggableFileFinderImpl == null) break block6;
                Url url2 = url;
                if (url2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"url!!");
                if ((debuggableFileFinderImpl = debuggableFileFinderImpl.findFile(url2, project)) != null) break block7;
            }
            return null;
        }
        DebuggableFileFinderImpl file = debuggableFileFinderImpl;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile((VirtualFile)file);
        if (psiFile != null) {
            PsiFile psiFile2;
            PsiFile it;
            PsiFile psiFile3 = it = (psiFile2 = psiFile);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"it");
            webBrowser = JavaScriptDebugEngine.Companion.getPreferredBrowser(psiFile3);
        } else {
            webBrowser = null;
        }
        return webBrowser;
    }

    static {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"JSDebugConfig");
        Intrinsics.checkExpressionValueIsNotNull((Object)groupDescriptor, (String)"GroupDescriptor.create(\"JSDebugConfig\")");
        GROUP_ID = groupDescriptor;
    }

    @NotNull
    public static final /* synthetic */ GroupDescriptor access$getGROUP_ID$p() {
        return GROUP_ID;
    }
}

