/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.text.SimilarityIndex;
import com.intellij.openapi.util.text.SimilarityIndexKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.AsarFileSystem;
import com.intellij.util.io.FileItem;
import com.intellij.xdebugger.XDebugSession;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceResolver;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aN\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005\u001a\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u001a*\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\n\u001a*\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a*\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\u0011\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u0017*\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u0013\u001a\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"RENAME_SCORE", "", "createJSSourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "sourceUrls", "", "", "baseUrl", "Lcom/intellij/util/Url;", "isFilesOnlyInLocalFileSystem", "", "baseUrlIsFile", "resolveFile", "project", "Lcom/intellij/openapi/project/Project;", "sourceContents", "cutOffWebpackFooter", "sourceContent", "resolveFileBySourceUrl", "url", "_sourceContent", "forceFindByContent", "selectMostSimilarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "", "sourceBytes", "", "findFileIfAsar", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "intellij.javascript.debugger"})
public final class FileResolverByContentKt {
    private static final int RENAME_SCORE = 60;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile findFileIfAsar(@NotNull JavaScriptDebugProcess<?> $receiver, @NotNull Url url) {
        Collection files;
        String scriptPath;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (!url.isInLocalFileSystem()) {
            return null;
        }
        String string = scriptPath = url.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scriptPath");
        int index = StringsKt.indexOf$default((CharSequence)string, (String)".asar/", (int)0, (boolean)false, (int)6, null);
        if (index <= 0) {
            return null;
        }
        String string2 = scriptPath;
        int n = 0;
        int n2 = index + 5;
        JavaScriptDebugProcess<?> javaScriptDebugProcess = $receiver;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        AsarFileSystem asarFileSystem = javaScriptDebugProcess.getAsarFs$intellij_javascript_debugger(string4);
        if (asarFileSystem == null) {
            return null;
        }
        AsarFileSystem fs = asarFileSystem;
        String string5 = scriptPath;
        n2 = index + ".asar/".length();
        String string6 = string5.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        String scriptRelativePath = string6;
        FileItem fileItem = fs.getFile(scriptRelativePath);
        if (fileItem == null) {
            return null;
        }
        FileItem fileItem2 = fileItem;
        VirtualFile virtualFile = fs.getVfsRoot();
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            VirtualFile virtualFile3 = it.findFileByRelativePath(scriptRelativePath);
            if (virtualFile3 != null) {
                VirtualFile virtualFile4;
                VirtualFile it2 = virtualFile4 = virtualFile3;
                return it2;
            }
        }
        XDebugSession xDebugSession = $receiver.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)xDebugSession.getProject());
        Collection collection = files = (Collection)ApplicationManager.getApplication().runReadAction(new Computable<T>($receiver, scriptRelativePath, scope){
            final /* synthetic */ JavaScriptDebugProcess receiver$0$inlined;
            final /* synthetic */ String $scriptRelativePath$inlined;
            final /* synthetic */ GlobalSearchScope $scope$inlined;
            {
                this.receiver$0$inlined = javaScriptDebugProcess;
                this.$scriptRelativePath$inlined = string;
                this.$scope$inlined = globalSearchScope;
            }

            public final T compute() {
                XDebugSession xDebugSession = this.receiver$0$inlined.getSession();
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
                return (T)FilenameIndex.getVirtualFilesByName((Project)xDebugSession.getProject(), (String)PathUtilRt.getFileName((String)this.$scriptRelativePath$inlined), (GlobalSearchScope)this.$scope$inlined);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"files");
        Iterable $i$f$runReadAction = collection;
        if (!$i$f$runReadAction.isEmpty()) {
            void $receiver$iv;
            $i$f$runReadAction = files;
            Collection destination$iv = (Collection)new SmartList();
            for (Object element$iv : $receiver$iv) {
                VirtualFile it;
                VirtualFile virtualFile5 = it = (VirtualFile)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile5, (String)"it");
                String string7 = virtualFile5.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"it.path");
                if (!FileUtilKt.endsWithName((String)string7, (String)scriptRelativePath)) continue;
                destination$iv.add(element$iv);
            }
            files = destination$iv;
            Collection collection2 = files;
            if (!collection2.isEmpty()) {
                return FileResolverByContentKt.selectMostSimilarFile$default(files, fs.loadBytes(fileItem2), null, 4, null);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SourceResolver createJSSourceResolver(@NotNull List<String> sourceUrls, @NotNull Url baseUrl, boolean isFilesOnlyInLocalFileSystem, boolean baseUrlIsFile, boolean resolveFile, @NotNull Project project, @Nullable List<String> sourceContents) {
        Url[] urlArray;
        void size$iv;
        SourceResolver sourceResolver;
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        int n = sourceUrls.size();
        List<String> list = sourceUrls;
        SourceResolver sourceResolver2 = sourceResolver;
        SourceResolver sourceResolver3 = sourceResolver;
        Url[] result$iv = new Url[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            Url url;
            Url url2;
            void it;
            void i$iv;
            void var11_14 = i$iv;
            void var20_18 = i$iv;
            urlArray = result$iv;
            Url url3 = SourceResolverKt.canonicalizeUrl((String)sourceUrls.get((int)it), (Url)baseUrl, (boolean)isFilesOnlyInLocalFileSystem, (boolean)baseUrlIsFile);
            if (resolveFile) {
                String string = baseUrl.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"baseUrl.path");
                boolean isBrowserify = StringsKt.endsWith$default((String)string, (String)".browserify", (boolean)false, (int)2, null);
                List<String> list2 = sourceContents;
                url2 = FileResolverByContentKt.resolveFileBySourceUrl(project, url3, list2 != null ? (String)CollectionsKt.getOrNull(list2, (int)it) : null, isBrowserify);
                if (url2 == null) {
                    url2 = url3;
                }
            } else {
                url2 = url3;
            }
            urlArray[var20_18] = url = url2;
            ++i$iv;
        }
        urlArray = result$iv;
        sourceResolver2(list, urlArray, sourceContents);
        return sourceResolver3;
    }

    @Nullable
    public static final Url resolveFileBySourceUrl(@NotNull Project project, @NotNull Url url, @Nullable String _sourceContent, boolean forceFindByContent) {
        String fileName;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String sourceContent = _sourceContent;
        if (JavaScriptDebugProcessKt.hasWebpackScheme(url)) {
            if (JavaScriptDebugProcessKt.isWebpackLibraryFile(url)) {
                return null;
            }
            if (sourceContent != null) {
                sourceContent = FileResolverByContentKt.cutOffWebpackFooter(sourceContent);
            }
        } else if (!forceFindByContent && (Intrinsics.areEqual((Object)url.getScheme(), (Object)"http") || Intrinsics.areEqual((Object)url.getScheme(), (Object)"https"))) {
            return null;
        }
        String string = fileName = PathUtilRt.getFileName((String)url.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
        CharSequence charSequence = string;
        if (charSequence.length() > 0) {
            Collection files;
            GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
            Collection collection = files = (Collection)ApplicationManager.getApplication().runReadAction(new Computable<T>(project, fileName, scope){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ String $fileName$inlined;
                final /* synthetic */ GlobalSearchScope $scope$inlined;
                {
                    this.$project$inlined = project;
                    this.$fileName$inlined = string;
                    this.$scope$inlined = globalSearchScope;
                }

                public final T compute() {
                    return (T)FilenameIndex.getVirtualFilesByName((Project)this.$project$inlined, (String)this.$fileName$inlined, (GlobalSearchScope)this.$scope$inlined);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"files");
            Object object = collection;
            if (!object.isEmpty()) {
                object = sourceContent;
                if (!(object == null || object.length() == 0)) {
                    String string2 = sourceContent;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    VirtualFile virtualFile = FileResolverByContentKt.selectMostSimilarFile((Collection<? extends VirtualFile>)files, string2, project);
                    if (virtualFile != null) {
                        Object it = object = virtualFile;
                        return Urls.newLocalFileUrl((VirtualFile)it);
                    }
                } else if (files.size() == 1) {
                    return Urls.newLocalFileUrl((VirtualFile)((VirtualFile)CollectionsKt.first((Iterable)files)));
                }
            }
        }
        return null;
    }

    private static final String cutOffWebpackFooter(String sourceContent) {
        int footerIndex = StringsKt.indexOf$default((CharSequence)sourceContent, (String)"WEBPACK FOOTER", (int)0, (boolean)false, (int)6, null);
        if (footerIndex > 0 && sourceContent.length() - footerIndex < 300) {
            int lastNonSpaceIndex = -1;
            for (int i = footerIndex - 1; i > 0; --i) {
                char c = sourceContent.charAt(i);
                if (c == '/' || c == '*') {
                    lastNonSpaceIndex = i;
                    continue;
                }
                if (!CharsKt.isWhitespace((char)c)) break;
            }
            if (lastNonSpaceIndex > 0) {
                String string = sourceContent;
                int n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, lastNonSpaceIndex);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
        }
        return sourceContent;
    }

    @Nullable
    public static final VirtualFile selectMostSimilarFile(@NotNull Collection<? extends VirtualFile> files, @NotNull String sourceContent, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)sourceContent, (String)"sourceContent");
        String string = sourceContent;
        Collection<? extends VirtualFile> collection = files;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return FileResolverByContentKt.selectMostSimilarFile(collection, byArray2, project);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ VirtualFile selectMostSimilarFile$default(Collection collection, String string, Project project, int n, Object object) {
        if ((n & 4) != 0) {
            project = null;
        }
        return FileResolverByContentKt.selectMostSimilarFile((Collection<? extends VirtualFile>)collection, string, project);
    }

    @Nullable
    public static final VirtualFile selectMostSimilarFile(@NotNull Collection<? extends VirtualFile> files, @NotNull byte[] sourceBytes, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)sourceBytes, (String)"sourceBytes");
        SimilarityIndex sourceIndex = null;
        VirtualFile matchedFile = null;
        int lastMatchedScore = 60;
        for (VirtualFile virtualFile : files) {
            int contentScore;
            int score;
            int n;
            byte[] destination$iv;
            if (virtualFile.isDirectory()) continue;
            int length = (int)virtualFile.getLength();
            int max = Math.max(sourceBytes.length, length);
            int min = Math.min(sourceBytes.length, length);
            if (min * 100 / max < 60 || project != null && ((Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(virtualFile, project){
                final /* synthetic */ VirtualFile $file$inlined;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$file$inlined = virtualFile;
                    this.$project$inlined = project;
                }

                public final T compute() {
                    return (T)Boolean.valueOf(JSMinifiedFileUtil.isFileMinified((VirtualFile)this.$file$inlined, (Project)this.$project$inlined));
                }
            })).booleanValue()) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile.contentsToByteArray(), (String)"file.contentsToByteArray()");
            int maxScore$iv = 10000;
            if (Arrays.equals(sourceBytes, destination$iv)) {
                n = maxScore$iv;
            } else {
                if (sourceIndex == null) {
                    sourceIndex = SimilarityIndexKt.SimilarityIndex(sourceBytes);
                }
                SimilarityIndex similarityIndex = sourceIndex;
                if (similarityIndex == null) {
                    Intrinsics.throwNpe();
                }
                n = SimilarityIndex.score$default(similarityIndex, SimilarityIndexKt.SimilarityIndex(destination$iv), 0, 2, null);
            }
            if ((score = ((contentScore = n) * 99 + 100) / 10000) <= lastMatchedScore) continue;
            matchedFile = virtualFile;
            lastMatchedScore = score;
        }
        return matchedFile;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ VirtualFile selectMostSimilarFile$default(Collection collection, byte[] byArray, Project project, int n, Object object) {
        if ((n & 4) != 0) {
            project = null;
        }
        return FileResolverByContentKt.selectMostSimilarFile((Collection<? extends VirtualFile>)collection, byArray, project);
    }
}

