/*
 * Decompiled with CFR 0.152.
 */
package ini4idea.structureView;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import ini4idea.lang.psi.IniFile;
import ini4idea.lang.psi.IniProperty;
import ini4idea.lang.psi.IniSection;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IniStructureViewFactory
implements PsiStructureViewFactory {
    @Nullable
    public StructureViewBuilder getStructureViewBuilder(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            IniStructureViewFactory.$$$reportNull$$$0(0);
        }
        if (!(psiFile instanceof IniFile)) {
            return null;
        }
        final IniFile iniFile = (IniFile)psiFile;
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                Model model = new Model(iniFile, editor);
                if (model == null) {
                    1.$$$reportNull$$$0(0);
                }
                return model;
            }

            public boolean isRootNodeShown() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ini4idea/structureView/IniStructureViewFactory$1", "createStructureViewModel"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "ini4idea/structureView/IniStructureViewFactory", "getStructureViewBuilder"));
    }

    private static abstract class IniElement<T extends NavigatablePsiElement>
    implements StructureViewTreeElement {
        protected final T myElement;

        public IniElement(T element) {
            this.myElement = element;
        }

        public Object getValue() {
            return this.myElement;
        }

        public void navigate(boolean requestFocus) {
            this.myElement.navigate(requestFocus);
        }

        public boolean canNavigate() {
            return this.myElement.canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.myElement.canNavigateToSource();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            ItemPresentation itemPresentation = this.myElement.getPresentation();
            if (itemPresentation == null) {
                IniElement.$$$reportNull$$$0(0);
            }
            return itemPresentation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ini4idea/structureView/IniStructureViewFactory$IniElement", "getPresentation"));
        }
    }

    private static class PropertyElement
    extends IniElement<IniProperty> {
        public PropertyElement(IniProperty element) {
            super(element);
        }

        @NotNull
        public TreeElement[] getChildren() {
            if (EMPTY_ARRAY == null) {
                PropertyElement.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ini4idea/structureView/IniStructureViewFactory$PropertyElement", "getChildren"));
        }
    }

    private static class SectionElement
    extends IniElement<IniSection> {
        public SectionElement(IniSection element) {
            super(element);
        }

        @NotNull
        public TreeElement[] getChildren() {
            ArrayList<PropertyElement> result = new ArrayList<PropertyElement>();
            for (PsiElement child : ((IniSection)this.myElement).getChildren()) {
                if (!(child instanceof IniProperty)) continue;
                result.add(new PropertyElement((IniProperty)child));
            }
            TreeElement[] treeElementArray = result.toArray(TreeElement.EMPTY_ARRAY);
            if (treeElementArray == null) {
                SectionElement.$$$reportNull$$$0(0);
            }
            return treeElementArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ini4idea/structureView/IniStructureViewFactory$SectionElement", "getChildren"));
        }
    }

    private static class FileElement
    extends IniElement<IniFile> {
        public FileElement(IniFile element) {
            super(element);
        }

        @NotNull
        public TreeElement[] getChildren() {
            ArrayList<IniElement> result = new ArrayList<IniElement>();
            for (PsiElement child : ((IniFile)this.myElement).getChildren()) {
                if (!(child instanceof IniSection)) continue;
                if (((IniSection)child).isNamed()) {
                    result.add(new SectionElement((IniSection)child));
                    continue;
                }
                for (PsiElement grandchild : child.getChildren()) {
                    if (!(grandchild instanceof IniProperty)) continue;
                    result.add(new PropertyElement((IniProperty)grandchild));
                }
            }
            TreeElement[] treeElementArray = result.toArray(TreeElement.EMPTY_ARRAY);
            if (treeElementArray == null) {
                FileElement.$$$reportNull$$$0(0);
            }
            return treeElementArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ini4idea/structureView/IniStructureViewFactory$FileElement", "getChildren"));
        }
    }

    private static class Model
    extends StructureViewModelBase
    implements StructureViewModel.ElementInfoProvider {
        private static final Class[] SUITABLE_CLASSES = new Class[]{IniSection.class, IniProperty.class, IniFile.class};

        public Model(@NotNull IniFile psiFile, @Nullable Editor editor) {
            if (psiFile == null) {
                Model.$$$reportNull$$$0(0);
            }
            super((PsiFile)psiFile, editor, (StructureViewTreeElement)new FileElement(psiFile));
            this.withSuitableClasses(SUITABLE_CLASSES);
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
            return false;
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement element) {
            Object psi = element.getValue();
            return psi instanceof IniProperty;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "ini4idea/structureView/IniStructureViewFactory$Model", "<init>"));
        }
    }
}

