/*
 * Decompiled with CFR 0.152.
 */
package ini4idea.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import icons.Ini4ideaIcons;
import ini4idea.lang.psi.IniProperty;
import ini4idea.lang.psi.IniSection;
import ini4idea.lang.psi.IniSectionName;
import ini4idea.lang.psi.SimpleElementFactory;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class IniPsiImplUtilClass {
    @Nullable
    public static String getNameText(IniSection section) {
        if (!section.isValid()) {
            return null;
        }
        IniSectionName sectionName = section.getIniSectionName();
        return sectionName == null ? null : sectionName.getText();
    }

    public static boolean isNamed(IniSection section) {
        return IniPsiImplUtilClass.getNameText(section) != null;
    }

    @Nullable
    public static ItemPresentation getPresentation(final IniProperty property) {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                if (!property.isValid()) {
                    return null;
                }
                return property.getIniKey().getText();
            }

            @Nullable
            public String getLocationString() {
                if (!property.isValid()) {
                    return null;
                }
                return property.getContainingFile().getName();
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }
        };
    }

    @Nullable
    public static ItemPresentation getPresentation(final IniSection section) {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return section.getNameText();
            }

            @Nullable
            public String getLocationString() {
                if (!section.isValid()) {
                    return null;
                }
                return section.getContainingFile().getName();
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return Ini4ideaIcons.Ini_list_of_directives;
            }
        };
    }

    public static String getName(IniProperty property) {
        return property.getIniKey().getFirstChild().getText();
    }

    public static PsiElement setName(IniProperty element, String newName) {
        IniProperty property = SimpleElementFactory.createNamedElement(element.getProject(), newName);
        ASTNode newKeyNode = property.getFirstChild().getFirstChild().getNode();
        element.getNode().getFirstChildNode().replaceChild(element.getFirstChild().getFirstChild().getNode(), newKeyNode);
        return element;
    }

    public static PsiElement getNameElement(IniProperty property) {
        return property.getIniKey().getIniKeyName();
    }

    @NonNls
    public static String toString(IniProperty property) {
        return "IniPropertyImpl";
    }
}

