/*
 * Decompiled with CFR 0.152.
 */
package ini4idea.lang;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import ini4idea.ide.IniPropertyKeyIndex;
import ini4idea.lang.psi.IniProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IniPropertyReference
implements PsiPolyVariantReference,
EmptyResolveMessageProvider {
    private static final Logger LOG = Logger.getInstance(IniPropertyReference.class);
    protected final String myKey;
    protected final PsiElement myElement;
    protected boolean mySoft;
    private final TextRange myTextRange;

    public IniPropertyReference(@NotNull String key, boolean soft, @NotNull PsiElement element) {
        if (key == null) {
            IniPropertyReference.$$$reportNull$$$0(0);
        }
        if (element == null) {
            IniPropertyReference.$$$reportNull$$$0(1);
        }
        this(key, soft, element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    public IniPropertyReference(@NotNull String key, boolean soft, @NotNull PsiElement element, TextRange range) {
        if (key == null) {
            IniPropertyReference.$$$reportNull$$$0(2);
        }
        if (element == null) {
            IniPropertyReference.$$$reportNull$$$0(3);
        }
        this.myKey = key;
        this.mySoft = soft;
        this.myElement = element;
        this.myTextRange = range;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    protected String getKeyText() {
        String string = this.myKey;
        if (string == null) {
            IniPropertyReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IniPropertyReference other = (IniPropertyReference)o;
        return this.getElement() == other.getElement() && this.getKeyText().equals(other.getKeyText());
    }

    public int hashCode() {
        return this.getKeyText().hashCode();
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            IniPropertyReference.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public TextRange getRangeInElement() {
        return this.myTextRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myKey;
        if (string == null) {
            IniPropertyReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
        if (manipulator == null) {
            LOG.error("Cannot find manipulator for " + this.myElement + " of class " + this.myElement.getClass());
        }
        return manipulator != null ? manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName) : null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            IniPropertyReference.$$$reportNull$$$0(7);
        }
        throw new IncorrectOperationException("not implemented");
    }

    public boolean isReferenceTo(PsiElement element) {
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement el = result.getElement();
            if (el == null || !el.isEquivalentTo(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("Unresolved key" == null) {
            IniPropertyReference.$$$reportNull$$$0(8);
        }
        return "Unresolved key";
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        String key = this.getKeyText();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myElement.getProject());
        Collection<IniProperty> iniProperties = IniPropertyKeyIndex.getInstance().get(key.toUpperCase(), this.myElement.getProject(), scope);
        ArrayList<IniProperty> properties = new ArrayList<IniProperty>(iniProperties);
        ResolveResult[] resolveResultArray = IniPropertyReference.getResolveResults(properties);
        if (resolveResultArray == null) {
            IniPropertyReference.$$$reportNull$$$0(9);
        }
        return resolveResultArray;
    }

    protected static ResolveResult[] getResolveResults(List<IniProperty> properties) {
        if (properties.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] results = new ResolveResult[properties.size()];
        for (int i = 0; i < properties.size(); ++i) {
            IniProperty property = properties.get(i);
            if (property == null) continue;
            results[i] = new PsiElementResolveResult((PsiElement)property);
        }
        return results;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            IniPropertyReference.$$$reportNull$$$0(10);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ini4idea/lang/IniPropertyReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ini4idea/lang/IniPropertyReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

