/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.editor;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSInjectionBracesUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NullableFunction;
import java.util.Arrays;
import java.util.List;
import org.angularjs.codeInsight.attributes.AngularAttributesRegistry;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularInjectionDelimiterIndex;
import org.angularjs.lang.AngularJSLanguage;
import org.jetbrains.annotations.NotNull;

public class AngularJSInjector
implements MultiHostInjector {
    public static final NullableFunction<PsiElement, Pair<String, String>> BRACES_FACTORY = JSInjectionBracesUtil.delimitersFactory((String)AngularJSLanguage.INSTANCE.getDisplayName(), (project, key) -> {
        JSImplicitElement element = AngularIndexUtil.resolve(project, AngularInjectionDelimiterIndex.KEY, key);
        return element != null ? Pair.create((Object)element.getTypeString(), (Object)element) : null;
    });

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            AngularJSInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AngularJSInjector.$$$reportNull$$$0(1);
        }
        if (context.getLanguage() == XMLLanguage.INSTANCE) {
            return;
        }
        Project project = context.getProject();
        if (!AngularIndexUtil.hasAngularJS(project)) {
            return;
        }
        PsiElement parent = context.getParent();
        if (context instanceof XmlAttributeValueImpl && parent instanceof XmlAttribute) {
            String value = context.getText();
            int start = value.startsWith("'") || value.startsWith("\"") ? 1 : 0;
            int end = value.endsWith("'") || value.endsWith("\"") ? 1 : 0;
            int length = value.length();
            if (AngularAttributesRegistry.isAngularExpressionAttribute((XmlAttribute)parent) && length > 1) {
                registrar.startInjecting((Language)AngularJSLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)context, new TextRange(start, length - end)).doneInjecting();
                return;
            }
            if (AngularAttributesRegistry.isJSONAttribute((XmlAttribute)parent) && length > 1) {
                registrar.startInjecting((Language)JsonLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)context, new TextRange(start, length - end)).doneInjecting();
                return;
            }
        }
        if (context instanceof XmlTextImpl && !AngularJSInjector.nonBindable((XmlTextImpl)context) || context instanceof XmlAttributeValueImpl) {
            Pair braces = (Pair)BRACES_FACTORY.fun((Object)context);
            if (braces == null) {
                return;
            }
            JSInjectionBracesUtil.injectInXmlTextByDelimiters((MultiHostRegistrar)registrar, (PsiElement)context, (Language)AngularJSLanguage.INSTANCE, (String)((String)braces.getFirst()), (String)((String)braces.getSecond()));
        }
    }

    private static boolean nonBindable(@NotNull XmlTextImpl xmlText) {
        XmlTag parentTag;
        if (xmlText == null) {
            AngularJSInjector.$$$reportNull$$$0(2);
        }
        return (parentTag = xmlText.getParentTag()) != null && (parentTag.getAttribute("ngNonBindable") != null || parentTag.getAttribute("ng-non-bindable") != null);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlTextImpl.class, XmlAttributeValueImpl.class);
        if (list == null) {
            AngularJSInjector.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/editor/AngularJSInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/editor/AngularJSInjector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "nonBindable";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

