/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.cli;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSProjectConfigurator
implements DirectoryProjectConfigurator {
    public static final String ANGULAR_JSON = "angular.json";
    public static final String ANGULAR_CLI_JSON = ".angular-cli.json";
    public static final String DEPRECATED_ANGULAR_CLI_JSON = "angular-cli.json";

    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        ModuleManager moduleManager;
        Module[] modules;
        if (baseDir == null) {
            AngularJSProjectConfigurator.$$$reportNull$$$0(0);
        }
        if ((modules = (moduleManager = ModuleManager.getInstance((Project)project)).getModules()).length == 1) {
            VirtualFile cliJson = AngularJSProjectConfigurator.findCliJson(baseDir);
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)modules[0]).getModifiableModel();
            ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)baseDir);
            if (entry != null && cliJson != null) {
                AngularJSProjectConfigurator.excludeDefault(baseDir, entry);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    model.commit();
                    project.save();
                });
            } else {
                model.dispose();
            }
        }
    }

    public static void excludeDefault(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            AngularJSProjectConfigurator.$$$reportNull$$$0(1);
        }
        entry.addExcludeFolder(baseDir.getUrl() + "/dist");
        entry.addExcludeFolder(baseDir.getUrl() + "/tmp");
    }

    @Nullable
    public static VirtualFile findCliJson(@Nullable VirtualFile dir) {
        VirtualFile cliJson = dir != null ? dir.findChild(ANGULAR_JSON) : null;
        cliJson = dir != null && cliJson == null ? dir.findChild(ANGULAR_CLI_JSON) : cliJson;
        cliJson = dir != null && cliJson == null ? dir.findChild(DEPRECATED_ANGULAR_CLI_JSON) : cliJson;
        return cliJson;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "baseDir";
        objectArray2[1] = "org/angularjs/cli/AngularJSProjectConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "excludeDefault";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

