/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.cli;

import com.intellij.execution.filters.Filter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.text.SemVer;
import com.intellij.xml.util.XmlStringUtil;
import icons.AngularJSIcons;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.angularjs.cli.AngularCLIFilter;
import org.angularjs.cli.AngularJSProjectConfigurator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AngularCLIProjectGenerator
extends NpmPackageProjectGenerator {
    public static final String PACKAGE_NAME = "@angular/cli";

    @Nls
    @NotNull
    public String getName() {
        if ("Angular CLI" == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(0);
        }
        return "Angular CLI";
    }

    public String getDescription() {
        return "The Angular CLI makes it easy to create an application that already works, right out of the box. It already follows our best practices!";
    }

    public Icon getIcon() {
        return AngularJSIcons.Angular2;
    }

    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(1);
        }
        if (entry != null) {
            AngularJSProjectConfigurator.excludeDefault(baseDir, entry);
        }
    }

    @NotNull
    protected String[] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(2);
        }
        if (baseDir == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(3);
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(4);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    protected String[] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull NpmPackageProjectGenerator.Settings settings) {
        if (project == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(5);
        }
        if (baseDir == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(7);
        }
        String[] stringArray = new String[]{"new", baseDir.getName(), "--dir=."};
        if (stringArray == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @NotNull
    protected Filter[] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(9);
        }
        if (baseDir == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(10);
        }
        Filter[] filterArray = new Filter[]{new AngularCLIFilter(project, baseDir.getPath())};
        if (filterArray == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(11);
        }
        return filterArray;
    }

    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        if (pkg == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(12);
        }
        String string = AngularCLIProjectGenerator.ng(pkg.getSystemDependentPath());
        if (string == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String ng(String path) {
        String string = path + File.separator + "bin" + File.separator + "ng";
        if (string == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    protected String packageName() {
        if (PACKAGE_NAME == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(15);
        }
        return PACKAGE_NAME;
    }

    @NotNull
    protected String presentablePackageName() {
        if ("Angular &CLI:" == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(16);
        }
        return "Angular &CLI:";
    }

    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        List<NpxPackageDescriptor.NpxCommand> list = Collections.singletonList(new NpxPackageDescriptor.NpxCommand(PACKAGE_NAME, "ng"));
        if (list == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(17);
        }
        return list;
    }

    protected String validateProjectPath(@NotNull String path) {
        if (path == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(18);
        }
        String fileName = PathUtil.getFileName((String)path);
        for (String segment : fileName.split("-")) {
            if (segment.matches("[a-zA-Z][.0-9a-zA-Z]*(-[.0-9a-zA-Z]*)*")) continue;
            return XmlStringUtil.wrapInHtml((CharSequence)("Project name " + fileName + " is not valid. New project names must<br>\nstart with a letter, and must contain only alphanumeric characters or dashes.<br>\nWhen adding a dash the segment after the dash must also start with a letter."));
        }
        return super.validateProjectPath(path);
    }

    @NotNull
    protected File workingDir(NpmPackageProjectGenerator.Settings settings, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(19);
        }
        File workingDir = super.workingDir(settings, baseDir);
        SemVer version = settings.myPackage.getVersion();
        File file = version == null || version.isGreaterOrEqualThan(6, 0, 0) ? workingDir.getParentFile() : workingDir;
        if (file == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(20);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/cli/AngularCLIProjectGenerator";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/cli/AngularCLIProjectGenerator";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generatorArgs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filters";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "executable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "ng";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "packageName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "presentablePackageName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpxCommands";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "workingDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "customizeModule";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatorArgs";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filters";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "workingDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

