/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.CaptureMatchData;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexFacade;

public final class SyntaxMatchUtils {
    private static final Pattern DIGIT_GROUP_REGEX = Pattern.compile("\\\\([0-9]+)");

    @NotNull
    public static TextMateLexerState matchFirst(SyntaxNodeDescriptor syntaxNodeDescriptor, String line, int position) {
        TextMateLexerState resultState = new TextMateLexerState(syntaxNodeDescriptor, MatchData.NOT_MATCHED);
        List<SyntaxNodeDescriptor> children = syntaxNodeDescriptor.getChildren();
        for (SyntaxNodeDescriptor child : children) {
            resultState = SyntaxMatchUtils.moreImportantState(resultState, SyntaxMatchUtils.matchFirstChild(child, line, position));
        }
        TextMateLexerState textMateLexerState = resultState;
        if (textMateLexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(0);
        }
        return textMateLexerState;
    }

    @NotNull
    private static TextMateLexerState moreImportantState(@NotNull TextMateLexerState oldState, @NotNull TextMateLexerState newState) {
        if (oldState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(1);
        }
        if (newState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(2);
        }
        if (!oldState.matchData.matched()) {
            TextMateLexerState textMateLexerState = newState;
            if (textMateLexerState == null) {
                SyntaxMatchUtils.$$$reportNull$$$0(3);
            }
            return textMateLexerState;
        }
        if (!newState.matchData.matched()) {
            TextMateLexerState textMateLexerState = oldState;
            if (textMateLexerState == null) {
                SyntaxMatchUtils.$$$reportNull$$$0(4);
            }
            return textMateLexerState;
        }
        if (newState.matchData.offset().getStartOffset() < oldState.matchData.offset().getStartOffset() && (!newState.matchData.offset().isEmpty() || oldState.matchData.offset().isEmpty() || SyntaxMatchUtils.hasBeginKey(newState))) {
            TextMateLexerState textMateLexerState = newState;
            if (textMateLexerState == null) {
                SyntaxMatchUtils.$$$reportNull$$$0(5);
            }
            return textMateLexerState;
        }
        TextMateLexerState textMateLexerState = oldState;
        if (textMateLexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(6);
        }
        return textMateLexerState;
    }

    private static boolean hasBeginKey(@NotNull TextMateLexerState lexerState) {
        if (lexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(7);
        }
        return lexerState.syntaxRule.getRegexAttribute("begin") != null;
    }

    private static TextMateLexerState matchFirstChild(SyntaxNodeDescriptor syntaxNodeDescriptor, String line, int position) {
        RegexFacade matchRegex = syntaxNodeDescriptor.getRegexAttribute("match");
        if (matchRegex != null) {
            return new TextMateLexerState(syntaxNodeDescriptor, matchRegex.match(line, position));
        }
        RegexFacade beginRegex = syntaxNodeDescriptor.getRegexAttribute("begin");
        if (beginRegex != null) {
            return new TextMateLexerState(syntaxNodeDescriptor, beginRegex.match(line, position));
        }
        if (syntaxNodeDescriptor.getStringAttribute("end") != null) {
            return new TextMateLexerState(syntaxNodeDescriptor, MatchData.NOT_MATCHED);
        }
        return SyntaxMatchUtils.matchFirst(syntaxNodeDescriptor, line, position);
    }

    public static List<CaptureMatchData> matchCaptures(@NotNull Plist captures, @NotNull MatchData matchData) {
        if (captures == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(8);
        }
        if (matchData == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(9);
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (Map.Entry<String, PListValue> capture : captures.entries()) {
            try {
                TextRange offset;
                Integer index = Integer.parseInt(capture.getKey(), 10);
                Plist captureDict = capture.getValue().getPlist();
                String captureName = captureDict.getPlistValue("name", "").getString();
                TextRange textRange = offset = index < matchData.count() ? matchData.offset(index) : TextRange.EMPTY_RANGE;
                if (captureName.isEmpty() || offset.getLength() <= 0) continue;
                result.add(new CaptureMatchData(offset, index, captureName));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public static MatchData matchStringRegex(String keyName, String line, TextMateLexerState lexerState, int linePosition) {
        String stringRegex = lexerState.syntaxRule.getStringAttribute(keyName);
        return stringRegex != null ? RegexFacade.regex(SyntaxMatchUtils.replaceGroupsWithMatchData(stringRegex, lexerState.matchData)).match(line, linePosition) : MatchData.NOT_MATCHED;
    }

    public static String replaceGroupsWithMatchData(String patternString, MatchData matchData) {
        Matcher matcher = DIGIT_GROUP_REGEX.matcher(patternString);
        StringBuilder result = new StringBuilder();
        int lastPosition = 0;
        while (matcher.find()) {
            int groupIndex = StringUtil.parseInt((String)matcher.group(1), (int)-1);
            if (groupIndex < 0 || matchData.count() <= groupIndex) continue;
            result.append(patternString.substring(lastPosition, matcher.start()));
            StringUtil.escapeToRegexp((CharSequence)matchData.capture(groupIndex), (StringBuilder)result);
            lastPosition = matcher.end();
        }
        if (lastPosition < patternString.length()) {
            result.append(patternString.substring(lastPosition));
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexerState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captures";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "matchFirst";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "moreImportantState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moreImportantState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasBeginKey";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchCaptures";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

