/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import org.jcodings.util.Hash;

public class IntHash<V>
extends Hash<V> {
    public IntHash() {
    }

    public IntHash(int n) {
        super(n);
    }

    @Override
    protected void init() {
        this.head = new IntHashEntry();
    }

    public V put(int n, V v) {
        this.checkResize();
        int n2 = IntHash.hashValue(n);
        int n3 = IntHash.bucketIndex(n2, this.table.length);
        IntHashEntry intHashEntry = (IntHashEntry)this.table[n3];
        while (intHashEntry != null) {
            if (intHashEntry.hash == n2) {
                intHashEntry.value = v;
                return v;
            }
            intHashEntry = (IntHashEntry)intHashEntry.next;
        }
        this.table[n3] = new IntHashEntry<V>(n2, this.table[n3], v, this.head);
        ++this.size;
        return null;
    }

    public void putDirect(int n, V v) {
        this.checkResize();
        int n2 = IntHash.hashValue(n);
        int n3 = IntHash.bucketIndex(n2, this.table.length);
        this.table[n3] = new IntHashEntry<V>(n2, this.table[n3], v, this.head);
        ++this.size;
    }

    public V get(int n) {
        int n2 = IntHash.hashValue(n);
        IntHashEntry intHashEntry = (IntHashEntry)this.table[IntHash.bucketIndex(n2, this.table.length)];
        while (intHashEntry != null) {
            if (intHashEntry.hash == n2) {
                return (V)intHashEntry.value;
            }
            intHashEntry = (IntHashEntry)intHashEntry.next;
        }
        return null;
    }

    public V delete(int n) {
        int n2 = IntHash.hashValue(n);
        int n3 = IntHash.bucketIndex(n2, this.table.length);
        IntHashEntry intHashEntry = (IntHashEntry)this.table[n3];
        if (intHashEntry == null) {
            return null;
        }
        if (intHashEntry.hash == n2) {
            this.table[n3] = intHashEntry.next;
            --this.size;
            intHashEntry.remove();
            return (V)intHashEntry.value;
        }
        while (intHashEntry.next != null) {
            Hash.HashEntry hashEntry = intHashEntry.next;
            if (hashEntry.hash == n2 && intHashEntry.equals(n)) {
                intHashEntry.next = intHashEntry.next.next;
                --this.size;
                hashEntry.remove();
                return hashEntry.value;
            }
            intHashEntry = (IntHashEntry)intHashEntry.next;
        }
        return null;
    }

    public static final class IntHashEntry<V>
    extends Hash.HashEntry<V> {
        public IntHashEntry(int n, Hash.HashEntry<V> hashEntry, V v, Hash.HashEntry<V> hashEntry2) {
            super(n, hashEntry, v, hashEntry2);
        }

        public IntHashEntry() {
        }
    }
}

