/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import org.jcodings.util.Hash;

public final class IntArrayHash<V>
extends Hash<V> {
    public IntArrayHash() {
    }

    public IntArrayHash(int n) {
        super(n);
    }

    @Override
    protected void init() {
        this.head = new IntArrayHashEntry();
    }

    private int hashCode(int[] nArray) {
        switch (nArray.length) {
            case 1: {
                return nArray[0];
            }
            case 2: {
                return nArray[0] + nArray[1];
            }
            case 3: {
                return nArray[0] + nArray[1] + nArray[2];
            }
            case 4: {
                return nArray[0] + nArray[1] + nArray[2] + nArray[3];
            }
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public V put(int[] nArray, V v) {
        this.checkResize();
        int n = IntArrayHash.hashValue(this.hashCode(nArray));
        int n2 = IntArrayHash.bucketIndex(n, this.table.length);
        IntArrayHashEntry intArrayHashEntry = (IntArrayHashEntry)this.table[n2];
        while (intArrayHashEntry != null) {
            if (intArrayHashEntry.hash == n && intArrayHashEntry.equals(nArray)) {
                intArrayHashEntry.value = v;
                return v;
            }
            intArrayHashEntry = (IntArrayHashEntry)intArrayHashEntry.next;
        }
        this.table[n2] = new IntArrayHashEntry<V>(n, this.table[n2], v, nArray, this.head);
        ++this.size;
        return null;
    }

    public void putDirect(int[] nArray, V v) {
        this.checkResize();
        int n = IntArrayHash.hashValue(this.hashCode(nArray));
        int n2 = IntArrayHash.bucketIndex(n, this.table.length);
        this.table[n2] = new IntArrayHashEntry<V>(n, this.table[n2], v, nArray, this.head);
        ++this.size;
    }

    public V get(int ... nArray) {
        int n = IntArrayHash.hashValue(this.hashCode(nArray));
        IntArrayHashEntry intArrayHashEntry = (IntArrayHashEntry)this.table[IntArrayHash.bucketIndex(n, this.table.length)];
        while (intArrayHashEntry != null) {
            if (intArrayHashEntry.hash == n && intArrayHashEntry.equals(nArray)) {
                return (V)intArrayHashEntry.value;
            }
            intArrayHashEntry = (IntArrayHashEntry)intArrayHashEntry.next;
        }
        return null;
    }

    public V delete(int ... nArray) {
        int n = IntArrayHash.hashValue(this.hashCode(nArray));
        int n2 = IntArrayHash.bucketIndex(n, this.table.length);
        IntArrayHashEntry intArrayHashEntry = (IntArrayHashEntry)this.table[n2];
        if (intArrayHashEntry == null) {
            return null;
        }
        if (intArrayHashEntry.hash == n && intArrayHashEntry.equals(nArray)) {
            this.table[n2] = intArrayHashEntry.next;
            --this.size;
            intArrayHashEntry.remove();
            return (V)intArrayHashEntry.value;
        }
        while (intArrayHashEntry.next != null) {
            Hash.HashEntry hashEntry = intArrayHashEntry.next;
            if (hashEntry.hash == n && intArrayHashEntry.equals(nArray)) {
                intArrayHashEntry.next = intArrayHashEntry.next.next;
                --this.size;
                hashEntry.remove();
                return hashEntry.value;
            }
            intArrayHashEntry = (IntArrayHashEntry)intArrayHashEntry.next;
        }
        return null;
    }

    public static final class IntArrayHashEntry<V>
    extends Hash.HashEntry<V> {
        public final int[] key;

        public IntArrayHashEntry(int n, Hash.HashEntry<V> hashEntry, V v, int[] nArray, Hash.HashEntry<V> hashEntry2) {
            super(n, hashEntry, v, hashEntry2);
            this.key = nArray;
        }

        public IntArrayHashEntry() {
            this.key = null;
        }

        public boolean equals(int[] nArray) {
            if (this.key == nArray) {
                return true;
            }
            if (this.key.length != nArray.length) {
                return false;
            }
            switch (nArray.length) {
                case 1: {
                    return this.key[0] == nArray[0];
                }
                case 2: {
                    return this.key[0] == nArray[0] && this.key[1] == nArray[1];
                }
                case 3: {
                    return this.key[0] == nArray[0] && this.key[1] == nArray[1] && this.key[2] == nArray[2];
                }
                case 4: {
                    return this.key[0] == nArray[0] && this.key[1] == nArray[1] && this.key[2] == nArray[2] && this.key[3] == nArray[3];
                }
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (this.key[i] == nArray[i]) continue;
                return false;
            }
            return true;
        }
    }
}

