/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.transcode;

import org.jcodings.Ptr;
import org.jcodings.exception.TranscoderException;
import org.jcodings.transcode.EConvResult;
import org.jcodings.transcode.Transcoder;
import org.jcodings.transcode.TranscodingInstruction;

public class Transcoding
implements TranscodingInstruction {
    final Transcoder transcoder;
    int flags;
    int resumePosition;
    int nextTable;
    int nextInfo;
    byte nextByte;
    int outputIndex;
    int recognizedLength;
    int readAgainLength;
    final byte[] readBuf;
    int writeBuffOff;
    int writeBuffLen;
    final byte[] writeBuf;
    byte[] state;
    private int charStart;
    private byte[] charStartBytes;
    int inCharStart;
    byte[] inBytes;
    byte[] outBytes;
    int inP;
    int outP;
    int outStop;
    int inStop;
    Ptr inPos;
    Ptr outPos;
    int readAgainL;
    int opt;

    public Transcoding(Transcoder transcoder) {
        this.transcoder = transcoder;
        this.readBuf = new byte[transcoder.maxInput];
        this.writeBuf = new byte[transcoder.maxOutput];
    }

    void close() {
        this.transcoder.stateFinish();
    }

    public String toString() {
        return "Transcoding for transcoder " + this.transcoder.toString();
    }

    int charStart() {
        if (this.recognizedLength > this.inCharStart - this.inPos.p) {
            System.arraycopy(this.inBytes, this.inCharStart, this.readBuf, this.recognizedLength, this.inP - this.inCharStart);
            this.charStart = 0;
            this.charStartBytes = this.readBuf;
        } else {
            this.charStart = this.inCharStart - this.recognizedLength;
            this.charStartBytes = this.inBytes;
        }
        return this.recognizedLength + (this.inP - this.inCharStart);
    }

    EConvResult convert(byte[] byArray, Ptr ptr, int n, byte[] byArray2, Ptr ptr2, int n2, int n3) {
        return null;
    }

    private EConvResult transcodeRestartable(byte[] byArray, Ptr ptr, int n, byte[] byArray2, Ptr ptr2, int n2, int n3) {
        if (this.readAgainLength != 0) {
            byte[] byArray3 = new byte[this.readAgainLength];
            Ptr ptr3 = new Ptr(0);
            int n4 = this.readAgainLength;
            System.arraycopy(this.readBuf, this.recognizedLength, byArray3, ptr3.p, this.readAgainLength);
            this.readAgainLength = 0;
            EConvResult eConvResult = this.transcodeRestartable0(byArray3, ptr3, n4, byArray2, ptr2, n2, n3 | 0x10000);
            if (!eConvResult.isSourceBufferEmpty()) {
                System.arraycopy(byArray3, ptr3.p, this.readBuf, this.recognizedLength + this.readAgainLength, n4 - ptr3.p);
                this.readAgainLength += n4 - ptr3.p;
            }
        }
        return this.transcodeRestartable0(byArray, ptr, n, byArray2, ptr2, n2, n3);
    }

    private EConvResult transcodeRestartable0(byte[] byArray, Ptr ptr, int n, byte[] byArray2, Ptr ptr2, int n2, int n3) {
        this.inPos = ptr;
        this.inP = this.inCharStart = ptr.p;
        this.outPos = ptr2;
        this.readAgainL = 0;
        this.inBytes = byArray;
        this.outBytes = byArray2;
        return null;
    }

    private EConvResult transcodeSwitch() {
        int n = this.resumePosition != 0 ? this.resumePosition : this.nextInfo & 0xFF;
        block7: while (true) {
            switch (n) {
                case 1: {
                    int n2 = this.inCharStart;
                    this.writeBuffOff = 0;
                    while (n2 < this.inP) {
                        this.writeBuf[this.writeBuffOff++] = this.inBytes[n2++];
                    }
                    this.writeBuffLen = this.writeBuffOff;
                    this.writeBuffOff = 0;
                    while (true) {
                        if (this.writeBuffOff >= this.writeBuffLen) continue block7;
                        if (this.outStop - this.outP < 1) {
                            return this.suspend(29);
                        }
                        this.outBytes[this.outP++] = this.writeBuf[this.writeBuffOff++];
                    }
                }
                case 29: {
                    do {
                        if (this.outStop - this.outP < 1) {
                            return this.suspend(29);
                        }
                        this.outBytes[this.outP++] = this.writeBuf[this.writeBuffOff++];
                    } while (this.writeBuffOff < this.writeBuffLen);
                }
                case 0: 
                case 4: 
                case 8: 
                case 12: 
                case 16: 
                case 20: 
                case 24: 
                case 28: {
                    if (this.suspendAfterOutput()) {
                        return this.suspend(EConvResult.AfterOutput, 30);
                    }
                }
                case 30: {
                    if (this.inP >= this.inStop) {
                        if ((this.opt & 0x10000) == 0) {
                            return this.suspend(EConvResult.AfterOutput, 31);
                        }
                        return this.suspend(EConvResult.SourceBufferEmpty, 31);
                    }
                }
                case 31: {
                    if (this.inP >= this.inStop) {
                        if ((this.opt & 0x10000) == 0) {
                            return this.suspend(EConvResult.AfterOutput, 31);
                        }
                        return this.suspend(EConvResult.SourceBufferEmpty, 31);
                    }
                    this.nextByte = this.inBytes[this.inP++];
                    this.nextTable = this.nextInfo;
                }
            }
            break;
        }
        throw new TranscoderException("unknown transcoding instruction: " + n);
    }

    private EConvResult transcodeInstruction_NoMap() {
        return this.transcodeInstruction_NoMap_resume_3();
    }

    private EConvResult transcodeInstruction_NoMap_resume_3() {
        if (this.writeBuffOff < this.writeBuffLen) {
            this.outBytes[this.outP++] = this.writeBuf[this.writeBuffOff++];
            return this.suspend(3);
        }
        return null;
    }

    private EConvResult suspend(EConvResult eConvResult, int n) {
        this.resumePosition = n;
        if (this.inP - this.inCharStart > 0) {
            System.arraycopy(this.inBytes, this.inCharStart, this.readBuf, this.recognizedLength, this.inP - this.inCharStart);
        }
        this.inPos.p = this.inP;
        this.outPos.p = this.outP;
        this.recognizedLength += this.inP - this.inCharStart;
        if (this.readAgainL != 0) {
            this.recognizedLength -= this.readAgainL;
            this.readAgainLength = this.readAgainL;
        }
        return eConvResult;
    }

    private EConvResult suspend(int n) {
        if (this.outStop - this.outP < 1) {
            return this.suspend(EConvResult.DestinationBufferFull, n);
        }
        return null;
    }

    private boolean suspendAfterOutput() {
        return (this.opt & 0x20000) != 0 && this.outPos.p != this.outP;
    }

    public static int getGB4bt0(int n) {
        return n >>> 8;
    }

    public static int getGB4bt1(int n) {
        return n >>> 24 & 0xF | 0x30;
    }

    public static int getGB4bt2(int n) {
        return n >>> 16;
    }

    public static int getGB4bt3(int n) {
        return n >>> 28 & 0xF | 0x30;
    }
}

