/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.transcode;

import org.jcodings.exception.InternalException;
import org.jcodings.transcode.AsciiCompatibility;
import org.jcodings.transcode.GenericTranscoder;
import org.jcodings.transcode.Transcoding;
import org.jcodings.transcode.TranscodingInstruction;
import org.jcodings.util.ArrayReader;
import org.jcodings.util.BytesHash;
import org.jcodings.util.ObjHash;

public abstract class Transcoder
implements TranscodingInstruction {
    final byte[] source;
    final byte[] destination;
    final int hashCode;
    final int treeStart;
    final byte[] byteArray;
    final int[] intArray;
    final int inputUnitLength;
    final int maxInput;
    final int maxOutput;
    final AsciiCompatibility compatibility;
    final int stateSize;
    final byte[] state;
    static final ObjHash<String, byte[]> byteArrayHash = new ObjHash();
    static final ObjHash<String, int[]> wordArrayHash = new ObjHash();

    protected Transcoder(byte[] byArray, byte[] byArray2, int n, String string, int n2, int n3, int n4, AsciiCompatibility asciiCompatibility, int n5) {
        this.source = byArray;
        this.destination = byArray2;
        this.hashCode = BytesHash.hashCode(this.source, 0, this.source.length);
        this.treeStart = n;
        byte[] byArray3 = byteArrayHash.get(string);
        if (byArray3 == null) {
            byArray3 = ArrayReader.readByteArray("Transcoder_" + string + "_ByteArray");
            byteArrayHash.put(string, byArray3);
        }
        this.byteArray = byArray3;
        int[] nArray = wordArrayHash.get(string);
        if (nArray == null) {
            nArray = ArrayReader.readIntArray("Transcoder_" + string + "_WordArray");
            wordArrayHash.put(string, nArray);
        }
        this.intArray = nArray;
        this.inputUnitLength = n2;
        this.maxInput = n3;
        this.maxOutput = n4;
        this.compatibility = asciiCompatibility;
        this.stateSize = n5;
        this.state = n5 == 0 ? null : new byte[n5];
    }

    protected Transcoder(String string, String string2, int n, String string3, int n2, int n3, int n4, AsciiCompatibility asciiCompatibility, int n5) {
        this(string.getBytes(), string2.getBytes(), n, string3, n2, n3, n4, asciiCompatibility, n5);
    }

    public int stateInit() {
        return 0;
    }

    public int stateFinish() {
        return 0;
    }

    public Object infoToInfo(Object object) {
        return object;
    }

    public Object startToInfo(Object object) {
        return object;
    }

    public int infoToOutput(byte[] byArray, int n) {
        return 0;
    }

    public int startToOutput(byte[] byArray, int n) {
        return 0;
    }

    public int finish(byte[] byArray, int n) {
        return 0;
    }

    public int resetSize() {
        return 0;
    }

    public int resetState(byte[] byArray, int n) {
        return 0;
    }

    public int startToOutput(byte[] byArray, int n, Object object, byte[] byArray2, int n2) {
        return 0;
    }

    public final Transcoding transcoding(int n) {
        Transcoding transcoding = new Transcoding(this);
        transcoding.flags = n;
        return transcoding;
    }

    public static Transcoder load(String string) {
        Class<?> clazz;
        String string2 = "org.jcodings.transcode.specific." + string + "_Transcoder";
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalException("transcoder class <%n> not found", string2);
        }
        try {
            return (Transcoder)clazz.getField("INSTANCE").get(clazz);
        }
        catch (Exception exception) {
            throw new InternalException("problem loading transcoder <%n>", string2);
        }
    }

    public String toString() {
        return new String(this.source) + " => " + new String(this.destination);
    }

    public String toStringFull() {
        int n;
        String string = "Transcoder (" + new String(this.source) + " => " + new String(this.destination) + ")\n";
        string = string + "  class: " + this.getClass().getSimpleName() + "\n";
        string = string + "  treeStart: " + this.treeStart + "\n";
        string = string + "  byteArray:" + this.byteArray.length + " (";
        for (n = 0; n < 20; ++n) {
            string = string + (this.byteArray[n] & 0xFF) + ", ";
        }
        string = string + "...)\n";
        string = string + "  wordArray:" + this.intArray.length + " (";
        for (n = 0; n < 20; ++n) {
            string = string + ((long)this.intArray[n] & 0xFFFFFFFFL) + ", ";
        }
        string = string + "...)\n";
        string = string + "  input unit length: " + this.inputUnitLength + "\n";
        string = string + "  max input: " + this.maxInput + "\n";
        string = string + "  max output: " + this.maxOutput + "\n";
        string = string + "  compatibility: " + (Object)((Object)this.compatibility) + "\n";
        string = string + "  state size: " + this.stateSize + "\n";
        return string;
    }

    static final class GenericTranscoderEntry {
        final byte[] source;
        final byte[] destination;
        final String arrayKey;
        final int treeStart;
        final int inputUnitLength;
        final int maxInput;
        final int maxOutput;
        final int stateSize;
        final AsciiCompatibility compatibility;

        GenericTranscoderEntry(String string, String string2, int n, String string3, int n2, int n3, int n4, AsciiCompatibility asciiCompatibility, int n5) {
            this.source = string.getBytes();
            this.destination = string2.getBytes();
            this.treeStart = n;
            this.arrayKey = string3;
            this.inputUnitLength = n2;
            this.maxInput = n3;
            this.maxOutput = n4;
            this.compatibility = asciiCompatibility;
            this.stateSize = n5;
        }

        Transcoder createTranscoder() {
            return new GenericTranscoder(this.source, this.destination, this.treeStart, this.arrayKey, this.inputUnitLength, this.maxInput, this.maxOutput, this.compatibility, this.stateSize);
        }
    }
}

