/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.unicode.UnicodeEncoding;

public final class UTF16LEEncoding
extends UnicodeEncoding {
    public static final UTF16LEEncoding INSTANCE = new UTF16LEEncoding();

    protected UTF16LEEncoding() {
        super("UTF-16LE", 2, 4, UTF16BEEncoding.UTF16EncLen);
    }

    @Override
    public int length(byte by) {
        return this.EncLen[(by & 0xFF) + 1];
    }

    @Override
    public int length(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 2) {
            return this.missing(1);
        }
        int n4 = byArray[n + 1] & 0xFF;
        if (!UTF16LEEncoding.isSurrogate(n4)) {
            return 2;
        }
        if (UTF16LEEncoding.isSurrogateFirst(n4)) {
            if (n3 < 4) {
                return this.missing(4 - n3);
            }
            if (UTF16LEEncoding.isSurrogateSecond(byArray[n + 3] & 0xFF)) {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public boolean isNewLine(byte[] byArray, int n, int n2) {
        return n + 1 < n2 && byArray[n] == 10 && byArray[n + 1] == 0;
    }

    @Override
    public int mbcToCode(byte[] byArray, int n, int n2) {
        int n3;
        if (UTF16LEEncoding.isSurrogateFirst(byArray[n + 1] & 0xFF)) {
            int n4 = byArray[n] & 0xFF;
            int n5 = byArray[n + 1] & 0xFF;
            n3 = (((n5 << 8) + n4 & 0x3FF) << 10) + (((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 2] & 0xFF) & 0x3FF) + 65536;
        } else {
            n3 = (byArray[n + 1] & 0xFF) * 256 + (byArray[n + 0] & 0xFF);
        }
        return n3;
    }

    @Override
    public int codeToMbcLength(int n) {
        return n > 65535 ? 4 : 2;
    }

    @Override
    public int codeToMbc(int n, byte[] byArray, int n2) {
        int n3 = n2;
        if (n > 65535) {
            int n4 = (n >>> 10) + 55232;
            int n5 = (n & 0x3FF) + 56320;
            byArray[n3++] = (byte)(n4 & 0xFF);
            byArray[n3++] = (byte)(n4 >>> 8 & 0xFF);
            byArray[n3++] = (byte)(n5 & 0xFF);
            byArray[n3] = (byte)(n5 >>> 8 & 0xFF);
            return 4;
        }
        byArray[n3++] = (byte)(n & 0xFF);
        byArray[n3++] = (byte)((n & 0xFF00) >>> 8);
        return 2;
    }

    @Override
    public int mbcCaseFold(int n, byte[] byArray, IntHolder intHolder, int n2, byte[] byArray2) {
        int n3 = intHolder.value;
        int n4 = 0;
        if (UTF16LEEncoding.isAscii(byArray[n3] & 0xFF) && byArray[n3 + 1] == 0) {
            byArray2[n4++] = AsciiTables.ToLowerCaseTable[byArray[n3] & 0xFF];
            byArray2[n4] = 0;
            intHolder.value += 2;
            return 2;
        }
        return super.mbcCaseFold(n, byArray, intHolder, n2, byArray2);
    }

    @Override
    public int[] ctypeCodeRange(int n, IntHolder intHolder) {
        intHolder.value = 0;
        return super.ctypeCodeRange(n);
    }

    @Override
    public int leftAdjustCharHead(byte[] byArray, int n, int n2, int n3) {
        if (n2 <= n) {
            return n2;
        }
        if ((n2 - n) % 2 == 1) {
            --n2;
        }
        if (UTF16LEEncoding.isSurrogateSecond(byArray[n2 + 1] & 0xFF) && n2 > n + 1) {
            n2 -= 2;
        }
        return n2;
    }

    @Override
    public boolean isReverseMatchAllowed(byte[] byArray, int n, int n2) {
        return false;
    }

    private static boolean isSurrogateFirst(int n) {
        return (n & 0xFC) == 216;
    }

    private static boolean isSurrogateSecond(int n) {
        return (n & 0xFC) == 220;
    }

    private static boolean isSurrogate(int n) {
        return (n & 0xF8) == 216;
    }
}

