/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.CanBeTrailTableEncoding;
import org.jcodings.CodeRange;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingException;
import org.jcodings.exception.InternalException;
import org.jcodings.util.BytesHash;

abstract class BaseSJISEncoding
extends CanBeTrailTableEncoding {
    private static final int[] CR_Hiragana = new int[]{1, 33439, 33521};
    private static final int[] CR_Katakana = new int[]{4, 166, 175, 177, 221, 33600, 33662, 33664, 33686};
    private static final int[][] PropertyList = new int[][]{CR_Hiragana, CR_Katakana};
    private static final BytesHash<Integer> CTypeNameHash = new BytesHash();
    static final boolean[] SJIS_CAN_BE_TRAIL_TABLE;
    static final int[] SjisEncLen;

    protected BaseSJISEncoding(int[][] nArray) {
        super("Shift_JIS", 1, 2, SjisEncLen, nArray, AsciiTables.AsciiCtypeTable, SJIS_CAN_BE_TRAIL_TABLE);
    }

    @Override
    public String getCharsetName() {
        return "windows-31j";
    }

    @Override
    public int mbcToCode(byte[] byArray, int n, int n2) {
        return this.mbnMbcToCode(byArray, n, n2);
    }

    @Override
    public int codeToMbcLength(int n) {
        if (n < 256) {
            return SjisEncLen[n] == 1 ? 1 : 0;
        }
        if (n <= 65535) {
            return 2;
        }
        throw new EncodingException("invalid code point value");
    }

    @Override
    public int codeToMbc(int n, byte[] byArray, int n2) {
        int n3 = n2;
        if ((n & 0xFF00) != 0) {
            byArray[n3++] = (byte)(n >> 8 & 0xFF);
        }
        byArray[n3++] = (byte)(n & 0xFF);
        return n3 - n2;
    }

    @Override
    public int mbcCaseFold(int n, byte[] byArray, IntHolder intHolder, int n2, byte[] byArray2) {
        return this.mbnMbcCaseFold(n, byArray, intHolder, n2, byArray2);
    }

    @Override
    public int propertyNameToCType(byte[] byArray, int n, int n2) {
        Integer n3 = CTypeNameHash.get(byArray, n, n2);
        if (n3 == null) {
            return super.propertyNameToCType(byArray, n, n2);
        }
        return n3;
    }

    @Override
    public boolean isCodeCType(int n, int n2) {
        if (n2 <= 14) {
            if (n < 128) {
                return this.isCodeCTypeInternal(n, n2);
            }
            return BaseSJISEncoding.isWordGraphPrint(n2);
        }
        if ((n2 -= 15) >= PropertyList.length) {
            throw new InternalException("undefined type (bug)");
        }
        return CodeRange.isInCodeRange(PropertyList[n2], n);
    }

    @Override
    public int[] ctypeCodeRange(int n, IntHolder intHolder) {
        if (n <= 14) {
            return null;
        }
        intHolder.value = 128;
        if ((n -= 15) >= PropertyList.length) {
            throw new InternalException("undefined type (bug)");
        }
        return PropertyList[n];
    }

    static {
        CTypeNameHash.put("Hiragana".getBytes(), 15);
        CTypeNameHash.put("Katakana".getBytes(), 16);
        SJIS_CAN_BE_TRAIL_TABLE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false};
        SjisEncLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1};
    }
}

