/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.CodeRange;
import org.jcodings.EucEncoding;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingException;
import org.jcodings.exception.InternalException;
import org.jcodings.util.CaseInsensitiveBytesHash;

abstract class BaseEUCJPEncoding
extends EucEncoding {
    private static final int[] CR_Hiragana = new int[]{1, 42145, 42227};
    private static final int[] CR_Katakana = new int[]{3, 42401, 42486, 43686, 43695, 43697, 43741};
    private static final int[][] PropertyList = new int[][]{CR_Hiragana, CR_Katakana};
    private static final CaseInsensitiveBytesHash<Integer> CTypeNameHash = new CaseInsensitiveBytesHash();
    static final int[] EUCJPEncLen;

    protected BaseEUCJPEncoding(int[][] nArray) {
        super("EUC-JP", 1, 3, EUCJPEncLen, nArray, AsciiTables.AsciiCtypeTable);
    }

    @Override
    public int mbcToCode(byte[] byArray, int n, int n2) {
        return this.mbnMbcToCode(byArray, n, n2);
    }

    @Override
    public int codeToMbcLength(int n) {
        if (BaseEUCJPEncoding.isAscii(n)) {
            return 1;
        }
        if (n > 0xFFFFFF) {
            return 0;
        }
        if ((n & 0xFF0000) >= 0x800000) {
            return 3;
        }
        if ((n & 0xFF00) >= 32768) {
            return 2;
        }
        throw new EncodingException("invalid code point value");
    }

    @Override
    public int codeToMbc(int n, byte[] byArray, int n2) {
        int n3 = n2;
        if ((n & 0xFF0000) != 0) {
            byArray[n3++] = (byte)(n >> 16 & 0xFF);
        }
        if ((n & 0xFF00) != 0) {
            byArray[n3++] = (byte)(n >> 8 & 0xFF);
        }
        byArray[n3++] = (byte)(n & 0xFF);
        if (this.length(byArray, n2, n3) != n3 - n2) {
            throw new EncodingException("invalid code point value");
        }
        return n3 - n2;
    }

    @Override
    public int mbcCaseFold(int n, byte[] byArray, IntHolder intHolder, int n2, byte[] byArray2) {
        int n3 = intHolder.value++;
        int n4 = 0;
        if (BaseEUCJPEncoding.isMbcAscii(byArray[n3])) {
            byArray2[n4] = AsciiTables.ToLowerCaseTable[byArray[n3] & 0xFF];
            return 1;
        }
        int n5 = this.length(byArray, n3, n2);
        for (int i = 0; i < n5; ++i) {
            byArray2[n4++] = byArray[n3++];
        }
        intHolder.value += n5;
        return n5;
    }

    @Override
    protected boolean isLead(int n) {
        return (n - 161 & 0xFF) > 93;
    }

    @Override
    public boolean isReverseMatchAllowed(byte[] byArray, int n, int n2) {
        int n3 = byArray[n] & 0xFF;
        return n3 <= 126 || n3 == 142 || n3 == 143;
    }

    @Override
    public int propertyNameToCType(byte[] byArray, int n, int n2) {
        Integer n3 = CTypeNameHash.get(byArray, n, n2);
        if (n3 == null) {
            return super.propertyNameToCType(byArray, n, n2);
        }
        return n3;
    }

    @Override
    public boolean isCodeCType(int n, int n2) {
        if (n2 <= 14) {
            if (n < 128) {
                return this.isCodeCTypeInternal(n, n2);
            }
            if (BaseEUCJPEncoding.isWordGraphPrint(n2)) {
                return this.codeToMbcLength(n) > 1;
            }
        } else {
            if ((n2 -= 15) >= PropertyList.length) {
                throw new InternalException("undefined type (bug)");
            }
            return CodeRange.isInCodeRange(PropertyList[n2], n);
        }
        return false;
    }

    @Override
    public int[] ctypeCodeRange(int n, IntHolder intHolder) {
        if (n <= 14) {
            return null;
        }
        intHolder.value = 128;
        if ((n -= 15) >= PropertyList.length) {
            throw new InternalException("undefined type (bug)");
        }
        return PropertyList[n];
    }

    static {
        CTypeNameHash.put("Hiragana".getBytes(), 15);
        CTypeNameHash.put("Katakana".getBytes(), 16);
        EUCJPEncLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1};
    }
}

