/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings;

import org.jcodings.AbstractEncoding;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingException;

public abstract class MultiByteEncoding
extends AbstractEncoding {
    protected final int[] EncLen;
    protected static final int A = -1;
    protected static final int F = -2;
    protected final int[][] Trans;
    protected final int[] TransZero;

    protected MultiByteEncoding(String string, int n, int n2, int[] nArray, int[][] nArray2, short[] sArray) {
        super(string, n, n2, sArray);
        this.EncLen = nArray;
        this.Trans = nArray2;
        this.TransZero = nArray2 != null ? nArray2[0] : null;
    }

    @Override
    public int length(byte by) {
        return this.EncLen[by & 0xFF];
    }

    protected final int missing(int n) {
        return -1 - n;
    }

    protected final int missing(int n, int n2) {
        return this.missing(this.EncLen[n] - n2);
    }

    protected final int safeLengthForUptoFourGreatedThan127(byte[] byArray, int n, int n2) {
        int n3 = byArray[n] & 0xFF;
        int n4 = this.TransZero[n3];
        if (n4 < 0) {
            return n4 == -1 ? 1 : -1;
        }
        return this.lengthForTwoUptoFour(byArray, n, n2, n3, n4);
    }

    protected final int safeLengthForUptoFour(byte[] byArray, int n, int n2) {
        int n3 = byArray[n] & 0xFF;
        int n4 = this.TransZero[n3];
        if (n4 < 0) {
            return n4 == -1 ? 1 : -1;
        }
        return this.lengthForTwoUptoFour(byArray, n, n2, n3, n4);
    }

    protected final int lengthForTwoUptoFour(byte[] byArray, int n, int n2, int n3, int n4) {
        if (++n == n2) {
            return this.missing(n3, 1);
        }
        if ((n4 = this.Trans[n4][byArray[n] & 0xFF]) < 0) {
            return n4 == -1 ? 2 : -1;
        }
        return this.lengthForThreeUptoFour(byArray, n, n2, n3, n4);
    }

    private int lengthForThreeUptoFour(byte[] byArray, int n, int n2, int n3, int n4) {
        if (++n == n2) {
            return this.missing(n3, 2);
        }
        if ((n4 = this.Trans[n4][byArray[n] & 0xFF]) < 0) {
            return n4 == -1 ? 3 : -1;
        }
        if (++n == n2) {
            return this.missing(n3, 3);
        }
        return (n4 = this.Trans[n4][byArray[n] & 0xFF]) == -1 ? 4 : -1;
    }

    protected final int safeLengthForUptoThree(byte[] byArray, int n, int n2) {
        int n3 = byArray[n] & 0xFF;
        int n4 = this.TransZero[n3];
        if (n4 < 0) {
            return n4 == -1 ? 1 : -1;
        }
        return this.lengthForTwoUptoThree(byArray, n, n2, n3, n4);
    }

    private int lengthForTwoUptoThree(byte[] byArray, int n, int n2, int n3, int n4) {
        if (++n == n2) {
            return this.missing(n3, 1);
        }
        if ((n4 = this.Trans[n4][byArray[n] & 0xFF]) < 0) {
            return n4 == -1 ? 2 : -1;
        }
        return this.lengthForThree(byArray, n, n2, n3, n4);
    }

    private int lengthForThree(byte[] byArray, int n, int n2, int n3, int n4) {
        if (++n == n2) {
            return this.missing(n3, 2);
        }
        return (n4 = this.Trans[n4][byArray[n] & 0xFF]) == -1 ? 3 : -1;
    }

    protected final int safeLengthForUptoTwo(byte[] byArray, int n, int n2) {
        int n3 = byArray[n] & 0xFF;
        int n4 = this.TransZero[n3];
        if (n4 < 0) {
            return n4 == -1 ? 1 : -1;
        }
        return this.lengthForTwo(byArray, n, n2, n3, n4);
    }

    private int lengthForTwo(byte[] byArray, int n, int n2, int n3, int n4) {
        if (++n == n2) {
            return this.missing(n3, 1);
        }
        return (n4 = this.Trans[n4][byArray[n] & 0xFF]) == -1 ? 2 : -1;
    }

    protected final int mbnMbcToCode(byte[] byArray, int n, int n2) {
        int n3 = this.length(byArray, n, n2);
        int n4 = byArray[n++] & 0xFF;
        if (n3 == 1) {
            return n4;
        }
        for (int i = 1; i < n3 && n < n2; ++i) {
            int n5 = byArray[n++] & 0xFF;
            n4 <<= 8;
            n4 += n5;
        }
        return n4;
    }

    protected final int mbnMbcCaseFold(int n, byte[] byArray, IntHolder intHolder, int n2, byte[] byArray2) {
        int n3 = intHolder.value++;
        int n4 = 0;
        if (MultiByteEncoding.isAscii(byArray[n3] & 0xFF)) {
            byArray2[n4] = AsciiTables.ToLowerCaseTable[byArray[n3] & 0xFF];
            return 1;
        }
        int n5 = this.length(byArray, n3, n2);
        for (int i = 0; i < n5; ++i) {
            byArray2[n4++] = byArray[n3++];
        }
        intHolder.value += n5;
        return n5;
    }

    protected final int mb2CodeToMbcLength(int n) {
        return (n & 0xFF00) != 0 ? 2 : 1;
    }

    protected final int mb4CodeToMbcLength(int n) {
        if ((n & 0xFF000000) != 0) {
            return 4;
        }
        if ((n & 0xFF0000) != 0) {
            return 3;
        }
        if ((n & 0xFF00) != 0) {
            return 2;
        }
        return 1;
    }

    protected final int mb2CodeToMbc(int n, byte[] byArray, int n2) {
        int n3 = n2;
        if ((n & 0xFF00) != 0) {
            byArray[n3++] = (byte)(n >>> 8 & 0xFF);
        }
        byArray[n3++] = (byte)(n & 0xFF);
        if (this.length(byArray, n2, n3) != n3 - n2) {
            throw new EncodingException("invalid code point value");
        }
        return n3 - n2;
    }

    protected final int mb4CodeToMbc(int n, byte[] byArray, int n2) {
        int n3 = n2;
        if ((n & 0xFF000000) != 0) {
            byArray[n3++] = (byte)(n >>> 24 & 0xFF);
        }
        if ((n & 0xFF0000) != 0 || n3 != n2) {
            byArray[n3++] = (byte)(n >>> 16 & 0xFF);
        }
        if ((n & 0xFF00) != 0 || n3 != n2) {
            byArray[n3++] = (byte)(n >>> 8 & 0xFF);
        }
        byArray[n3++] = (byte)(n & 0xFF);
        if (this.length(byArray, n2, n3) != n3 - n2) {
            throw new EncodingException("invalid code point value");
        }
        return n3 - n2;
    }

    protected final boolean mb2IsCodeCType(int n, int n2) {
        if (n < 128) {
            return this.isCodeCTypeInternal(n, n2);
        }
        if (MultiByteEncoding.isWordGraphPrint(n2)) {
            return this.codeToMbcLength(n) > 1;
        }
        return false;
    }

    protected final boolean mb4IsCodeCType(int n, int n2) {
        return this.mb2IsCodeCType(n, n2);
    }

    @Override
    public int strLength(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            n4 += this.length(byArray, n4, n2);
            ++n3;
        }
        return n3;
    }

    @Override
    public int strCodeAt(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            if (n4 == n3) {
                return this.mbcToCode(byArray, n5, n2);
            }
            n5 += this.length(byArray, n5, n2);
            ++n4;
        }
        return -1;
    }
}

