/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.actions;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.CommitToIcsDialog;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.ProjectId;
import org.jetbrains.settingsRepository.actions.ProjectChangeCollectConsumer;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\"\u0010\u000f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0011"}, d2={"collectProjectChanges", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "collectConsumer", "Lorg/jetbrains/settingsRepository/actions/ProjectChangeCollectConsumer;", "getProjectId", "", "project", "Lcom/intellij/openapi/project/Project;", "isProjectConfigFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "showDialog", "projectId", "intellij.settingsRepository"})
public final class CommitToIcsActionKt {
    private static final String getProjectId(Project project) {
        ProjectId projectId;
        Object object = ServiceManager.getService((Project)project, ProjectId.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if ((projectId = (ProjectId)object).getUid() == null && (IcsManagerKt.getIcsManager().getSettings().getDoNoAskMapProject() || ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Settings Server Project Mapping", (String)"Project is not mapped on Settings Server. Would you like to map?").project(project)).doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

            public boolean isSelectedByDefault() {
                return true;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                IcsManagerKt.getIcsManager().getSettings().setDoNoAskMapProject(isSelected);
            }
        })).show() == 0)) {
            projectId.setUid(UUID.randomUUID().toString());
        }
        return projectId.getUid();
    }

    private static final void showDialog(Project project, ProjectChangeCollectConsumer collectConsumer, String projectId) {
        if (!collectConsumer.hasResult()) {
            return;
        }
        String effectiveProjectId = projectId;
        if (effectiveProjectId == null && (effectiveProjectId = CommitToIcsActionKt.getProjectId(project)) == null) {
            return;
        }
        new CommitToIcsDialog(project, effectiveProjectId, collectConsumer.getResult()).show();
    }

    private static final void collectProjectChanges(Collection<? extends Change> changes, ProjectChangeCollectConsumer collectConsumer) {
        for (Change change : changes) {
            collectConsumer.consume(change);
        }
    }

    private static final boolean isProjectConfigFile(VirtualFile file, Project project) {
        if (file == null) {
            return false;
        }
        String string = project.getBasePath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return FileUtil.isAncestor((String)string, (String)file.getPath(), (boolean)true);
    }

    public static final /* synthetic */ void access$collectProjectChanges(@NotNull Collection changes, @NotNull ProjectChangeCollectConsumer collectConsumer) {
        CommitToIcsActionKt.collectProjectChanges(changes, collectConsumer);
    }

    public static final /* synthetic */ void access$showDialog(@NotNull Project project, @NotNull ProjectChangeCollectConsumer collectConsumer, @Nullable String projectId) {
        CommitToIcsActionKt.showDialog(project, collectConsumer, projectId);
    }

    public static final /* synthetic */ boolean access$isProjectConfigFile(@Nullable VirtualFile file, @NotNull Project project) {
        return CommitToIcsActionKt.isProjectConfigFile(file, project);
    }

    @Nullable
    public static final /* synthetic */ String access$getProjectId(@NotNull Project project) {
        return CommitToIcsActionKt.getProjectId(project);
    }
}

