/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutBuilderImpl;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.util.PathUtilRt;
import com.intellij.util.text.StringKt;
import java.awt.Container;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a8\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\b"}, d2={"showAuthenticationForm", "Lcom/intellij/credentialStore/Credentials;", "credentials", "uri", "", "host", "path", "sshKeyFile", "intellij.settingsRepository"})
public final class AuthFormKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Credentials showAuthenticationForm(@Nullable Credentials credentials, @NotNull String uri, @Nullable String host, @Nullable String path, @Nullable String sshKeyFile) {
        void username;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            if (application.isUnitTestMode()) {
                throw (Throwable)((Object)new AssertionError((Object)"showAuthenticationForm called from tests"));
            }
        }
        boolean isGitHub = Intrinsics.areEqual((Object)host, (Object)"github.com");
        boolean isBitbucket = Intrinsics.areEqual((Object)host, (Object)"bitbucket.org");
        String note = sshKeyFile == null ? IcsBundleKt.icsMessage(isGitHub ? "login.github.note" : (isBitbucket ? "login.bitbucket.note" : "login.other.git.provider.note"), new Object[0]) : null;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        Credentials credentials2 = credentials;
        Object object = objectRef.element = credentials2 != null ? credentials2.getUserName() : null;
        if ((String)username.element == null && isGitHub && path != null && sshKeyFile == null) {
            int firstSlashIndex = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)1, (boolean)false, (int)4, null);
            String string = path;
            int n = 1;
            int n2 = firstSlashIndex == -1 ? path.length() : firstSlashIndex;
            void var13_14 = username;
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = string2;
            var13_14.element = string3;
        }
        String message = sshKeyFile == null ? IcsBundleKt.icsMessage("log.in.to", StringKt.trimMiddle$default((String)uri, (int)50, (boolean)false, (int)2, null)) : "Enter your password for the SSH key \"" + PathUtilRt.getFileName((String)sshKeyFile) + "\":";
        return (Credentials)ActionsKt.invokeAndWaitIfNeed$default(null, (Function0)((Function0)new Function0<Credentials>((Ref.ObjectRef)username, credentials, message, sshKeyFile, isGitHub, note){
            final /* synthetic */ Ref.ObjectRef $username;
            final /* synthetic */ Credentials $credentials;
            final /* synthetic */ String $message;
            final /* synthetic */ String $sshKeyFile;
            final /* synthetic */ boolean $isGitHub;
            final /* synthetic */ String $note;

            @Nullable
            public final Credentials invoke() {
                Credentials credentials;
                Row $receiver;
                LayoutBuilder this_$iv$iv;
                Row row$iv$iv;
                boolean separated$iv$iv;
                JLabel label$iv$iv;
                LayoutBuilder this_$iv;
                String label$iv;
                Object object;
                LayoutBuilder builder$iv;
                JTextField userField = new JTextField((String)this.$username.element);
                Credentials credentials2 = this.$credentials;
                JPasswordField passwordField = new JPasswordField(credentials2 != null && (credentials2 = credentials2.getPassword()) != null ? credentials2.toString() : null);
                LCFlags[] constraints$iv = new LCFlags[]{};
                String title$iv = null;
                LayoutBuilder $receiver2 = builder$iv = LayoutImplKt.createLayoutBuilder();
                $receiver2.noteRow(this.$message);
                if (this.$sshKeyFile == null && !this.$isGitHub) {
                    object = $receiver2;
                    label$iv = "Username:";
                    LayoutBuilder layoutBuilder = this_$iv;
                    label$iv$iv = ComponentsKt.Label$default((String)label$iv, null, null, (boolean)false, (int)14, null);
                    separated$iv$iv = false;
                    $receiver = row$iv$iv = LayoutBuilderImpl.DefaultImpls.newRow$default((LayoutBuilderImpl)this_$iv$iv.get$(), (JLabel)label$iv$iv, (ButtonGroup)this_$iv$iv.getButtonGroup(), (boolean)separated$iv$iv, (boolean)false, (int)8, null);
                    Row.invoke$default((Row)$receiver, (JComponent)userField, (CCFlags[])new CCFlags[0], (int)0, null, (int)6, null);
                }
                this_$iv = $receiver2;
                label$iv = this.$sshKeyFile == null && this.$isGitHub ? "Token:" : "Password:";
                this_$iv$iv = this_$iv;
                label$iv$iv = ComponentsKt.Label$default((String)label$iv, null, null, (boolean)false, (int)14, null);
                separated$iv$iv = false;
                $receiver = row$iv$iv = LayoutBuilderImpl.DefaultImpls.newRow$default((LayoutBuilderImpl)this_$iv$iv.get$(), (JLabel)label$iv$iv, (ButtonGroup)this_$iv$iv.getButtonGroup(), (boolean)separated$iv$iv, (boolean)false, (int)8, null);
                Row.invoke$default((Row)$receiver, (JComponent)passwordField, (CCFlags[])new CCFlags[0], (int)0, null, (int)6, null);
                String string = this.$note;
                if (string != null) {
                    Object it = object = string;
                    $receiver2.noteRow((String)it);
                }
                JPanel panel$iv = ComponentsKt.Panel((String)title$iv, null);
                builder$iv.get$().build((Container)panel$iv, constraints$iv);
                JPanel centerPanel = panel$iv;
                DialogWrapper authenticationForm = ComponentsKt.dialog$default((String)"Settings Repository", (JComponent)centerPanel, (boolean)false, (JComponent)(userField.getParent() == null ? (JTextField)passwordField : userField), (boolean)false, null, null, null, null, null, (int)996, null);
                passwordField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(authenticationForm){
                    final /* synthetic */ DialogWrapper $authenticationForm;

                    protected void textChanged(@NotNull DocumentEvent e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        Document document = e.getDocument();
                        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"e.document");
                        this.$authenticationForm.setOKActionEnabled(document.getLength() != 0);
                    }
                    {
                        this.$authenticationForm = $captured_local_variable$0;
                    }
                });
                authenticationForm.setOKActionEnabled(false);
                if (authenticationForm.showAndGet()) {
                    String string2 = this.$sshKeyFile;
                    if (string2 == null) {
                        string2 = StringKt.nullize((String)userField.getText(), (boolean)true);
                    }
                    this.$username.element = string2;
                    char[] cArray = passwordField.getPassword();
                    Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"passwordField.password");
                    char[] passwordChars = StringKt.nullize((char[])cArray);
                    credentials = new Credentials((String)this.$username.element, (OneTimeString)(passwordChars == null ? ((String)this.$username.element == null ? null : new OneTimeString("x-oauth-basic")) : new OneTimeString(passwordChars, 0, 0, false, 14, null)));
                } else {
                    credentials = null;
                }
                return credentials;
            }
            {
                this.$username = objectRef;
                this.$credentials = credentials;
                this.$message = string;
                this.$sshKeyFile = string2;
                this.$isGitHub = bl;
                this.$note = string3;
                super(0);
            }
        }), (int)1, null);
    }
}

