/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.script.TooLongStatementException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.text.CharArrayCharSequence;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class SqlReaderImpl {
    private static final Logger LOG = Logger.getInstance(SqlReaderImpl.class);
    private static final int READER_BUF_SIZE = 102400;
    private static final int PARSER_CHUNK = 1024000;

    @NotNull
    public static JBIterable<SyntaxTraverser<PsiElement>> parseSql(final @NotNull Project project, final @NotNull SqlLanguageDialect language, final @NotNull VirtualFile virtualFile, final @NotNull Disposable disposable) {
        Document document;
        if (project == null) {
            SqlReaderImpl.$$$reportNull$$$0(0);
        }
        if (language == null) {
            SqlReaderImpl.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            SqlReaderImpl.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            SqlReaderImpl.$$$reportNull$$$0(3);
        }
        Document document2 = document = SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile) ? null : FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document != null) {
            SqlFile file = SqlPsiElementFactory.createROFileFromText(document.getCharsSequence(), language, project, null);
            JBIterable jBIterable = JBIterable.of(SqlReaderImpl.getStatementTraverser(SyntaxTraverser.psiTraverser((PsiElement)file)));
            if (jBIterable == null) {
                SqlReaderImpl.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        JBIterable<SyntaxTraverser<PsiElement>> jBIterable = new JBIterable<SyntaxTraverser<PsiElement>>(){

            @NotNull
            public Iterator<SyntaxTraverser<PsiElement>> iterator() {
                Iterator iterator;
                try {
                    long length = virtualFile.getLength();
                    final InputStreamReader reader = new InputStreamReader(virtualFile.getInputStream(), virtualFile.getCharset());
                    Disposable inputDisposable = new Disposable(){

                        public void dispose() {
                            try {
                                reader.close();
                            }
                            catch (Exception e) {
                                LOG.warn((Throwable)e);
                            }
                        }
                    };
                    Disposer.register((Disposable)disposable, (Disposable)inputDisposable);
                    iterator = SqlReaderImpl.processSyntaxImpl(project, language, reader, length, inputDisposable);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl$1", "iterator"));
            }
        };
        if (jBIterable == null) {
            SqlReaderImpl.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    /*
     * WARNING - void declaration
     */
    private static Iterator<SyntaxTraverser<PsiElement>> processSyntaxImpl(@NotNull Project project, @NotNull SqlLanguageDialect dialect, final @NotNull Reader reader, final long fileSize, @NotNull Disposable disposable) {
        void inputDisposable;
        if (project == null) {
            SqlReaderImpl.$$$reportNull$$$0(6);
        }
        if (dialect == null) {
            SqlReaderImpl.$$$reportNull$$$0(7);
        }
        if (reader == null) {
            SqlReaderImpl.$$$reportNull$$$0(8);
        }
        if (disposable == null) {
            SqlReaderImpl.$$$reportNull$$$0(9);
        }
        return new Iterator<SyntaxTraverser<PsiElement>>((Disposable)inputDisposable, dialect, project){
            long myMaxMemory = Runtime.getRuntime().maxMemory();
            int myChunkSize = 1024000;
            StringBuilder text = new StringBuilder(this.myChunkSize);
            char[] buf = new char[Math.min(102400, this.myChunkSize)];
            CharArrayCharSequence seq = new CharArrayCharSequence(this.buf);
            Exception error;
            boolean bufferPrepared;
            int partIndex;
            long partOffset;
            final /* synthetic */ Disposable val$inputDisposable;
            final /* synthetic */ SqlLanguageDialect val$dialect;
            final /* synthetic */ Project val$project;
            {
                this.val$inputDisposable = disposable;
                this.val$dialect = sqlLanguageDialect;
                this.val$project = project;
            }

            @Override
            public boolean hasNext() {
                return this.bufferPrepared || this.prepareBuffer();
            }

            @Override
            public SyntaxTraverser<PsiElement> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                while (true) {
                    try {
                        SyntaxTraverser<PsiElement> s = this.buildTraverser();
                        this.bufferPrepared = false;
                        return s;
                    }
                    catch (TooLongStatementException e) {
                        if ((long)this.myChunkSize > this.myMaxMemory / 16L) {
                            throw e;
                        }
                        LOG.info(e.getMessage());
                        LOG.info("increasing parser buffer to: " + StringUtil.formatFileSize((long)this.myChunkSize) + " (file size " + StringUtil.formatFileSize((long)fileSize) + ")");
                        this.myChunkSize *= 2;
                        this.prepareBuffer();
                        continue;
                    }
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            boolean prepareBuffer() {
                int read2;
                do {
                    try {
                        read2 = reader.read(this.buf);
                    }
                    catch (IOException e) {
                        this.error = e;
                        return false;
                    }
                    if ((read2 > 0 || this.text.length() <= 0) && (read2 <= 0 || this.text.append(this.seq.subSequence(0, read2)).length() < this.myChunkSize)) continue;
                    this.bufferPrepared = true;
                    return true;
                } while (read2 > 0);
                Disposer.dispose((Disposable)this.val$inputDisposable);
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private SyntaxTraverser<PsiElement> buildTraverser() {
                int lastOffset;
                boolean isLast = this.text.length() < this.myChunkSize;
                String str = this.text.toString();
                SyntaxTraverser<PsiElement> traverser2 = this.parseImpl(str);
                int firstOffset = 0;
                if (!isLast) {
                    PsiElement lastToSkip = (PsiElement)traverser2.getRawDeepestLast();
                    if (lastToSkip != null && traverser2.api.typeOf((Object)lastToSkip) == SqlCompositeElementTypes.SQL_INSERT_STATEMENT && traverser2.api.rangeOf((Object)lastToSkip).getStartOffset() == 0) {
                        SyntaxTraverser s = (SyntaxTraverser)traverser2.reset();
                        PsiElement valuesExpr = (PsiElement)s.filterTypes(Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_VALUES_EXPRESSION)).traverse().first();
                        PsiElement valuesNode = (PsiElement)s.filterTypes(Conditions.equalTo((Object)SqlCommonKeywords.SQL_VALUES)).traverse().first();
                        Condition isParExpr = Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION));
                        JBIterable parExprs = ((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.withRoot((Object)valuesExpr)).expand(Conditions.equalTo((Object)valuesExpr))).filter(isParExpr)).traverse();
                        PsiElement last = null;
                        PsiElement prev = null;
                        for (PsiElement expr : parExprs) {
                            prev = last;
                            last = expr;
                        }
                        if (valuesNode == null || last == null || prev == null) throw this.tooLongStatement(traverser2, lastToSkip);
                        lastToSkip = last;
                        firstOffset = traverser2.api.rangeOf((Object)valuesNode).getEndOffset() + 1;
                        traverser2 = this.parseImpl(str.substring(0, traverser2.api.rangeOf((Object)prev).getEndOffset()));
                    } else {
                        if (lastToSkip == null || traverser2.api.rangeOf((Object)lastToSkip).getStartOffset() == 0) {
                            throw this.tooLongStatement(traverser2, lastToSkip);
                        }
                        PsiElement forceIgnore = lastToSkip;
                        traverser2 = (SyntaxTraverser<PsiElement>)traverser2.forceIgnore(input -> input == forceIgnore);
                    }
                    lastOffset = traverser2.api.rangeOf((Object)lastToSkip).getStartOffset();
                    this.text = this.text.delete(firstOffset, lastOffset);
                } else {
                    lastOffset = this.text.length();
                    this.text.setLength(0);
                }
                traverser2.putUserData(ScriptModelUtil.PART_INDEX, (Object)this.partIndex);
                traverser2.putUserData(ScriptModelUtil.PART_OFFSET, (Object)this.partOffset);
                ++this.partIndex;
                this.partOffset += (long)lastOffset;
                return traverser2;
            }

            @NotNull
            private SyntaxTraverser<PsiElement> parseImpl(String s) {
                SqlFile file = SqlPsiElementFactory.createROFileFromText(s, this.val$dialect, this.val$project, null);
                SyntaxTraverser syntaxTraverser = SqlReaderImpl.getStatementTraverser(SyntaxTraverser.psiTraverser((PsiElement)file));
                if (syntaxTraverser == null) {
                    2.$$$reportNull$$$0(0);
                }
                return syntaxTraverser;
            }

            @NotNull
            private TooLongStatementException tooLongStatement(SyntaxTraverser<PsiElement> traverser2, PsiElement lastToSkip) {
                TooLongStatementException tooLongStatementException = new TooLongStatementException((lastToSkip == null ? "<unknown>" : traverser2.api.typeOf((Object)lastToSkip)) + " statement is longer than " + StringUtil.formatFileSize((long)this.myChunkSize));
                if (tooLongStatementException == null) {
                    2.$$$reportNull$$$0(1);
                }
                return tooLongStatementException;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/script/SqlReaderImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parseImpl";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "tooLongStatement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public static <E> SyntaxTraverser<E> getStatementTraverser(@NotNull SyntaxTraverser<E> s) {
        if (s == null) {
            SqlReaderImpl.$$$reportNull$$$0(10);
        }
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)((SyntaxTraverser)s.forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)).expand(Conditions.alwaysFalse())).filterTypes(SqlReaderImpl.sqlTypesCondition()).withTraversal(TreeTraversal.LEAVES_DFS);
        if (syntaxTraverser == null) {
            SqlReaderImpl.$$$reportNull$$$0(11);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static Condition<IElementType> sqlTypesCondition() {
        Condition condition = t -> {
            if (t instanceof IsExternal) {
                return false;
            }
            return t instanceof SqlCompositeElementType || t instanceof IStubElementType || t instanceof SqlFileElementType;
        };
        if (condition == null) {
            SqlReaderImpl.$$$reportNull$$$0(12);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/script/SqlReaderImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputDisposable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/script/SqlReaderImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSql";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementTraverser";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTypesCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseSql";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processSyntaxImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStatementTraverser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

