/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlCteInplaceIntroducer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSubqueryUtils {
    public static SqlExpression smartFindQuery(Editor editor, PsiFile file) {
        return SqlSubqueryUtils.findCteAbleParent(file.findElementAt(editor.getCaretModel().getOffset()), false);
    }

    @Nullable
    public static SqlExpression findCteAbleParent(@Nullable PsiElement el, boolean strict) {
        if (strict && el != null) {
            el = el.getParent();
        }
        while (el != null) {
            if (el instanceof SqlResultSetExpression) {
                return (SqlExpression)el;
            }
            el = el.getParent();
        }
        return null;
    }

    public static SqlWithClause extractWithClause(SqlExpression query) {
        SqlWithQueryExpression withQuery = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)query, SqlWithQueryExpression.class);
        return withQuery != null ? withQuery.getWithClause() : null;
    }

    public static SqlExpression removeCteDefinition(SqlNamedQueryDefinitionImpl q) {
        SqlWithClause with = (SqlWithClause)ObjectUtils.tryCast((Object)q.getParent(), SqlWithClause.class);
        assert (with != null);
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)with.getParent(), SqlWithQueryExpression.class);
        assert (withEx != null);
        SqlNamedQueryDefinitionImpl sibling = (SqlNamedQueryDefinitionImpl)PsiTreeUtil.getNextSiblingOfType((PsiElement)q, SqlNamedQueryDefinitionImpl.class);
        if (sibling != null) {
            with.deleteChildRange((PsiElement)q, sibling.getPrevSibling());
            return withEx;
        }
        sibling = (SqlNamedQueryDefinitionImpl)PsiTreeUtil.getPrevSiblingOfType((PsiElement)q, SqlNamedQueryDefinitionImpl.class);
        if (sibling != null) {
            with.deleteChildRange(sibling.getNextSibling(), (PsiElement)q);
            return withEx;
        }
        SqlExpression query = withEx.getExpression();
        if (query != null) {
            query = (SqlExpression)withEx.getParent().addAfter((PsiElement)query, (PsiElement)withEx);
            withEx.delete();
            return query;
        }
        return withEx;
    }

    public static SqlExpression findEnclosingQueryWithContext(PsiElement el) {
        SqlExpression ex;
        if (el == null) {
            return null;
        }
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)el.getParent(), SqlWithQueryExpression.class);
        if (withEx != null) {
            if (withEx.getExpression() != el) {
                return null;
            }
            el = el.getParent();
        }
        if ((ex = SqlSubqueryUtils.findCteAbleParent(el, true)) == null || ObjectUtils.tryCast((Object)ex, SqlWithQueryExpression.class) != null) {
            return null;
        }
        withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)ex.getParent(), SqlWithQueryExpression.class);
        return withEx != null ? withEx : ex;
    }

    public static SqlParenthesizedExpression parenthesized(@NotNull SqlExpression q) {
        if (q == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(0);
        }
        if (q instanceof SqlParenthesizedExpression) {
            return (SqlParenthesizedExpression)q;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)q);
        DdlBuilder ddl = new DdlBuilder().applyCodeStyle(q.getProject()).withDialect(dialect.getDatabaseDialect());
        ddl.applyCodeStyle(q.getProject());
        ddl.keyword("select").space().symbol("*").space().keyword("from").space();
        int check = ddl.length();
        ddl.symbol("(").plain(q.getText()).symbol(")");
        SqlStatement el = SqlPsiElementFactory.createStatementFromText(ddl.getStatement(), dialect, q.getProject(), (PsiElement)q);
        SqlParenthesizedExpression res = (SqlParenthesizedExpression)PsiTreeUtil.findChildOfType((PsiElement)el, SqlParenthesizedExpression.class);
        assert (res != null && res.getTextRange().getStartOffset() == check);
        return res;
    }

    public static SqlAsExpression aliased(@NotNull SqlExpression q, @NotNull String alias) {
        if (q == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(1);
        }
        if (alias == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(2);
        }
        boolean appendParentheses = !(q instanceof SqlParenthesizedExpression);
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)q);
        DdlBuilder ddl = new DdlBuilder().applyCodeStyle(q.getProject()).withDialect(dialect.getDatabaseDialect());
        ddl.keyword("select").space().symbol("*").space().keyword("from").space();
        int check = ddl.length();
        if (appendParentheses) {
            ddl.symbol("(");
        }
        ddl.plain(q.getText());
        if (appendParentheses) {
            ddl.symbol(")");
        }
        ddl.space().alias(alias);
        SqlStatement el = SqlPsiElementFactory.createStatementFromText(ddl.getStatement(), dialect, q.getProject(), (PsiElement)q);
        SqlAsExpression res = (SqlAsExpression)PsiTreeUtil.findChildOfType((PsiElement)el, SqlAsExpression.class);
        assert (res != null && res.getTextRange().getStartOffset() == check);
        return res;
    }

    public static boolean isSubquery(SqlExpression query, SqlExpression el) {
        return query != null && PsiTreeUtil.isAncestor((PsiElement)query, (PsiElement)el, (boolean)true);
    }

    public static void extractCte(Project project, Editor editor, PsiFile file, SqlExpression subquery, SqlExpression query) {
        PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)"Extract CTE", (String)"Extract CTE", () -> new SqlCteInplaceIntroducer(project, editor, subquery, query, file.getFileType()).startInplaceIntroduceTemplate(), (PsiFile[])new PsiFile[]{file}));
    }

    public static SqlExpression expanded(SqlExpression query) {
        if (query.getParent() instanceof SqlParenthesizedExpression) {
            return (SqlExpression)query.getParent();
        }
        return query;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "q";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/refactoring/SqlSubqueryUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parenthesized";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "aliased";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

