/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlNamedElementStub<T extends SqlElement>
extends StubBase<T> {
    protected final StringRef myName;
    private Object myNameReference;

    public SqlNamedElementStub(StubElement parent, @NotNull IStubElementType elementType, @Nullable StringRef name) {
        if (elementType == null) {
            SqlNamedElementStub.$$$reportNull$$$0(0);
        }
        super(parent, elementType);
        this.myName = name;
    }

    @Nullable
    public String getName() {
        return this.myName == null ? null : this.myName.getString();
    }

    @Nullable
    public SqlReferenceExpression getNameReference(@NotNull SqlReferenceElementType type) {
        Object cur;
        if (type == null) {
            SqlNamedElementStub.$$$reportNull$$$0(1);
        }
        if (!((cur = this.myNameReference) instanceof SqlReferenceExpression)) {
            this.myNameReference = cur = this.createReference(type, this.getName());
        }
        return (SqlReferenceExpression)cur;
    }

    public List<SqlReferenceExpression> getNameReferences(@NotNull SqlReferenceElementType type, @NotNull String separator) {
        List<SqlReferenceExpression> cur;
        if (type == null) {
            SqlNamedElementStub.$$$reportNull$$$0(2);
        }
        if (separator == null) {
            SqlNamedElementStub.$$$reportNull$$$0(3);
        }
        if (!((cur = this.myNameReference) instanceof List)) {
            this.myNameReference = cur = this.createReferences(type, this.getName(), separator);
        }
        return cur;
    }

    private List<SqlReferenceExpression> createReferences(SqlReferenceElementType type, String text, String separator) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return Collections.emptyList();
        }
        List list = ContainerUtil.newSmartList();
        for (String s : StringUtil.split((String)text, (String)separator)) {
            ContainerUtil.addIfNotNull((Collection)list, (Object)this.createReference(type, s));
        }
        return list;
    }

    @Nullable
    protected SqlReferenceExpression createReference(@NotNull SqlReferenceElementType type, @Nullable String text) {
        if (type == null) {
            SqlNamedElementStub.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return null;
        }
        SqlElement psi = (SqlElement)this.getPsi();
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)psi);
        return SqlPsiElementFactory.createReferenceFromText(text, language, type, (PsiElement)psi);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/psi/stubs/SqlNamedElementStub";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameReferences";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

