/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.patterns.SqlFunctionCallPattern;
import com.intellij.sql.psi.patterns.SqlPatterns;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlElementPattern<T extends SqlElement, Self extends SqlElementPattern<T, Self>>
extends PsiElementPattern<T, Self> {
    protected SqlElementPattern(Class<T> aClass) {
        super(aClass);
    }

    public SqlElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            SqlElementPattern.$$$reportNull$$$0(0);
        }
        super(condition);
    }

    public Self forDialect(final ElementPattern<? extends String> dialects) {
        return (Self)((Object)((SqlElementPattern)this.with(new PatternCondition<T>("forDialect"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(t);
                return dialects.accepts((Object)dialect.getID(), context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/patterns/SqlElementPattern$1", "accepts"));
            }
        })));
    }

    public Self forDialects(String ... dialects) {
        return this.forDialect((ElementPattern<String>)StandardPatterns.string().oneOf(dialects));
    }

    public Self binaryExpressionArgument(final int index2, final ElementPattern<? extends SqlBinaryExpression> binExprPattern) {
        return (Self)((Object)((SqlElementPattern)this.with(new PatternCondition<T>("binaryExpressionArgument"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                SqlBinaryExpression expr;
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((expr = (SqlBinaryExpression)ObjectUtils.tryCast((Object)SqlElementPattern.this.getParent(t), SqlBinaryExpression.class)) == null) {
                    return false;
                }
                if (index2 == 0 && t != expr.getLOperand()) {
                    return false;
                }
                if (index2 == 1 && t != expr.getROperand()) {
                    return false;
                }
                return binExprPattern.accepts((Object)expr, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/patterns/SqlElementPattern$2", "accepts"));
            }
        })));
    }

    public Self functionArgument(int index2, String name, int nargs) {
        return this.functionArgument(index2, (ElementPattern<? extends SqlFunctionCallExpression>)((SqlFunctionCallPattern)((Object)SqlPatterns.sqlFunctionCall().name(name))).params((ElementPattern<? extends List<? extends SqlExpression>>)SqlPatterns.sqlExpressions().count(nargs)));
    }

    public Self functionArgument(int index2, ElementPattern<? extends SqlFunctionCallExpression> pattern) {
        return this.functionArgument(index2, index2, 1, pattern);
    }

    public Self functionArgument(final int from, final int to_, final int every, final ElementPattern<? extends SqlFunctionCallExpression> pattern) {
        return (Self)((Object)((SqlElementPattern)this.with(new PatternCondition<T>("functionArgument"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                int to;
                SqlExpressionList args2;
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((args2 = (SqlExpressionList)ObjectUtils.tryCast((Object)SqlElementPattern.this.getParent(t), SqlExpressionList.class)) == null) {
                    return false;
                }
                SqlFunctionCallExpression call = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)SqlElementPattern.this.getParent((PsiElement)args2), SqlFunctionCallExpression.class);
                if (call == null) {
                    return false;
                }
                List<SqlExpression> parameters = SqlFunctionCallPattern.getExpressions(args2, context);
                int n = to = to_ < 0 ? Math.max(parameters.size() + to_, 0) : Math.min(to_, parameters.size() - 1);
                if (from > to || every <= 0) {
                    return false;
                }
                int start = t.getTextRange().getStartOffset();
                boolean found = false;
                for (int i2 = from; i2 <= to; i2 += every) {
                    SqlExpression p = parameters.get(i2);
                    if (p == t) {
                        found = true;
                        break;
                    }
                    if (p.getTextRange().getStartOffset() > start) break;
                }
                if (!found) {
                    return false;
                }
                return pattern.accepts((Object)call, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/patterns/SqlElementPattern$3", "accepts"));
            }
        })));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/sql/psi/patterns/SqlElementPattern", "<init>"));
    }

    public static class Capture<T extends SqlElement>
    extends SqlElementPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                Capture.$$$reportNull$$$0(0);
            }
            super(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/sql/psi/patterns/SqlElementPattern$Capture", "<init>"));
        }
    }
}

