/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.parser;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.fragments.SqlCodeFragmentImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.parser.SqlElementFactory;
import com.intellij.sql.psi.impl.parser.SqlParserDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlParserDefinitionBase
extends SqlParserDefinition {
    private final IFileElementType myFileElementType;
    private final SqlElementFactory myElementFactory;

    protected SqlParserDefinitionBase(@NotNull IFileElementType fileElementType, @NotNull SqlElementFactory factory) {
        if (fileElementType == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(1);
        }
        this.myFileElementType = fileElementType;
        this.myElementFactory = factory;
    }

    public SqlParserDefinitionBase() {
        this(SqlCompositeElementTypes.SQL_FILE, new SqlElementFactory(){

            @Override
            public PsiElement createCompositeElement(ASTNode node) {
                return SqlParserDefinitionBase.createCompositeElementImpl(node);
            }
        });
    }

    @NotNull
    public final SqlElementFactory getElementFactory() {
        SqlElementFactory sqlElementFactory = this.myElementFactory;
        if (sqlElementFactory == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(2);
        }
        return sqlElementFactory;
    }

    @NotNull
    public Lexer createLexer(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    public final IFileElementType getFileNodeType() {
        return this.myFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = SqlTokens.WS_TOKENS;
        if (tokenSet == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = SqlTokens.COMMENT_TOKENS;
        if (tokenSet == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(4);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = SqlTokens.STRING_TOKENS;
        if (tokenSet == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(5);
        }
        return tokenSet;
    }

    @NotNull
    private static PsiElement createCompositeElementImpl(ASTNode node) {
        ASTNode fileElement = node;
        while (fileElement.getTreeParent() != null) {
            fileElement = fileElement.getTreeParent();
        }
        Object object = fileElement = fileElement instanceof TreeElement ? TreeUtil.getFileElement((TreeElement)((TreeElement)node)) : fileElement;
        if (!(fileElement instanceof FileASTNode)) {
            ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
            if (aSTWrapperPsiElement == null) {
                SqlParserDefinitionBase.$$$reportNull$$$0(6);
            }
            return aSTWrapperPsiElement;
        }
        Language fileLanguage = SqlParserDefinitionBase.getLanguage(fileElement);
        Object dialect = fileLanguage instanceof SqlLanguageDialect ? fileLanguage : SqlDialectMappings.getDefaultSqlDialect();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(dialect);
        if (parserDefinition == null) {
            SqlDialectImplUtil.LOG.error("required parser definition not found for: " + dialect.getDisplayName() + ", nodeType: " + node.getElementType() + ", fileType: " + fileElement.getElementType());
            ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
            if (aSTWrapperPsiElement == null) {
                SqlParserDefinitionBase.$$$reportNull$$$0(7);
            }
            return aSTWrapperPsiElement;
        }
        PsiElement psiElement = parserDefinition.createElement(node);
        if (psiElement == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    @NotNull
    private static Language getLanguage(@NotNull ASTNode e) {
        PsiElement psi;
        if (e == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(9);
        }
        if ((psi = e.getPsi()) instanceof DummyHolder) {
            Language language = psi.getLanguage();
            if (language == null) {
                SqlParserDefinitionBase.$$$reportNull$$$0(10);
            }
            return language;
        }
        FileViewProvider provider = psi.getContainingFile().getViewProvider();
        if (provider instanceof TemplateLanguageFileViewProvider) {
            Language language = ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage();
            if (language == null) {
                SqlParserDefinitionBase.$$$reportNull$$$0(11);
            }
            return language;
        }
        Language language = e.getElementType().getLanguage();
        if (language == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(12);
        }
        return language;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance((Project)viewProvider.getManager().getProject()).getInjectionHost(viewProvider);
        IElementType type = (IElementType)InjectedLanguageUtil.INJECTED_FRAGMENT_TYPE.get((UserDataHolder)injectionHost);
        if (type != null) {
            SqlCodeFragmentImpl fragment = new SqlCodeFragmentImpl(viewProvider, (SqlLanguageDialect)this.getFileNodeType().getLanguage(), type, null);
            fragment.setContext((PsiElement)injectionHost);
            return fragment;
        }
        return new SqlFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public final PsiElement createElement(ASTNode node) {
        PsiElement psiElement = this.myElementFactory.createCompositeElement(node);
        if (psiElement == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    @Override
    public final <T extends PsiElement> T createElement(StubElement<T> stub) {
        return this.myElementFactory.createCompositeElement(stub);
    }

    @Nullable
    public LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text) {
        return null;
    }

    @Nullable
    public CompositeElement createComposite(IElementType type) {
        return this.myElementFactory.createElementNode(type);
    }

    @Nullable
    public LeafElement createLeaf(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(14);
        }
        if (text == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(15);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeElementImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLeaf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

