/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.lexer;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.TokenPattern;
import com.intellij.database.util.TokenPatternCache;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.sql.psi.impl.lexer.PreprocessingLexer;
import com.intellij.util.PairFunction;
import java.util.regex.MatchResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreprocessingLexer
extends PreprocessingLexer {
    private int myMatchedStep;
    private int myNameGroup;

    public SqlPreprocessingLexer(Lexer lexer, TokenPattern pattern) {
        super(lexer, pattern);
    }

    @Override
    protected boolean skipToken(IElementType tokenType, boolean strict) {
        return SqlTokens.COMMENT_TOKENS.contains(tokenType) && strict || SqlTokens.STRING_TOKENS.contains(tokenType) || tokenType == SqlTokens.SQL_IDENT_DELIMITED || tokenType == SqlTokens.SQL_RAW_INPUT || tokenType instanceof SqlTokenType.SqlInjectionMark;
    }

    @Override
    protected void onNextMatched() {
        this.myNameGroup = 0;
        this.myMatchedStep = 0;
        MatchResult match = this.getMatch();
        for (int i2 = match.groupCount(); i2 > 0; --i2) {
            if (match.start(i2) == -1) continue;
            this.myNameGroup = i2;
            this.myMatchedStep = match.end(i2) == match.end() ? 4 : 1;
        }
    }

    @Override
    protected boolean advanceInMatched() {
        if (this.myNameGroup == 0 || this.myMatchedStep == 3 || this.myMatchedStep == 5) {
            return false;
        }
        ++this.myMatchedStep;
        return true;
    }

    @Override
    protected IElementType getMatchedTokenType() {
        if (this.myNameGroup == 0) {
            return SqlTokens.SQL_EXTERNAL_PARAM;
        }
        switch (this.myMatchedStep) {
            case 1: {
                return SqlTokens.SQL_CUSTOM_PARAM_LQUOTE;
            }
            case 2: {
                return SqlTokens.SQL_IDENT;
            }
            case 3: {
                return SqlTokens.SQL_CUSTOM_PARAM_RQUOTE;
            }
            case 4: {
                return SqlTokens.SQL_EXTERNAL_PARAM_PREFIX;
            }
            case 5: {
                return SqlTokens.SQL_IDENT;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected int getMatchedTokenStart() {
        if (this.myNameGroup == 0) {
            return super.getMatchedTokenStart();
        }
        switch (this.myMatchedStep) {
            case 1: 
            case 4: {
                return super.getMatchedTokenStart();
            }
            case 2: 
            case 5: {
                return this.getMatch().start(this.myNameGroup);
            }
            case 3: {
                return this.getMatch().end(this.myNameGroup);
            }
        }
        throw new AssertionError();
    }

    @Override
    protected int getMatchedTokenEnd() {
        if (this.myNameGroup == 0) {
            return super.getMatchedTokenEnd();
        }
        switch (this.myMatchedStep) {
            case 1: 
            case 4: {
                return this.getMatch().start(this.myNameGroup);
            }
            case 2: 
            case 5: {
                return this.getMatch().end(this.myNameGroup);
            }
            case 3: {
                return super.getMatchedTokenEnd();
            }
        }
        throw new AssertionError();
    }

    @NotNull
    public static Lexer withPreprocessingIfNeeded(@Nullable Project project, @NotNull ParserDefinition parserDefinition, @Nullable Language hostLanguage) {
        if (parserDefinition == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(0);
        }
        Lexer lexer = SqlPreprocessingLexer.withPreprocessingIfNeeded(parserDefinition.createLexer(project), parserDefinition.getFileNodeType().getLanguage(), hostLanguage, DatabaseSettings.getSettings());
        if (lexer == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(1);
        }
        return lexer;
    }

    @Nullable
    public static Language getHostLanguage(@Nullable PsiElement injectionHost) {
        if (injectionHost == null) {
            return null;
        }
        Language language = injectionHost.getLanguage();
        if (language != SqlLanguage.INSTANCE) {
            return language;
        }
        return SqlImplUtil.getSqlDialectSafe(injectionHost);
    }

    @NotNull
    public static Lexer withPreprocessingIfNeeded(@NotNull Lexer lexer, @NotNull Language language, @Nullable Language hostLanguage, @Nullable DatabaseSettings settings) {
        if (lexer == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(2);
        }
        if (language == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(3);
        }
        Lexer lexer2 = SqlPreprocessingLexer.withPreprocessingIfNeeded(lexer, language, hostLanguage, settings, (PairFunction<Lexer, TokenPattern, ? extends PreprocessingLexer>)((PairFunction)(t, v) -> new SqlPreprocessingLexer((Lexer)t, (TokenPattern)v)));
        if (lexer2 == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(4);
        }
        return lexer2;
    }

    @NotNull
    public static Lexer withPreprocessingIfNeeded(@NotNull Lexer lexer, @NotNull Language language, @Nullable Language hostLanguage, @Nullable DatabaseSettings settings, @NotNull PairFunction<Lexer, TokenPattern, ? extends PreprocessingLexer> factory) {
        if (lexer == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(5);
        }
        if (language == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(6);
        }
        if (factory == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            Lexer lexer2 = lexer;
            if (lexer2 == null) {
                SqlPreprocessingLexer.$$$reportNull$$$0(8);
            }
            return lexer2;
        }
        TokenPattern pattern = hostLanguage != null ? TokenPatternCache.getPattern(settings, true, hostLanguage) : TokenPatternCache.getPattern(settings, false, language);
        Lexer lexer3 = pattern == null ? lexer : (Lexer)factory.fun((Object)lexer, (Object)pattern);
        if (lexer3 == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(9);
        }
        return lexer3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withPreprocessingIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withPreprocessingIfNeeded";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

