/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import org.jetbrains.annotations.NotNull;

public class SqlLiteralExpressionImpl
extends SqlExpressionImpl
implements SqlLiteralExpression {
    public SqlLiteralExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlLiteralExpression((SqlLiteralExpression)this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            SqlLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        if (state == null) {
            SqlLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        if (place == null) {
            SqlLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlType.Category category;
        IElementType type = this.getNode().getElementType();
        if (type == SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL) {
            category = SqlType.Category.BOOLEAN;
        } else if (type == SqlCompositeElementTypes.SQL_SPECIAL_LITERAL) {
            PsiElement child = this.getLastChild();
            IElementType childType = child == null ? null : child.getNode().getElementType();
            category = childType == SqlCommonKeywords.SQL_DEFAULT ? SqlType.Category.DEFAULT : SqlType.Category.UNKNOWN;
        } else if (type == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL) {
            IElementType childType;
            PsiElement child = this.getLastChild();
            IElementType iElementType = childType = child == null ? null : child.getNode().getElementType();
            category = childType == null ? SqlType.Category.UNKNOWN : (childType == SqlTokens.SQL_INTEGER_TOKEN ? SqlType.Category.INTEGER : (childType == SqlTokens.SQL_FLOAT_TOKEN ? SqlType.Category.REAL : SqlType.Category.UNKNOWN));
        } else if (type == SqlCompositeElementTypes.SQL_ARRAY_LITERAL) {
            SqlExpression item = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlExpression.class);
            if (item != null) {
                SqlType sqlType = SqlImplUtil.getArrayTypeOf(item.getSqlType());
                if (sqlType == null) {
                    SqlLiteralExpressionImpl.$$$reportNull$$$0(4);
                }
                return sqlType;
            }
            category = SqlType.Category.ARRAY;
        } else if (type == SqlCompositeElementTypes.ODBC_TIMESTAMP) {
            category = SqlType.Category.TIMESTAMP;
        } else if (type == SqlCompositeElementTypes.ODBC_DATE) {
            category = SqlType.Category.DATE;
        } else if (type == SqlCompositeElementTypes.ODBC_TIME) {
            category = SqlType.Category.TIME;
        } else if (type == SqlCompositeElementTypes.ODBC_ESCAPE) {
            category = SqlType.Category.STRING;
        } else if (type == SqlCompositeElementTypes.ODBC_GENERIC) {
            category = SqlType.Category.UNKNOWN;
        } else if (type == SqlCompositeElementTypes.ODBC_FUNCTION_CALL) {
            category = SqlType.Category.UNKNOWN;
        } else {
            throw new AssertionError(type);
        }
        SqlType sqlType = SqlTypeFactory.defaultType(category, SqlImplUtil.getSqlDialectSafe((PsiElement)this));
        if (sqlType == null) {
            SqlLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        return sqlType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

