/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.messages.MessageBus;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectPusher
implements FilePropertyPusher<SqlLanguageDialect> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("sql_dialect", 2, true);

    public void initExtra(@NotNull Project project, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(0);
        }
        if (bus == null) {
            SqlDialectPusher.$$$reportNull$$$0(1);
        }
        if (languageLevelUpdater == null) {
            SqlDialectPusher.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    public Key<SqlLanguageDialect> getFileDataKey() {
        Key<SqlLanguageDialect> key2 = SqlDialectMappings.SQL_DIALECT_KEY;
        if (key2 == null) {
            SqlDialectPusher.$$$reportNull$$$0(3);
        }
        return key2;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    protected static FileType getFileType(VirtualFile file) {
        return FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName());
    }

    @NotNull
    public SqlLanguageDialect getDefaultValue() {
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getDefaultSqlDialect();
        if (sqlLanguageDialect == null) {
            SqlDialectPusher.$$$reportNull$$$0(4);
        }
        return sqlLanguageDialect;
    }

    public SqlLanguageDialect getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(5);
        }
        return (SqlLanguageDialect)SqlDialectMappings.getInstance(project).getImmediateMapping(file);
    }

    public SqlLanguageDialect getImmediateValue(@NotNull Module module) {
        if (module == null) {
            SqlDialectPusher.$$$reportNull$$$0(6);
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            SqlDialectPusher.$$$reportNull$$$0(7);
        }
        return SqlFileType.INSTANCE.equals(SqlDialectPusher.getFileType(file));
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SqlDialectPusher.$$$reportNull$$$0(8);
        }
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(9);
        }
        return true;
    }

    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull SqlLanguageDialect dialect) throws IOException {
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(10);
        }
        if (fileOrDir == null) {
            SqlDialectPusher.$$$reportNull$$$0(11);
        }
        if (dialect == null) {
            SqlDialectPusher.$$$reportNull$$$0(12);
        }
        if (!fileOrDir.isDirectory() && !SqlFileType.INSTANCE.equals(SqlDialectPusher.getFileType(fileOrDir))) {
            return;
        }
        FileAttribute attribute = PERSISTENCE;
        String id = dialect.getID();
        if (!DbImplUtil.writeVFSAttribute(fileOrDir, attribute, id)) {
            return;
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, this::acceptsFile);
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(13);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevelUpdater";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/SqlDialectPusher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/SqlDialectPusher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initExtra";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

