/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.injection.SqlTypeBasedInjection;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.LanguagePanel;
import org.jetbrains.annotations.NotNull;

public class SqlTypePanel
extends AbstractInjectionPanel<SqlTypeBasedInjection> {
    private JPanel myRoot;
    private LanguagePanel myLanguagePanel;
    private EditorTextField myPatternEditor;
    private LinkLabel myHostLanguages;
    private Set<String> myHostLanguagesList;
    private ComboBox<IElementType> myFragment;
    private static final Map<IElementType, String> ourNamedFragments = ContainerUtil.immutableMapBuilder().put((Object)SqlCompositeElementTypes.SQL_EXPRESSION, (Object)"Expression").put((Object)SqlCompositeElementTypes.SQL_TYPE_ELEMENT, (Object)"Type expression").put((Object)SqlCompositeElementTypes.SQL_STATEMENT, (Object)"Statement").put((Object)SqlCompositeElementTypes.SQL_OPERATOR_SIGNATURE, (Object)"Operator signature").put((Object)SqlCompositeElementTypes.SQL_FUNCTION_SIGNATURE, (Object)"Function signature").build();
    private static final Set<IElementType> ourFiltered = ContainerUtil.immutableSet((Object[])new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE});

    protected SqlTypePanel(@NotNull SqlTypeBasedInjection injection, @NotNull Project project) {
        if (injection == null) {
            SqlTypePanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SqlTypePanel.$$$reportNull$$$0(1);
        }
        super((BaseInjection)injection, project);
        this.$$$setupUI$$$();
        this.init(injection.copy());
    }

    public JPanel getComponent() {
        return this.myRoot;
    }

    protected void apply(SqlTypeBasedInjection other) {
        String text = this.myPatternEditor.getText();
        other.setDisplayName(text);
        other.setPattern(PatternUtil.compileSafe((String)text, (Pattern)SqlTypeBasedInjection.INVALID_PATTERN));
        other.setHostLanguages(ContainerUtil.sorted(this.myHostLanguagesList));
        IElementType frag = (IElementType)ObjectUtils.tryCast((Object)this.myFragment.getSelectedItem(), IElementType.class);
        other.setFragment(frag != null && SqlTypePanel.isSqlLanguage(this.myLanguagePanel.getLanguage()) ? frag.toString() : null);
    }

    protected void resetImpl() {
        String text = ((SqlTypeBasedInjection)this.myOrigInjection).getPattern().pattern();
        if (StringUtil.isEmpty((String)text)) {
            text = ((SqlTypeBasedInjection)this.myOrigInjection).getDisplayName();
        }
        this.myPatternEditor.setText(text);
        this.myHostLanguagesList = ContainerUtil.newHashSet(((SqlTypeBasedInjection)this.myOrigInjection).getHostLanguages());
        this.updateHostLanguagesText(this.myHostLanguagesList);
        IElementType type = ((SqlTypeBasedInjection)this.myOrigInjection).getFragment() == null ? null : SqlTokenRegistry.findCompositeType((String)((SqlTypeBasedInjection)this.myOrigInjection).getFragment());
        this.myFragment.setSelectedItem((Object)type);
    }

    private void updateFragmentEnabled(String langId) {
        this.myFragment.setEnabled(SqlTypePanel.isSqlLanguage(langId));
    }

    private static boolean isSqlLanguage(String langId) {
        return Language.findLanguageByID((String)langId) instanceof SqlLanguageDialect;
    }

    private void createUIComponents() {
        this.myLanguagePanel = new LanguagePanel(this.myProject, this.myOrigInjection);
        this.myPatternEditor = new LanguageTextField((Language)RegExpLanguage.INSTANCE, this.myProject, "");
        final Pair<List<IElementType>, Map<IElementType, String>> fragments = SqlTypePanel.getFragments();
        this.myFragment = new ComboBox((ComboBoxModel)new CollectionComboBoxModel((List)fragments.first));
        this.myFragment.setRenderer((ListCellRenderer)new ColoredListCellRenderer<IElementType>(){

            protected void customizeCellRenderer(@NotNull JList<? extends IElementType> list, IElementType value, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    this.append("None", SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                } else if (value instanceof SqlReferenceElementType) {
                    String name = ((SqlReferenceElementType)value).getTargetKind().code().replace("-", " ");
                    this.append(StringUtil.capitalizeWords((String)name, (boolean)true));
                    String comment = (String)((Map)fragments.second).get(value);
                    if (comment != null) {
                        this.append(" " + comment, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                    }
                    this.append(" reference", SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    String name = (String)ourNamedFragments.get(value);
                    if (name == null) {
                        name = StringUtil.toLowerCase((String)value.toString());
                    }
                    this.append(name);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/sql/injection/SqlTypePanel$1", "customizeCellRenderer"));
            }
        });
        this.myHostLanguages = new LinkLabel("", null, (s, d) -> this.showSqlDialectPopup());
        this.updateHostLanguagesText(((SqlTypeBasedInjection)this.myOrigInjection).getHostLanguages());
        ComboBox cb = (ComboBox)UIUtil.uiTraverser((Component)this.myLanguagePanel.getComponent()).filter(ComboBox.class).first();
        if (cb != null) {
            cb.addItemListener(e -> this.updateFragmentEnabled(this.myLanguagePanel.getLanguage()));
        }
    }

    private void showSqlDialectPopup() {
        CheckBoxList list = new CheckBoxList();
        list.setCheckBoxListListener((index2, value) -> {
            Language language = (Language)list.getItemAt(index2);
            if (language == null) {
                return;
            }
            if (value) {
                this.myHostLanguagesList.add(language.getID());
                if (this.myHostLanguagesList.size() == list.getItemsCount()) {
                    this.myHostLanguagesList.clear();
                }
            } else {
                if (this.myHostLanguagesList.isEmpty()) {
                    int end = list.getItemsCount();
                    for (int i2 = 0; i2 < end; ++i2) {
                        Language lang = (Language)list.getItemAt(i2);
                        if (lang == null) continue;
                        this.myHostLanguagesList.add(lang.getID());
                    }
                }
                this.myHostLanguagesList.remove(language.getID());
            }
            this.updateHostLanguagesText(this.myHostLanguagesList);
        });
        for (Language language : SqlLanguage.INSTANCE.getDialects()) {
            list.addItem((Object)language, language.getDisplayName(), this.myHostLanguagesList.isEmpty() || this.myHostLanguagesList.contains(language.getID()));
        }
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)list, (JComponent)list).createPopup().showUnderneathOf((Component)this.myHostLanguages);
    }

    private void updateHostLanguagesText(@NotNull Collection<String> hostIds) {
        if (hostIds == null) {
            SqlTypePanel.$$$reportNull$$$0(2);
        }
        if (hostIds.isEmpty()) {
            this.myHostLanguages.setText("All");
        } else {
            List sorted = ContainerUtil.sorted(hostIds);
            this.myHostLanguages.setText(StringUtil.shortenTextWithEllipsis((String)StringUtil.join((Collection)sorted, (String)", "), (int)50, (int)10, (boolean)false));
        }
    }

    @NotNull
    private static Pair<List<IElementType>, Map<IElementType, String>> getFragments() {
        ArrayList elements = ContainerUtil.newArrayList();
        HashMap comments = ContainerUtil.newHashMap();
        elements.add(null);
        elements.addAll(ContainerUtil.sorted(ourNamedFragments.keySet(), Comparator.comparing(ourNamedFragments::get)));
        Set<SqlReferenceElementType> references = SqlTypePanel.getReferenceTypes();
        MultiMap duplicates = MultiMap.create();
        for (SqlReferenceElementType reference : references) {
            duplicates.putValue((Object)reference.getTargetKind(), (Object)reference);
        }
        for (Map.Entry entry : duplicates.entrySet()) {
            Collection refs = (Collection)entry.getValue();
            if (refs.size() < 2) continue;
            for (SqlReferenceElementType ref : refs) {
                String[] split = StringUtil.toLowerCase((String)ref.toString()).split("_");
                if (split.length < 3) continue;
                split = Arrays.copyOfRange(split, 1, split.length - 1);
                comments.put(ref, StringUtil.join((String[])split, (String)" "));
            }
        }
        elements.addAll(ContainerUtil.sorted(references, Comparator.comparing(r -> r.getTargetKind().code())));
        Pair pair = Pair.create((Object)elements, (Object)comments);
        if (pair == null) {
            SqlTypePanel.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @NotNull
    private static Set<SqlReferenceElementType> getReferenceTypes() {
        Set set = JBIterable.from((Iterable)SqlTokenRegistry.getAllCompositeTypes()).filter(e -> !ourFiltered.contains(e)).filter(SqlReferenceElementType.class).toSet();
        if (set == null) {
            SqlTypePanel.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostIds";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/injection/SqlTypePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/injection/SqlTypePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateHostLanguagesText";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null, 0, true));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Type pattern:");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myPatternEditor;
        jPanel2.add((Component)editorTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("In SQL dialects:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        LinkLabel linkLabel = this.myHostLanguages;
        jPanel2.add((Component)linkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Fragment:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox<IElementType> comboBox = this.myFragment;
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        LanguagePanel languagePanel = this.myLanguagePanel;
        JComponent jComponent = languagePanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

