/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.db2.Db2Dialect;
import com.intellij.sql.dialects.derby.DerbyDialect;
import com.intellij.sql.dialects.exasol.ExasolDialect;
import com.intellij.sql.dialects.exasol.ExasolInjectionIdentifyingLexer;
import com.intellij.sql.dialects.generic.GenericDialect;
import com.intellij.sql.dialects.h2.H2Dialect;
import com.intellij.sql.dialects.hsqldb.HsqldbDialect;
import com.intellij.sql.dialects.mssql.MssqlDialect;
import com.intellij.sql.dialects.mysql.MysqlDialect;
import com.intellij.sql.dialects.oracle.OracleDialect;
import com.intellij.sql.dialects.oracle.plus.OrapDialect;
import com.intellij.sql.dialects.postgres.PostgresDialect;
import com.intellij.sql.dialects.postgres.PostgresInjectionIdentifyingLexer;
import com.intellij.sql.dialects.redshift.RedshiftDialect;
import com.intellij.sql.dialects.redshift.RedshiftInjectionIdentifyingLexer;
import com.intellij.sql.dialects.sql92.Sql92Dialect;
import com.intellij.sql.dialects.sqlite.SqliteDialect;
import com.intellij.sql.dialects.sybase.SybaseDialect;
import com.intellij.sql.highlighting.SqlDeepSyntaxHighlighter;
import com.intellij.sql.highlighting.SqlSyntaxHighlighter;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile file) {
        SqlLanguageDialect dialect = SqlLanguageSubstitutor.getSqlLanguageDialect(file, project);
        SyntaxHighlighter syntaxHighlighter = SqlSyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, (Project)project, (VirtualFile)file);
        if (syntaxHighlighter == null) {
            SqlSyntaxHighlighterFactory.$$$reportNull$$$0(0);
        }
        return syntaxHighlighter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/highlighting/SqlSyntaxHighlighterFactory", "getSyntaxHighlighter"));
    }

    static class BaseDeep
    extends Base {
        final Factory<Lexer> baseLexerFactory;
        final IElementType injectionTokenType;

        BaseDeep(@NotNull SqlLanguageDialect dialect, @NotNull Factory<Lexer> baseLexerFactory, @Nullable IElementType injectionTokenType) {
            if (dialect == null) {
                BaseDeep.$$$reportNull$$$0(0);
            }
            if (baseLexerFactory == null) {
                BaseDeep.$$$reportNull$$$0(1);
            }
            super(dialect);
            this.baseLexerFactory = baseLexerFactory;
            this.injectionTokenType = injectionTokenType;
        }

        @Override
        @NotNull
        public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile file) {
            SqlDeepSyntaxHighlighter sqlDeepSyntaxHighlighter = new SqlDeepSyntaxHighlighter(this.dialect, project, file, this.baseLexerFactory, this.injectionTokenType);
            if (sqlDeepSyntaxHighlighter == null) {
                BaseDeep.$$$reportNull$$$0(2);
            }
            return sqlDeepSyntaxHighlighter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseLexerFactory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/highlighting/SqlSyntaxHighlighterFactory$BaseDeep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/highlighting/SqlSyntaxHighlighterFactory$BaseDeep";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSyntaxHighlighter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class Base
    extends SyntaxHighlighterFactory {
        final SqlLanguageDialect dialect;

        Base(SqlLanguageDialect dialect) {
            this.dialect = dialect;
        }

        @NotNull
        public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile file) {
            SqlSyntaxHighlighter sqlSyntaxHighlighter = new SqlSyntaxHighlighter(this.dialect, project, file);
            if (sqlSyntaxHighlighter == null) {
                Base.$$$reportNull$$$0(0);
            }
            return sqlSyntaxHighlighter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/highlighting/SqlSyntaxHighlighterFactory$Base", "getSyntaxHighlighter"));
        }
    }

    public static class Exasol
    extends BaseDeep {
        public Exasol() {
            super(ExasolDialect.INSTANCE, (Factory<Lexer>)((Factory)ExasolInjectionIdentifyingLexer::new), (IElementType)SqlTokens.SQL_RAW_INPUT);
        }
    }

    public static class Sybase
    extends Base {
        public Sybase() {
            super(SybaseDialect.INSTANCE);
        }
    }

    public static class Db2
    extends Base {
        public Db2() {
            super(Db2Dialect.INSTANCE);
        }
    }

    public static class H2
    extends Base {
        public H2() {
            super(H2Dialect.INSTANCE);
        }
    }

    public static class Mssql
    extends Base {
        public Mssql() {
            super(MssqlDialect.INSTANCE);
        }
    }

    public static class Hsqldb
    extends Base {
        public Hsqldb() {
            super(HsqldbDialect.INSTANCE);
        }
    }

    public static class Redshift
    extends BaseDeep {
        public Redshift() {
            super(RedshiftDialect.INSTANCE, (Factory<Lexer>)((Factory)RedshiftInjectionIdentifyingLexer::new), null);
        }
    }

    public static class Postgres
    extends BaseDeep {
        public Postgres() {
            super(PostgresDialect.INSTANCE, (Factory<Lexer>)((Factory)PostgresInjectionIdentifyingLexer::new), null);
        }
    }

    public static class Derby
    extends Base {
        public Derby() {
            super(DerbyDialect.INSTANCE);
        }
    }

    public static class Orap
    extends Base {
        public Orap() {
            super(OrapDialect.INSTANCE);
        }
    }

    public static class Oracle
    extends Base {
        public Oracle() {
            super(OracleDialect.INSTANCE);
        }
    }

    public static class Sqlite
    extends Base {
        public Sqlite() {
            super(SqliteDialect.INSTANCE);
        }
    }

    public static class Mysql
    extends Base {
        public Mysql() {
            super(MysqlDialect.INSTANCE);
        }
    }

    public static class Generic
    extends Base {
        public Generic() {
            super(GenericDialect.INSTANCE);
        }
    }

    public static class Sql92
    extends Base {
        public Sql92() {
            super(Sql92Dialect.INSTANCE);
        }
    }
}

