/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.redshift;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.properties.RedshiftExternalTableStorageType;
import com.intellij.database.model.redshift.RedshiftModExternalSchema;
import com.intellij.database.model.redshift.RedshiftModExternalTable;
import com.intellij.database.model.redshift.RedshiftModExternalTableColumn;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresBaseObjectBuilder;
import com.intellij.sql.dialects.redshift.RedshiftObjectBuilder;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlCreateStatementImpl;
import com.intellij.sql.psi.stubs.SqlColumnDefinitionElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/dialects/redshift/RedshiftObjectBuilder;", "Lcom/intellij/sql/dialects/postgres/PostgresBaseObjectBuilder;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildExternalSchema", "Lcom/intellij/database/model/redshift/RedshiftModExternalSchema;", "buildExternalTable", "Lcom/intellij/database/model/redshift/RedshiftModExternalTable;", "findOptions", "", "", "element", "Lcom/intellij/psi/PsiElement;", "findTerminator", "setColumnsOrder", "table", "by", "intellij.database.sql.dialects"})
public final class RedshiftObjectBuilder
extends PostgresBaseObjectBuilder {
    @Override
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof RedshiftModExternalSchema) {
            this.buildExternalSchema((RedshiftModExternalSchema)obj, source);
        } else if (basicModElement instanceof RedshiftModExternalTable) {
            this.buildExternalTable((RedshiftModExternalTable)obj, source);
        } else {
            super.build(obj, source);
        }
    }

    private final void buildExternalTable(RedshiftModExternalTable obj, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            RedshiftObjectBuilder this_$iv;
            String serializationLib = null;
            String inputFormat = null;
            String outputFormat = null;
            String location = null;
            RedshiftExternalTableStorageType storageType = RedshiftExternalTableStorageType.UNKNOWN;
            List<String> serdeProperties = new ArrayList();
            List<String> properties = CollectionsKt.emptyList();
            RedshiftObjectBuilder redshiftObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                String terminator;
                List<String> $receiver;
                List<String> list;
                PsiElement it = tmp$iv$iv;
                IElementType iElementType = this.getElementType(it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SERDE)) {
                    serializationLib = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_FIELDS)) {
                    List<String> list2 = serdeProperties;
                    if (!TypeIntrinsics.isMutableList((Object)list2)) {
                        list2 = null;
                    }
                    if (list2 != null) {
                        $receiver = list = list2;
                        terminator = this.findTerminator(it);
                        if (terminator != null) {
                            $receiver.add("'field.delim'='" + terminator + '\'');
                            $receiver.add("'serialization.format'='" + terminator + '\'');
                        }
                        serializationLib = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LINES)) {
                    List<String> list3 = serdeProperties;
                    if (!TypeIntrinsics.isMutableList((Object)list3)) {
                        list3 = null;
                    }
                    if (list3 != null) {
                        $receiver = list = list3;
                        terminator = this.findTerminator(it);
                        if (terminator == null) continue;
                        $receiver.add("'line.delim'='" + terminator + '\'');
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LOCATION)) {
                    location = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_INPUTFORMAT)) {
                    inputFormat = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OUTPUTFORMAT)) {
                    outputFormat = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PARQUET)) {
                    storageType = RedshiftExternalTableStorageType.PARQUET;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_RCFILE)) {
                    storageType = RedshiftExternalTableStorageType.RCFILE;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SEQUENCEFILE)) {
                    storageType = RedshiftExternalTableStorageType.SEQUENCEFILE;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_TEXTFILE)) {
                    storageType = RedshiftExternalTableStorageType.TEXTFILE;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_ORC)) {
                    storageType = RedshiftExternalTableStorageType.ORC;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_AVRO)) {
                    storageType = RedshiftExternalTableStorageType.AVRO;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SERDEPROPERTIES)) {
                    serdeProperties = this.findOptions(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_TABLE)) {
                    IElementType iElementType2 = PgTypes.PG_PROPERTIES;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"PgTypes.PG_PROPERTIES");
                    PsiElement props = this.findSibling(it, iElementType2);
                    if (props == null) continue;
                    properties = this.findOptions(props);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PARTITIONED)) continue;
                IElementType iElementType3 = PgTypes.PG_BY;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PgTypes.PG_BY");
                PsiElement by = this.findSibling(it, iElementType3);
                if (by == null) continue;
                this.setColumnsOrder(obj, by);
            }
            obj.setSerializationLib(serializationLib);
            obj.setInputFormat(inputFormat);
            obj.setOutputFormat(outputFormat);
            obj.setLocation(location);
            obj.setStorageType(storageType);
            obj.setSerdeProperties(serdeProperties);
            obj.setProps(properties);
        }
    }

    private final void buildExternalSchema(RedshiftModExternalSchema obj, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            RedshiftObjectBuilder this_$iv;
            String database = null;
            String iamRole = null;
            String uri = null;
            String port = null;
            String region = null;
            int schemaKind = 1;
            RedshiftObjectBuilder redshiftObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                IElementType iElementType = this.getElementType(it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_DATABASE)) {
                    database = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_IAM_ROLE)) {
                    iamRole = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_URI)) {
                    uri = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PORT)) {
                    Float f = this.findNumberInSiblings(it);
                    port = f != null ? String.valueOf((int)f.floatValue()) : null;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_REGION)) {
                    region = this.findString(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_HIVE)) continue;
                IElementType iElementType2 = PgTypes.PG_METASTORE;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"PgTypes.PG_METASTORE");
                if (this.findSibling(it, iElementType2) == null) continue;
                schemaKind = 2;
            }
            obj.setDatabaseName(database);
            obj.setIamRole(iamRole);
            obj.setUri(uri);
            obj.setPort(port);
            obj.setRegion(region);
            obj.setSchemaKind(schemaKind);
            obj.setVisible(true);
        }
    }

    private final String findTerminator(PsiElement element) {
        IElementType iElementType = PgTypes.PG_TERMINATED;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"PgTypes.PG_TERMINATED");
        PsiElement psiElement = this.findSibling(element, iElementType);
        if (psiElement == null) {
            return null;
        }
        PsiElement terminated = psiElement;
        IElementType iElementType2 = PgTypes.PG_BY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"PgTypes.PG_BY");
        PsiElement psiElement2 = this.findSibling(terminated, iElementType2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement by = psiElement2;
        return this.findString(by);
    }

    private final void setColumnsOrder(RedshiftModExternalTable table, PsiElement by) {
        SqlColumnDefinitionElementType sqlColumnDefinitionElementType = SqlCompositeElementTypes.SQL_COLUMN_DEFINITION;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlColumnDefinitionElementType), (String)"SqlCompositeElementTypes.SQL_COLUMN_DEFINITION");
        PsiElement psiElement = this.findSibling(by, (IElementType)sqlColumnDefinitionElementType);
        if (!(psiElement instanceof SqlColumnDefinition)) {
            psiElement = null;
        }
        SqlColumnDefinition def2 = (SqlColumnDefinition)psiElement;
        int order = 1;
        while (def2 != null) {
            RedshiftModExternalTableColumn column2;
            String name;
            SqlIdentifier sqlIdentifier = def2.getNameElement();
            String string = name = sqlIdentifier != null ? sqlIdentifier.getName() : null;
            if (name != null && (column2 = (RedshiftModExternalTableColumn)table.getColumns().find((Predicate)new Predicate<RedshiftModExternalTableColumn>(name){
                final /* synthetic */ String $name;

                public final boolean test(RedshiftModExternalTableColumn it) {
                    RedshiftModExternalTableColumn redshiftModExternalTableColumn = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)redshiftModExternalTableColumn, (String)"it");
                    return Intrinsics.areEqual((Object)redshiftModExternalTableColumn.getName(), (Object)this.$name);
                }
                {
                    this.$name = string;
                }
            })) != null) {
                column2.setPartitionKeyOrder(order++);
            }
            PsiElement psiElement2 = def2.getNextSibling();
            SqlColumnDefinitionElementType sqlColumnDefinitionElementType2 = SqlCompositeElementTypes.SQL_COLUMN_DEFINITION;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlColumnDefinitionElementType2), (String)"SqlCompositeElementTypes.SQL_COLUMN_DEFINITION");
            PsiElement psiElement3 = this.findSibling(psiElement2, (IElementType)sqlColumnDefinitionElementType2);
            if (!(psiElement3 instanceof SqlColumnDefinition)) {
                psiElement3 = null;
            }
            def2 = (SqlColumnDefinition)psiElement3;
        }
    }

    private final List<String> findOptions(PsiElement element) {
        return this.findOptions(element, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)new Function1<PsiElement, PsiElement>(this){
            final /* synthetic */ RedshiftObjectBuilder this$0;

            @Nullable
            public final PsiElement invoke(@NotNull PsiElement current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_STRING_LITERAL;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_STRING_LITERAL");
                return RedshiftObjectBuilder.access$findSibling(this.this$0, current, (IElementType)sqlCompositeElementType);
            }
            {
                this.this$0 = redshiftObjectBuilder;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)findOptions.2.INSTANCE));
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$findSibling(RedshiftObjectBuilder $this, @Nullable PsiElement element, @NotNull IElementType type) {
        return $this.findSibling(element, type);
    }
}

