/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.postgres.PostgresModAccessMethod;
import com.intellij.database.model.postgres.PostgresModAggregate;
import com.intellij.database.model.postgres.PostgresModForeignDataWrapper;
import com.intellij.database.model.postgres.PostgresModForeignServer;
import com.intellij.database.model.postgres.PostgresModRole;
import com.intellij.database.model.postgres.PostgresModRoutine;
import com.intellij.database.model.postgres.PostgresModSequence;
import com.intellij.database.model.postgres.PostgresModUserMapping;
import com.intellij.database.model.properties.PostgresAccessMethodType;
import com.intellij.database.model.properties.PostgresAggregateKind;
import com.intellij.database.model.properties.PostgresRoutineConcurrencyKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresBaseObjectBuilder;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.dialects.postgres.PostgresObjectBuilder;
import com.intellij.sql.dialects.postgres.psi.PgCreateAggregateStatementImpl;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateSequenceStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateUserStatementImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0007\u001a\u0004\u0018\u00010\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0007\u001a\u00020\u0019H\u0002J\u0019\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010\u0007\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0002J\u0014\u0010*\u001a\u0004\u0018\u00010&2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010+\u001a\u0004\u0018\u00010 *\u0004\u0018\u00010,H\u0002\u00a8\u0006."}, d2={"Lcom/intellij/sql/dialects/postgres/PostgresObjectBuilder;", "Lcom/intellij/sql/dialects/postgres/PostgresBaseObjectBuilder;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildAccessMethod", "Lcom/intellij/database/model/postgres/PostgresModAccessMethod;", "buildAggregate", "Lcom/intellij/database/model/postgres/PostgresModAggregate;", "buildForeignDataWrapper", "Lcom/intellij/database/model/postgres/PostgresModForeignDataWrapper;", "buildForeignServer", "Lcom/intellij/database/model/postgres/PostgresModForeignServer;", "buildRole", "Lcom/intellij/database/model/postgres/PostgresModRole;", "buildRoutine", "Lcom/intellij/database/model/postgres/PostgresModRoutine;", "buildSequence", "Lcom/intellij/database/model/postgres/PostgresModSequence;", "buildSequenceIdentity", "Lcom/intellij/database/model/SequenceIdentity;", "Lcom/intellij/psi/PsiElement;", "buildUserMapping", "Lcom/intellij/database/model/postgres/PostgresModUserMapping;", "findConcurrencyKind", "Lcom/intellij/database/model/properties/PostgresRoutineConcurrencyKind;", "element", "findFunctionReference", "Lcom/intellij/sql/dialects/postgres/PostgresObjectBuilder$Reference;", "findNumber", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Long;", "findOptions", "", "", "findReference", "type", "Lcom/intellij/sql/psi/SqlReferenceElementType;", "findUser", "asReferenceData", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "Reference", "intellij.database.sql.dialects"})
public class PostgresObjectBuilder
extends PostgresBaseObjectBuilder {
    @Override
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof PostgresModSequence) {
            this.buildSequence((PostgresModSequence)obj, source);
        } else if (basicModElement instanceof PostgresModRoutine) {
            this.buildRoutine((PostgresModRoutine)obj, source);
        } else if (basicModElement instanceof PostgresModForeignDataWrapper) {
            this.buildForeignDataWrapper((PostgresModForeignDataWrapper)obj, source);
        } else if (basicModElement instanceof PostgresModForeignServer) {
            this.buildForeignServer((PostgresModForeignServer)obj, source);
        } else if (basicModElement instanceof PostgresModUserMapping) {
            this.buildUserMapping((PostgresModUserMapping)obj, source);
        } else if (basicModElement instanceof PostgresModRole) {
            this.buildRole((PostgresModRole)obj, source);
        } else if (basicModElement instanceof PostgresModAggregate) {
            this.buildAggregate((PostgresModAggregate)obj, source);
        } else if (basicModElement instanceof PostgresModAccessMethod) {
            this.buildAccessMethod((PostgresModAccessMethod)obj, source);
        } else {
            super.build(obj, source);
        }
    }

    private final void buildAccessMethod(PostgresModAccessMethod obj, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            PostgresAccessMethodType type = PostgresAccessMethodType.UNKNOWN;
            String handler = null;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement first$iv$iv2;
                PostgresObjectBuilder this_$iv2;
                PsiElement child = tmp$iv$iv;
                IElementType iElementType = this.getElementType(child);
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_CLAUSE)) continue;
                PostgresObjectBuilder postgresObjectBuilder2 = this_$iv2 = this;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2 = child.getFirstChild(); tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    PsiElement it = tmp$iv$iv2;
                    IElementType iElementType2 = this.getElementType(it);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_INDEX)) {
                        type = PostgresAccessMethodType.INDEX;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_HANDLER)) continue;
                    Reference reference = this.findFunctionReference(it);
                    handler = reference != null ? reference.getFullName() : null;
                }
            }
            obj.setType(type);
            obj.setHandler(handler);
        }
    }

    private final void buildAggregate(PostgresModAggregate obj, DasObject source) {
        if (source instanceof PgCreateAggregateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            String transitionFunction = null;
            DataType transitionType = DataType.UNKNOWN;
            String finalFunction = null;
            String initialCondition = null;
            String sortOperator = null;
            boolean finalExtra = false;
            String combineFunction = null;
            String serializationFunction = null;
            String deserializationFunction = null;
            String movingTransition = null;
            String inverseTransition = null;
            DataType movingStateType = DataType.UNKNOWN;
            long stateSize = 0L;
            long movingStateSize = 0L;
            String movingFinalFunction = null;
            boolean movingFinalExtra = false;
            String movingInitialCondition = null;
            PostgresAggregateKind kind = PostgresAggregateKind.NORMAL;
            PostgresRoutineConcurrencyKind concurrencyKind = PostgresRoutineConcurrencyKind.UNSAFE;
            int directArgs = 0;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement first$iv$iv2;
                PostgresObjectBuilder this_$iv2;
                PsiElement it;
                PsiElement psiElement;
                IElementType iElementType;
                PsiElement it2;
                PsiElement tmp$iv$iv2;
                PostgresObjectBuilder $receiver$iv;
                PsiElement child = tmp$iv$iv;
                IElementType iElementType2 = this.getElementType(child);
                if (Intrinsics.areEqual((Object)iElementType2, (Object)SqlElementTypes.SQL_PARAMETER_LIST)) {
                    int index2;
                    block33: {
                        int n;
                        PsiElement[] psiElementArray = child.getChildren();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"child.children");
                        Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])psiElementArray), (Function1)buildAggregate.1.index.1.INSTANCE);
                        int index$iv = 0;
                        Iterator iterator = $receiver$iv.iterator();
                        while (iterator.hasNext()) {
                            Object item$iv = iterator.next();
                            PsiElement it3 = (PsiElement)item$iv;
                            if (it3 instanceof SqlOrderByClause) {
                                n = index$iv;
                                break block33;
                            }
                            ++index$iv;
                        }
                        n = index2 = -1;
                    }
                    if (index2 <= 0) continue;
                    directArgs = index2;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType2, (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE)) {
                    PsiElement first$iv$iv3;
                    PostgresObjectBuilder this_$iv3;
                    $receiver$iv = this_$iv3 = this;
                    for (tmp$iv$iv2 = first$iv$iv3 = child.getFirstChild(); tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        it2 = tmp$iv$iv2;
                        iElementType = this.getElementType(it2);
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            transitionFunction = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_INITCOND)) {
                            String string = this.findString(it2);
                            if (string == null) {
                                Float f = this.findNumberInSiblings(it2);
                                string = f != null ? String.valueOf((int)f.floatValue()) : null;
                            }
                            initialCondition = string;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SORTOP)) {
                            SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_OPERATOR_REFERENCE;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_OPERATOR_REFERENCE");
                            Reference reference = this.findReference(it2, sqlReferenceElementType);
                            sortOperator = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_FINALFUNC_EXTRA)) {
                            finalExtra = true;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_COMBINEFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            combineFunction = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SERIALFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            serializationFunction = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_DESERIALFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            deserializationFunction = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MSFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            movingTransition = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MINVFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            inverseTransition = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MSTYPE)) {
                            SqlTypeElement sqlTypeElement;
                            SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                            PsiElement psiElement2 = this.findSibling(it2, (IElementType)sqlCompositeElementType);
                            if (!(psiElement2 instanceof SqlTypeElement)) {
                                psiElement2 = null;
                            }
                            if ((sqlTypeElement = (SqlTypeElement)psiElement2) != null && (sqlTypeElement = sqlTypeElement.getDataType()) != null) {
                                it = psiElement = sqlTypeElement;
                                movingStateType = it;
                            }
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SSPACE)) {
                            Float f = this.findNumberInSiblings(it2);
                            stateSize = f != null ? (long)f.floatValue() : 0L;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MSSPACE)) {
                            Float f = this.findNumberInSiblings(it2);
                            movingStateSize = f != null ? (long)f.floatValue() : 0L;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MFINALFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            movingFinalFunction = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MFINALFUNC_EXTRA)) {
                            movingFinalExtra = true;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MINITCOND)) {
                            String string = this.findString(it2);
                            if (string == null) {
                                Float f = this.findNumberInSiblings(it2);
                                string = f != null ? String.valueOf((int)f.floatValue()) : null;
                            }
                            movingInitialCondition = string;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_HYPOTHETICAL)) {
                            kind = PostgresAggregateKind.HYPO_SET;
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PARALLEL)) continue;
                        concurrencyKind = this.findConcurrencyKind(it2);
                    }
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType2, (Object)((Object)SqlCompositeElementTypes.SQL_RETURNS_CLAUSE))) continue;
                PostgresObjectBuilder this_$iv$iv = this_$iv2 = this;
                for (tmp$iv$iv2 = first$iv$iv2 = child.getFirstChild(); tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    it2 = tmp$iv$iv2;
                    iElementType = this.getElementType(it2);
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_STYPE)) {
                        SqlTypeElement sqlTypeElement;
                        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                        PsiElement psiElement3 = this.findSibling(it2, (IElementType)sqlCompositeElementType);
                        if (!(psiElement3 instanceof SqlTypeElement)) {
                            psiElement3 = null;
                        }
                        if ((sqlTypeElement = (SqlTypeElement)psiElement3) != null && (sqlTypeElement = sqlTypeElement.getDataType()) != null) {
                            it = psiElement = sqlTypeElement;
                            transitionType = it;
                        }
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_FINALFUNC)) continue;
                    SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_FUNCTION_CALL;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_FUNCTION_CALL");
                    if (this.findSibling(it2, (IElementType)sqlCompositeElementType) == null) continue;
                    PsiElement call = psiElement;
                    PsiElement psiElement4 = call;
                    if (!(psiElement4 instanceof SqlFunctionCallExpression)) {
                        psiElement4 = null;
                    }
                    SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)psiElement4;
                    Object object = sqlFunctionCallExpression != null ? sqlFunctionCallExpression.getCallableExpression() : null;
                    if (!(object instanceof SqlReferenceExpression)) {
                        object = null;
                    }
                    SqlReferenceExpression reference = (SqlReferenceExpression)object;
                    Reference reference2 = this.asReferenceData(reference);
                    finalFunction = reference2 != null ? reference2.getFullName() : null;
                }
            }
            obj.setTransition(transitionFunction);
            obj.setTransitionDataType(transitionType);
            obj.setFinal(finalFunction);
            obj.setInitialValue(initialCondition);
            obj.setSortOperator(sortOperator);
            obj.setCombine(combineFunction);
            obj.setSerialization(serializationFunction);
            obj.setDeserialization(deserializationFunction);
            obj.setFinalExtra(finalExtra);
            obj.setMovingTransition(movingTransition);
            obj.setInverseTransition(inverseTransition);
            obj.setMovingStateType(movingStateType);
            obj.setStateSize(stateSize);
            obj.setMovingStateSize(movingStateSize);
            obj.setMovingFinal(movingFinalFunction);
            obj.setMovingFinalExtra(movingFinalExtra);
            obj.setMovingInitialValue(movingInitialCondition);
            obj.setAggregateKind(kind);
            obj.setConcurrencyKind(concurrencyKind);
            obj.setDirectArgs(directArgs);
        }
    }

    private final void buildRole(PostgresModRole obj, DasObject source) {
        if (source instanceof SqlCreateStatement) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            boolean isSuper = false;
            boolean isInherit = true;
            boolean canCreateRole = false;
            boolean canCreateDb = false;
            boolean canLogin = source instanceof SqlCreateUserStatementImpl;
            boolean isReplication = false;
            long connectionLimit = -1L;
            String validUntil = null;
            boolean isBypassRls = false;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement c;
                PsiElement it = tmp$iv$iv;
                if (!(it instanceof SqlClause)) continue;
                PsiElement psiElement = c = ((SqlClause)it).getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"c");
                IElementType iElementType = this.getElementType(psiElement);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SUPERUSER)) {
                    isSuper = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOINHERIT)) {
                    isInherit = false;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CREATEROLE)) {
                    canCreateRole = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CREATEDB)) {
                    canCreateDb = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LOGIN)) {
                    canLogin = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOLOGIN)) {
                    canLogin = false;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_REPLICATION)) {
                    isReplication = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CONNECTION)) {
                    IElementType iElementType2 = PgTypes.PG_LIMIT;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"PG_LIMIT");
                    Float f = this.findNumberInSiblings(this.findSibling(c, iElementType2));
                    connectionLimit = f != null ? (long)f.floatValue() : -1L;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VALID)) {
                    IElementType iElementType3 = PgTypes.PG_UNTIL;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PG_UNTIL");
                    validUntil = this.findString(this.findSibling(c, iElementType3));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_BYPASSRLS)) continue;
                isBypassRls = true;
            }
            obj.setSuperRole(isSuper);
            obj.setInherit(isInherit);
            obj.setCreateRole(canCreateRole);
            obj.setCreateDb(canCreateDb);
            obj.setCanLogin(canLogin);
            obj.setReplication(isReplication);
            obj.setConnectionLimit(connectionLimit);
            obj.setValidUntil(validUntil);
            obj.setBypassRls(isBypassRls);
        }
    }

    private final void buildForeignDataWrapper(PostgresModForeignDataWrapper obj, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            Reference handler = null;
            Reference validator = null;
            List<String> options = CollectionsKt.emptyList();
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                IElementType iElementType = this.getElementType(it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_HANDLER)) {
                    handler = this.findFunctionReference(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VALIDATOR)) {
                    validator = this.findFunctionReference(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            Reference reference = handler;
            obj.setHandler(reference != null ? reference.getName() : null);
            Reference reference2 = handler;
            obj.setHandlerSchema(reference2 != null ? reference2.getQualifier() : null);
            Reference reference3 = validator;
            obj.setValidator(reference3 != null ? reference3.getName() : null);
            Reference reference4 = validator;
            obj.setValidatorSchema(reference4 != null ? reference4.getQualifier() : null);
            obj.setOptions(options);
        }
    }

    private final void buildForeignServer(PostgresModForeignServer obj, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            String type = null;
            List<String> options = CollectionsKt.emptyList();
            String version = null;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                IElementType iElementType = this.getElementType(it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
                    PsiElement first;
                    if (it.getFirstChild() == null) {
                        continue;
                    }
                    IElementType iElementType2 = this.getElementType(first);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_TYPE)) {
                        type = this.findString(first);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_VERSION)) continue;
                    version = this.findString(first);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            obj.setType(type);
            obj.setOptions(options);
            obj.setVersion(version);
        }
    }

    private final void buildUserMapping(PostgresModUserMapping obj, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            String user = null;
            List<String> options = CollectionsKt.emptyList();
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                IElementType iElementType = this.getElementType(it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_FOR)) {
                    user = this.findUser(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            obj.setUser(user);
            obj.setOptions(options);
        }
    }

    private final void buildSequence(PostgresModSequence obj, DasObject source) {
        this.buildBasicElement(obj, source);
        if (source instanceof SqlCreateSequenceStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            obj.setSequenceIdentity(this.buildSequenceIdentity((PsiElement)source));
            boolean cycle = false;
            boolean owned = false;
            long cacheSize = 1L;
            String dataType = null;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement type;
                PsiElement it = tmp$iv$iv;
                if (!(it instanceof SqlClause)) continue;
                PsiElement psiElement = ((SqlClause)it).getFirstChild();
                if (psiElement == null || (psiElement = this.getElementType(psiElement)) == null) {
                    continue;
                }
                PsiElement psiElement2 = type = psiElement;
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_CYCLE)) {
                    cycle = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_OWNED)) {
                    SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlCompositeElementTypes.SQL_COLUMN_REFERENCE");
                    owned = this.findChild(it, (IElementType)sqlReferenceElementType) != null;
                    continue;
                }
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_CACHE)) {
                    Long l = this.findNumber(it);
                    cacheSize = l != null ? l : 1L;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_AS)) continue;
                SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                PsiElement psiElement3 = this.findChild(it, (IElementType)sqlCompositeElementType);
                if (!(psiElement3 instanceof SqlTypeElement)) {
                    psiElement3 = null;
                }
                SqlTypeElement sqlTypeElement = (SqlTypeElement)psiElement3;
                dataType = sqlTypeElement != null ? sqlTypeElement.getDisplayName() : null;
            }
            obj.setCycled(cycle);
            obj.setBelongsToColumn(owned);
            obj.setCacheSize(cacheSize);
            obj.setDataType(dataType);
        }
    }

    private final void buildRoutine(PostgresModRoutine obj, DasObject source) {
        super.buildRoutine(obj, source);
        if (source instanceof SqlCreateFunctionStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            ArrayList<String> assignments = new ArrayList<String>();
            PostgresRoutineConcurrencyKind concurrencyKind = PostgresRoutineConcurrencyKind.UNSAFE;
            boolean isLeakproof = false;
            boolean isWindow = false;
            boolean isStrict = false;
            boolean isSecurityDefiner = false;
            float cost = 0.0f;
            float rows = 0.0f;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement first$iv$iv2;
                PostgresObjectBuilder this_$iv2;
                PsiElement createChild = tmp$iv$iv;
                if (!Intrinsics.areEqual((Object)this.getElementType(createChild), (Object)PostgresElementTypes.PG_LAZY_CODE_BLOCK_PARENT)) continue;
                PostgresObjectBuilder postgresObjectBuilder2 = this_$iv2 = this;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2 = createChild.getFirstChild(); tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    IElementType iElementType;
                    PsiElement s;
                    PsiElement it = tmp$iv$iv2;
                    PsiElement psiElement = s = it.getFirstChild();
                    IElementType iElementType2 = iElementType = psiElement != null ? this.getElementType(psiElement) : null;
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SET)) {
                        PostgresObjectBuilder this_$iv3 = this;
                        for (PsiElement tmp$iv = s; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                            PsiElement it2 = tmp$iv;
                            if (!Intrinsics.areEqual((Object)this.getElementType(it2), (Object)PgTypes.PG_SET_ASSIGNMENT)) continue;
                            assignments.add(it2.getText());
                        }
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PARALLEL)) {
                        PsiElement psiElement2 = s;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"s");
                        concurrencyKind = this.findConcurrencyKind(psiElement2);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOT)) {
                        isLeakproof = false;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LEAKPROOF)) {
                        isLeakproof = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_WINDOW)) {
                        isWindow = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_STRICT)) {
                        isStrict = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SECURITY) || Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_EXTERNAL)) {
                        IElementType iElementType3 = PgTypes.PG_DEFINER;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PG_DEFINER");
                        isSecurityDefiner = this.findSibling(s, iElementType3) != null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_COST)) {
                        Float f = this.findNumberInSiblings(s);
                        cost = f != null ? f.floatValue() : 0.0f;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_ROWS)) continue;
                    Float f = this.findNumberInSiblings(s);
                    rows = f != null ? f.floatValue() : 0.0f;
                }
            }
            obj.setConfigurationParameters((List<String>)assignments);
            obj.setConcurrencyKind(concurrencyKind);
            obj.setLeakproof(isLeakproof);
            obj.setWindow(isWindow);
            obj.setStrict(isStrict);
            obj.setSecurityDefiner(isSecurityDefiner);
            obj.setCost(cost);
            obj.setRows(rows);
        }
    }

    private final SequenceIdentity buildSequenceIdentity(PsiElement source) {
        Long startVal;
        Long maxVal;
        Long minVal;
        PsiElement first$iv$iv;
        Long[] longArray = new Long[4];
        Object object = longArray;
        Object object2 = object[0];
        Long l = (Long)object2;
        object = longArray;
        object2 = object[1];
        Long l2 = (Long)object2;
        object = longArray;
        object2 = object[2];
        Long l3 = (Long)object2;
        object = longArray;
        object2 = object[3];
        Long incVal = (Long)object2;
        PostgresObjectBuilder this_$iv = this;
        object = this_$iv;
        PsiElement psiElement = source;
        for (PsiElement tmp$iv$iv = first$iv$iv = (v1682856) != null ? (v1682856).getFirstChild() : null; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            PsiElement type;
            PsiElement it = tmp$iv$iv;
            if (!(it instanceof SqlClause)) continue;
            PsiElement psiElement2 = ((SqlClause)it).getFirstChild();
            if (psiElement2 == null || (psiElement2 = this.getElementType(psiElement2)) == null) {
                continue;
            }
            PsiElement psiElement3 = type = psiElement2;
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_MINVALUE)) {
                minVal = this.findNumber(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_MAXVALUE)) {
                maxVal = this.findNumber(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_START)) {
                startVal = this.findNumber(it);
                continue;
            }
            if (!Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_INCREMENT)) continue;
            incVal = this.findNumber(it);
        }
        SequenceIdentity sequenceIdentity = SequenceIdentity.of(minVal, startVal, incVal, maxVal);
        Intrinsics.checkExpressionValueIsNotNull((Object)sequenceIdentity, (String)"SequenceIdentity.of(minV\u2026startVal, incVal, maxVal)");
        return sequenceIdentity;
    }

    private final PostgresRoutineConcurrencyKind findConcurrencyKind(PsiElement element) {
        PostgresObjectBuilder this_$iv = this;
        for (PsiElement tmp$iv = element; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            PsiElement it = tmp$iv;
            ASTNode aSTNode = it.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
            IElementType iElementType = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SAFE)) {
                return PostgresRoutineConcurrencyKind.SAFE;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_RESTRICTED)) {
                return PostgresRoutineConcurrencyKind.RESTRICTED;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_UNSAFE)) continue;
            return PostgresRoutineConcurrencyKind.UNSAFE;
        }
        return PostgresRoutineConcurrencyKind.UNSAFE;
    }

    private final List<String> findOptions(PsiElement source) {
        return this.findOptions(source, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)new Function1<PsiElement, PsiElement>(this){
            final /* synthetic */ PostgresObjectBuilder this$0;

            @Nullable
            public final PsiElement invoke(@NotNull PsiElement current) {
                PsiElement psiElement;
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                    PostgresObjectBuilder this_$iv = this.this$0;
                    for (PsiElement tmp$iv = current; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                        PsiElement it = tmp$iv;
                        if (!(Intrinsics.areEqual((Object)it, (Object)current) ^ true && Intrinsics.areEqual((Object)PostgresObjectBuilder.access$getElementType$p(this.this$0, it), (Object)SqlElementTypes.SQL_STRING_LITERAL) ^ true && Intrinsics.areEqual((Object)PostgresObjectBuilder.access$getElementType$p(this.this$0, it), (Object)SqlElementTypes.WHITE_SPACE) ^ true)) continue;
                        psiElement = tmp$iv;
                        break block1;
                    }
                    psiElement = null;
                }
                return psiElement;
            }
            {
                this.this$0 = postgresObjectBuilder;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)findOptions.2.INSTANCE));
    }

    private final Long findNumber(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toLongOrNull((String)object) : null;
    }

    private final Reference findFunctionReference(PsiElement source) {
        SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_FUNCTION_REFERENCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_FUNCTION_REFERENCE");
        return this.findReference(source, sqlReferenceElementType);
    }

    private final Reference findReference(PsiElement source, SqlReferenceElementType type) {
        PsiElement psiElement = this.findSibling(source, (IElementType)type);
        if (!(psiElement instanceof SqlReferenceExpression)) {
            psiElement = null;
        }
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement;
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression reference = sqlReferenceExpression;
        return this.asReferenceData(reference);
    }

    private final Reference asReferenceData(@Nullable SqlReferenceExpression $receiver) {
        if ($receiver == null) {
            return null;
        }
        Object object = $receiver.getIdentifier();
        if (object == null || (object = object.getName()) == null) {
            return null;
        }
        Object name = object;
        SqlExpression sqlExpression = $receiver.getQualifierExpression();
        String qualifier = sqlExpression != null ? sqlExpression.getName() : null;
        Object[] objectArray = new String[2];
        SqlExpression sqlExpression2 = $receiver.getQualifierExpression();
        objectArray[0] = sqlExpression2 != null ? sqlExpression2.getText() : null;
        SqlIdentifier sqlIdentifier = $receiver.getIdentifier();
        objectArray[1] = sqlIdentifier != null ? sqlIdentifier.getText() : null;
        String fullText = CollectionsKt.joinToString$default((Iterable)ArraysKt.filterNotNull((Object[])objectArray), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        Object object2 = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"name");
        return new Reference(qualifier, (String)object2, fullText);
    }

    private final String findUser(PsiElement source) {
        SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_USER_REFERENCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_USER_REFERENCE");
        PsiElement userReference = this.findSibling(source, (IElementType)sqlReferenceElementType);
        if (userReference instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)userReference).getName();
        }
        PostgresObjectBuilder this_$iv = this;
        for (PsiElement tmp$iv = source; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            PsiElement it = tmp$iv;
            ASTNode aSTNode = it.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
            IElementType iElementType = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_USER_REFERENCE)) {
                if (!(userReference instanceof SqlReferenceExpression)) continue;
                return ((SqlReferenceExpression)userReference).getName();
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_USER)) {
                return "user";
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CURRENT_USER)) {
                return "current_user";
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PUBLIC)) continue;
            return "public";
        }
        return null;
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$findSibling(PostgresObjectBuilder $this, @Nullable PsiElement element, @NotNull Function1 action) {
        return $this.findSibling(element, (Function1<? super PsiElement, Boolean>)action);
    }

    @Nullable
    public static final /* synthetic */ IElementType access$getElementType$p(PostgresObjectBuilder $this, @NotNull PsiElement $receiver) {
        return $this.getElementType($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/dialects/postgres/PostgresObjectBuilder$Reference;", "", "qualifier", "", "name", "fullName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFullName", "()Ljava/lang/String;", "getName", "getQualifier", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.sql.dialects"})
    private static final class Reference {
        @Nullable
        private final String qualifier;
        @NotNull
        private final String name;
        @NotNull
        private final String fullName;

        @Nullable
        public final String getQualifier() {
            return this.qualifier;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        public Reference(@Nullable String qualifier, @NotNull String name, @NotNull String fullName) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
            this.qualifier = qualifier;
            this.name = name;
            this.fullName = fullName;
        }

        @Nullable
        public final String component1() {
            return this.qualifier;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.fullName;
        }

        @NotNull
        public final Reference copy(@Nullable String qualifier, @NotNull String name, @NotNull String fullName) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
            return new Reference(qualifier, name, fullName);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Reference copy$default(Reference reference, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = reference.qualifier;
            }
            if ((n & 2) != 0) {
                string2 = reference.name;
            }
            if ((n & 4) != 0) {
                string3 = reference.fullName;
            }
            return reference.copy(string, string2, string3);
        }

        public String toString() {
            return "Reference(qualifier=" + this.qualifier + ", name=" + this.name + ", fullName=" + this.fullName + ")";
        }

        public int hashCode() {
            String string = this.qualifier;
            String string2 = this.name;
            String string3 = this.fullName;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Reference)) break block3;
                    Reference reference = (Reference)object;
                    if (!Intrinsics.areEqual((Object)this.qualifier, (Object)reference.qualifier) || !Intrinsics.areEqual((Object)this.name, (Object)reference.name) || !Intrinsics.areEqual((Object)this.fullName, (Object)reference.fullName)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

