/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.dialects.postgres.PostgresLexerBase;
import com.intellij.sql.dialects.postgres.PostgresOptionalKeywords;
import com.intellij.sql.dialects.postgres.PostgresReservedKeywords;
import com.intellij.sql.dialects.postgres.PostgresTokens;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer._PostgresLexer;
import org.jetbrains.annotations.NotNull;

public class PostgresLexer
extends PostgresLexerBase {
    private int myCopyState;

    public PostgresLexer() {
        super(PostgresTokens.class, PostgresReservedKeywords.class, new _PostgresLexer());
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            PostgresLexer.$$$reportNull$$$0(0);
        }
        this.myCopyState = initialState >>> 30;
        super.start(buffer, startOffset, endOffset, 0x3FFFFFFF & initialState);
    }

    public int getState() {
        return this.myCopyState << 30 | 0x3FFFFFFF & super.getState();
    }

    public void advance() {
        if (this.myCopyState == 3 && this.getTokenType() == SqlTokens.SQL_RAW_INPUT) {
            this.myCopyState = 0;
        }
        super.advance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void lookSqlKeyword(Lexer baseLexer) {
        IElementType type = this.getSqlTokenType(baseLexer);
        if (this.myCopyState == 0) {
            if (PostgresLexer.isStatementPredecessor(type)) {
                this.advanceAs(baseLexer, type);
                this.skipCommentsAndWhitespaces(baseLexer);
                type = this.getSqlTokenType(baseLexer);
                if (type != PgTypes.PG_COPY) return;
                this.myCopyState = 1;
            } else if (type == PgTypes.PG_COPY) {
                this.myCopyState = 1;
            }
        } else if (this.myCopyState == 1) {
            if (type == PgTypes.PG_FROM) {
                this.advanceAs(baseLexer, type);
                this.skipCommentsAndWhitespaces(baseLexer);
                type = this.getSqlTokenType(baseLexer);
                if (type != PgTypes.PG_STDIN) return;
                this.myCopyState = 2;
            }
        } else if (this.myCopyState == 2 && PostgresLexer.isStatementSeparator(type)) {
            this.advanceAs(baseLexer, type);
            this.skipCommentsAndWhitespaces(baseLexer);
            this.createInputToken(baseLexer);
            this.myCopyState = 3;
            return;
        }
        if (this.myCopyState < 2 && PostgresLexer.isStatementSeparator(type)) {
            this.myCopyState = 0;
        }
        this.advanceAs(baseLexer, type);
    }

    private void createInputToken(Lexer baseLexer) {
        CharSequence buf = baseLexer.getBufferSequence();
        int start = baseLexer.getTokenStart();
        int end = baseLexer.getBufferEnd();
        int term = PostgresLexer.findInputTerminator(buf, start, end);
        this.addToken(term, (IElementType)SqlTokens.SQL_RAW_INPUT);
        if (term != start) {
            baseLexer.start(buf, term, end, baseLexer.getState());
        }
        this.skipCommentsAndWhitespaces(baseLexer);
        int s = baseLexer.getTokenStart();
        if (s + 1 < end && buf.charAt(s) == '\\' && buf.charAt(s + 1) == '.') {
            this.addToken(s + 2, (IElementType)SqlTokens.PG_COPY_TERMINATOR);
            baseLexer.start(buf, s + 2, end, baseLexer.getState());
        }
    }

    protected void skipCommentsAndWhitespaces(Lexer baseLexer) {
        IElementType type;
        while (SqlTokens.WS_OR_COMMENTS.contains(type = this.getSqlTokenType(baseLexer))) {
            this.advanceAs(baseLexer, type);
        }
    }

    private static int findInputTerminator(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            PostgresLexer.$$$reportNull$$$0(1);
        }
        int i2;
        while ((i2 = StringUtil.indexOf((CharSequence)text, (CharSequence)"\\.", (int)start, (int)end)) != -1) {
            int prev;
            int pi = i2 - 1;
            int n = prev = pi < start ? 13 : (int)text.charAt(pi);
            if (pi < start) {
                pi = start;
            }
            if (prev == 10 && pi > start && text.charAt(pi - 1) == '\r') {
                --pi;
            }
            if (prev == 10 || prev == 13) {
                int next;
                int ni = i2 + 2;
                int n2 = next = ni < end ? (int)text.charAt(ni) : 13;
                if (next == 10 || next == 13) {
                    return pi;
                }
            }
            start = i2 + 1;
        }
        return end;
    }

    private static boolean isStatementPredecessor(IElementType type) {
        return PostgresLexer.isStatementSeparator(type) || type == PgTypes.PG_BEGIN;
    }

    private static boolean isStatementSeparator(IElementType type) {
        return SqlTokens.STATEMENT_SEPARATORS.contains(type);
    }

    static {
        PostgresLexer.initTokensAndFunctions(PostgresElementTypes.PG_SQL_FILE, PostgresTokens.class, PostgresReservedKeywords.class, PostgresOptionalKeywords.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/postgres/PostgresLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findInputTerminator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

