/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol;

import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.exasol.ExasolLexer;
import com.intellij.sql.dialects.exasol.ExasolTypes;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.redshift.RedshiftInjectionIdentifyingLexer;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.sql.psi.impl.lexer.SqlLexer;
import org.jetbrains.annotations.NotNull;

public class ExasolInjectionIdentifyingLexer
extends ExasolLexer {
    private final SqlLexer.LookAheadHelper myLah = new SqlLexer.LookAheadHelper(){

        @Override
        protected void superLookAhead(Lexer lexer) {
            ExasolInjectionIdentifyingLexer.super.lookAhead(lexer);
        }
    };
    private String myScriptLang;

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            ExasolInjectionIdentifyingLexer.$$$reportNull$$$0(0);
        }
        this.myScriptLang = null;
        super.start(buffer, startOffset, endOffset, initialState);
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        this.myLah.restart(baseLexer);
        if (!this.myScriptState) {
            this.myScriptLang = null;
            if (this.myLah.getNextToken() == PgTypes.PG_CREATE) {
                this.myScriptLang = ExasolInjectionIdentifyingLexer.lookAheadLanguage(this.myLah);
            }
        } else {
            super.lookAhead(baseLexer);
        }
    }

    @Override
    protected IElementType getScriptTokenType() {
        return this.myScriptLang == null ? super.getScriptTokenType() : SqlTokenType.SqlInjectionMark.get((String)this.myScriptLang);
    }

    public static String lookAheadLanguage(SqlLexer.LookAheadHelper lah) {
        IElementType type = lah.getNextToken();
        if (type == ExasolTypes.EXA_OR) {
            type = RedshiftInjectionIdentifyingLexer.skipOrReplace(lah);
        }
        if (ExasolInjectionIdentifyingLexer.isPreScript(type) || type == ExasolTypes.EXA_SCRIPT) {
            return "lua";
        }
        String res = RedshiftInjectionIdentifyingLexer.getLanguage(lah, lah.getPos());
        if (res == null) {
            return null;
        }
        type = lah.getNextToken();
        if (ExasolInjectionIdentifyingLexer.isPreScript(type)) {
            type = lah.getNextToken();
        }
        return type == ExasolTypes.EXA_SCRIPT ? res : null;
    }

    private static boolean isPreScript(IElementType type) {
        return type == ExasolTypes.EXA_SCALAR || type == ExasolTypes.EXA_SET || type == ExasolTypes.EXA_ADAPTER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/sql/dialects/exasol/ExasolInjectionIdentifyingLexer", "start"));
    }
}

