/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreePatternUtils {
    public static final GroupedGroupFactory UNION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
            if (value == null) {
                1.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> ggroups) {
            return !1.containsNotNull(ggroups);
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value) {
            if (value == null) {
                1.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/sql/dialects/TreePatternUtils$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final GroupedGroupFactory INTERSECTION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
            if (value == null) {
                2.$$$reportNull$$$0(0);
            }
            return !2.containsNull(value);
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> ggroups) {
            return 2.containsNull(ggroups);
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value) {
            if (value == null) {
                2.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/sql/dialects/TreePatternUtils$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final GroupedGroupFactory MINUS_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value) {
            Iterator<TreePatternNode<?>> it;
            if (value == null) {
                3.$$$reportNull$$$0(0);
            }
            if (!(it = value.iterator()).hasNext()) {
                return false;
            }
            TreePatternNode<?> first = it.next();
            if (first == null) {
                return false;
            }
            while (it.hasNext()) {
                TreePatternNode<?> n = it.next();
                if (n == null || first.groups.length != 0 && n.groups.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
            Iterator<TreePatternNode.Group> it;
            if (value == null) {
                3.$$$reportNull$$$0(1);
            }
            return (it = value.iterator()).hasNext() && it.next() != null;
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> nodes2) {
            for (TreePatternNode<?> group2 : nodes2) {
                if (group2 == null || group2.groups.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean mergeChildren() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/sql/dialects/TreePatternUtils$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final TreePatternNode.Group SKIP_PROCESSING = new TreePatternNode.Group(ObjectKind.NONE, null, null);

    @NotNull
    public static String[] toStringArray(@NotNull Collection<String> names) {
        if (names == null) {
            TreePatternUtils.$$$reportNull$$$0(0);
        }
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            TreePatternUtils.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public static String[] toStringArray(@NotNull Iterable<String> names) {
        if (names == null) {
            TreePatternUtils.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.collect(names.iterator());
        String[] stringArray = TreePatternUtils.toStringArray(list);
        if (stringArray == null) {
            TreePatternUtils.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    public static boolean isValid(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            TreePatternUtils.$$$reportNull$$$0(4);
        }
        HashSet unique = ContainerUtil.newHashSet();
        if (g.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : g.positiveChildren) {
                for (ObjectName name : ((TreePatternNode.PositiveNaming)child.naming).getNames()) {
                    assert (unique.add(name)) : "Duplicate `" + name + "` " + new TreePattern(g);
                }
            }
        }
        if (g.negativeChild != null) {
            List<ObjectName> anti = Arrays.asList(((TreePatternNode.NegativeNaming)g.negativeChild.naming).getAntiNames());
            assert (anti.containsAll(unique)) : "Neg. covers pos. `" + ContainerUtil.newArrayList((Iterable)unique).removeAll(anti) + "` " + new TreePattern(g);
        }
        return true;
    }

    @NotNull
    public static Iterable<ObjectName> getSinkNames(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            TreePatternUtils.$$$reportNull$$$0(5);
        }
        if (g.negativeChild == null) {
            JBIterable jBIterable = JBIterable.of((Object[])g.positiveChildren).flatten(c -> JBIterable.of((Object[])((TreePatternNode.PositiveNaming)c.naming).getNames()));
            if (jBIterable == null) {
                TreePatternUtils.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }
        LinkedHashSet res = ContainerUtil.newLinkedHashSet((Object[])((TreePatternNode.NegativeNaming)g.negativeChild.naming).getAntiNames());
        if (g.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : g.positiveChildren) {
                ContainerUtil.removeAll((Collection)res, (Object[])((TreePatternNode.PositiveNaming)child.naming).getNames());
            }
        }
        LinkedHashSet linkedHashSet = res;
        if (linkedHashSet == null) {
            TreePatternUtils.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @NotNull
    public static TreePatternNode.NegativeNaming subdivideChildren(@NotNull Iterable<TreePatternNode.Group> groups, @NotNull MultiMap<TreePatternNode.PositiveNaming, TreePatternNode<?>> pSubdiv, @NotNull Collection<TreePatternNode<?>> nSubdiv, boolean mergeChildren) {
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(8);
        }
        if (pSubdiv == null) {
            TreePatternUtils.$$$reportNull$$$0(9);
        }
        if (nSubdiv == null) {
            TreePatternUtils.$$$reportNull$$$0(10);
        }
        LinkedHashSet allNames = ContainerUtil.newLinkedHashSet();
        for (TreePatternNode.Group group2 : groups) {
            if (group2 == null) continue;
            if (group2.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group2.positiveChildren) {
                    ContainerUtil.addAll((Collection)allNames, (Object[])((TreePatternNode.PositiveNaming)child.naming).getNames());
                }
            }
            if (group2.negativeChild == null) continue;
            ContainerUtil.addAll((Collection)allNames, (Object[])((TreePatternNode.NegativeNaming)group2.negativeChild.naming).getAntiNames());
        }
        MultiMap broadSubdiv = mergeChildren ? MultiMap.createLinkedSet() : MultiMap.createLinked();
        for (TreePatternNode.Group group3 : groups) {
            TreePatternNode<TreePatternNode.NegativeNaming> value;
            HashSet antiNames;
            if (group3 == null) {
                for (ObjectName name : allNames) {
                    broadSubdiv.putValue((Object)name, null);
                }
                nSubdiv.add(null);
                continue;
            }
            if (group3.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group3.positiveChildren) {
                    for (ObjectName name : ((TreePatternNode.PositiveNaming)child.naming).getNames()) {
                        broadSubdiv.putValue((Object)name, child);
                    }
                }
            }
            LinkedHashSet sinks = ContainerUtil.newLinkedHashSet(TreePatternUtils.getSinkNames(group3));
            if (group3.negativeChild != null) {
                for (ObjectName sink : sinks) {
                    broadSubdiv.putValue((Object)sink, null);
                }
                antiNames = ContainerUtil.newHashSet((Object[])((TreePatternNode.NegativeNaming)group3.negativeChild.naming).getAntiNames());
                value = group3.negativeChild;
            } else {
                antiNames = sinks;
                value = null;
            }
            for (ObjectName name : allNames) {
                if (antiNames.contains(name)) continue;
                broadSubdiv.putValue((Object)name, value);
            }
            nSubdiv.add(value);
        }
        MultiMap multiMap = MultiMap.createLinkedSet();
        for (Map.Entry entry : broadSubdiv.entrySet()) {
            multiMap.putValue(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : multiMap.entrySet()) {
            pSubdiv.put((Object)new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)((Iterable)entry.getValue()))), (Collection)entry.getKey());
        }
        TreePatternNode.NegativeNaming negativeNaming = new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)broadSubdiv.keySet()));
        if (negativeNaming == null) {
            TreePatternUtils.$$$reportNull$$$0(11);
        }
        return negativeNaming;
    }

    @Nullable
    private static TreePatternNode.Group processGrouped(@NotNull ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> groups, @NotNull GroupedGroupFactory fac) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(12);
        }
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(13);
        }
        if (fac == null) {
            TreePatternUtils.$$$reportNull$$$0(14);
        }
        LinkedHashSet grouped = fac.mergeChildren() ? ContainerUtil.newLinkedHashSet(groups) : groups;
        MultiMap positive = fac.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
        SequencedCollection negative = fac.mergeChildren() ? ContainerUtil.newLinkedHashSet() : ContainerUtil.newSmartList();
        TreePatternNode.NegativeNaming negativeNaming = TreePatternUtils.subdivideChildren(grouped, positive, negative, fac.mergeChildren());
        return fac.create(positive, negativeNaming, negative, kind);
    }

    public static boolean isValid(TreePatternNode node) {
        HashSet kinds = ContainerUtil.newHashSet();
        for (TreePatternNode.Group group2 : node.groups) {
            if (kinds.add(group2.kind)) continue;
            return false;
        }
        return true;
    }

    public static void print(@NotNull StringBuilder builder, @NotNull TreePatternNode.Group group2, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(15);
        }
        if (group2 == null) {
            TreePatternUtils.$$$reportNull$$$0(16);
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("kind: ");
        builder.append(group2.kind).append("\n");
        JBIterable.of((Object[])group2.positiveChildren).append(group2.negativeChild).forEach(n -> {
            if (builder == null) {
                TreePatternUtils.$$$reportNull$$$0(64);
            }
            TreePatternUtils.print(builder, n, depth + 1);
        });
    }

    public static void print(@NotNull StringBuilder builder, @NotNull TreePatternNode<?> node, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(17);
        }
        if (node == null) {
            TreePatternUtils.$$$reportNull$$$0(18);
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("name: ").append(node.naming).append("\n");
        JBIterable.of((Object[])node.groups).forEach(n -> {
            if (builder == null) {
                TreePatternUtils.$$$reportNull$$$0(63);
            }
            TreePatternUtils.print(builder, n, depth + 1);
        });
    }

    private static TreePatternNode.Group[] preserve(@NotNull TreePatternNode.Group[] groups, boolean preserveOthers, @Nullable TreePatternNode.Group res, int pos) {
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(19);
        }
        if (pos == -1) {
            TreePatternNode.Group[] groupArray;
            if (preserveOthers) {
                groupArray = res == null ? groups : (TreePatternNode.Group[])ArrayUtil.append((Object[])groups, (Object)res);
            } else if (res == null) {
                groupArray = null;
            } else {
                TreePatternNode.Group[] groupArray2 = new TreePatternNode.Group[1];
                groupArray = groupArray2;
                groupArray2[0] = res;
            }
            return groupArray;
        }
        if (res == null) {
            return preserveOthers && groups.length != 1 ? (TreePatternNode.Group[])ArrayUtil.remove((Object[])groups, (int)pos) : null;
        }
        if (!preserveOthers) {
            return new TreePatternNode.Group[]{res};
        }
        TreePatternNode.Group[] clone = (TreePatternNode.Group[])groups.clone();
        clone[pos] = res;
        return clone;
    }

    @Nullable
    private static TreePatternNode.Group[] mask(@NotNull TreePatternNode.Group[] groups, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, int i2, boolean preserveOthers) {
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(20);
        }
        if (kinds == null) {
            TreePatternUtils.$$$reportNull$$$0(21);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(22);
        }
        if (i2 >= kinds.length) {
            return TreePatternNode.NO_GROUPS;
        }
        boolean wildcard = !mask[i2];
        int idx = -1;
        for (int k = 0; k < groups.length; ++k) {
            if (groups[k].kind != kinds[i2]) continue;
            idx = k;
            break;
        }
        if (idx == -1) {
            TreePatternNode.Group res = null;
            if (wildcard) {
                TreePatternNode.Group[] children = TreePatternUtils.mask(TreePatternNode.NO_GROUPS, kinds, mask, i2 + 1, preserveOthers);
                res = children == null ? null : new TreePatternNode.Group(kinds[i2], null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children));
            }
            return TreePatternUtils.preserve(groups, preserveOthers, res, -1);
        }
        TreePatternNode.Group group2 = groups[idx];
        if (!wildcard) {
            TreePatternNode.Group[] masked;
            MultiMap positive = MultiMap.createLinkedSet();
            if (group2.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group2.positiveChildren) {
                    TreePatternNode.Group[] masked2 = TreePatternUtils.mask(child.groups, kinds, mask, i2 + 1, preserveOthers);
                    if (masked2 == null) continue;
                    positive.putValue(new AW<TreePatternNode.Group>(masked2), child.naming);
                }
            }
            TreePatternNode<Object> negChild = null;
            if (group2.negativeChild != null && (masked = TreePatternUtils.mask(group2.negativeChild.groups, kinds, mask, i2 + 1, preserveOthers)) != null) {
                Collection removed = positive.remove(new AW<TreePatternNode.Group>(masked));
                if (removed != null) {
                    ArrayList names = ContainerUtil.newArrayList((Object[])((TreePatternNode.NegativeNaming)group2.negativeChild.naming).getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : removed) {
                        ContainerUtil.removeAll((Collection)names, (Object[])naming.getNames());
                    }
                    negChild = new TreePatternNode<TreePatternNode.NegativeNaming>(new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)names)), masked);
                } else {
                    negChild = new TreePatternNode(group2.negativeChild.naming, masked);
                }
            }
            TreePatternNode.Group result2 = null;
            if (negChild != null || !positive.isEmpty()) {
                TreePatternNode[] res;
                TreePatternNode[] treePatternNodeArray = res = positive.isEmpty() ? null : new TreePatternNode[positive.size()];
                if (res != null) {
                    int k = 0;
                    for (Map.Entry entry : positive.entrySet()) {
                        res[k] = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)JBIterable.from((Iterable)((Iterable)entry.getValue())).flatten(x -> JBIterable.of((Object[])x.getNames())))), (TreePatternNode.Group[])((AW)entry.getKey()).array);
                        ++k;
                    }
                }
                result2 = new TreePatternNode.Group(kinds[i2], res, negChild);
            }
            return TreePatternUtils.preserve(groups, preserveOthers, result2, idx);
        }
        LinkedHashSet res = ContainerUtil.newLinkedHashSet();
        for (TreePatternNode node : JBIterable.of((Object[])group2.positiveChildren).append(group2.negativeChild)) {
            TreePatternNode.Group[] grouped = TreePatternUtils.mask(node.groups, kinds, mask, i2 + 1, preserveOthers);
            if (grouped == null) continue;
            res.add(new TreePatternNode(node.naming, grouped));
        }
        TreePatternNode.Group[] merged = UNION_PROCESSOR.mergeRoots(res);
        TreePatternNode.Group result3 = merged == null ? null : new TreePatternNode.Group(kinds[i2], null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, merged));
        return TreePatternUtils.preserve(groups, preserveOthers, result3, idx);
    }

    @NotNull
    public static TreePattern union(TreePattern ... patterns) {
        if (patterns == null) {
            TreePatternUtils.$$$reportNull$$$0(23);
        }
        TreePattern treePattern = TreePatternUtils.union(Arrays.asList(patterns));
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(24);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern union(@NotNull Iterable<TreePattern> patterns) {
        if (patterns == null) {
            TreePatternUtils.$$$reportNull$$$0(25);
        }
        TreePattern treePattern = UNION_PROCESSOR.merge(patterns);
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(26);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern intersect(TreePattern ... patterns) {
        if (patterns == null) {
            TreePatternUtils.$$$reportNull$$$0(27);
        }
        TreePattern treePattern = INTERSECTION_PROCESSOR.merge((Iterable<TreePattern>)JBIterable.of((Object[])patterns));
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(28);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern minus(TreePattern ... patterns) {
        if (patterns == null) {
            TreePatternUtils.$$$reportNull$$$0(29);
        }
        TreePattern treePattern = MINUS_PROCESSOR.merge((Iterable<TreePattern>)JBIterable.of((Object[])patterns));
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(30);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern mask(@NotNull TreePattern pattern, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, boolean preserveOthers) {
        if (pattern == null) {
            TreePatternUtils.$$$reportNull$$$0(31);
        }
        if (kinds == null) {
            TreePatternUtils.$$$reportNull$$$0(32);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(33);
        }
        TreePattern treePattern = new TreePattern(TreePatternUtils.mask(pattern.root.groups, kinds, mask, 0, preserveOthers));
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(34);
        }
        return treePattern;
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable ObjectName name, @NotNull ObjectKind kind, TreePatternNode.Group ... children) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(35);
        }
        TreePatternNode.Group group2 = TreePatternUtils.create(name == null ? null : Collections.singletonList(name), kind, children);
        if (group2 == null) {
            TreePatternUtils.$$$reportNull$$$0(36);
        }
        return group2;
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable List<ObjectName> names, @NotNull ObjectKind kind, TreePatternNode.Group ... children) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(37);
        }
        TreePatternNode.Group group2 = TreePatternUtils.create(ObjectName.toArray(names), kind, children);
        if (group2 == null) {
            TreePatternUtils.$$$reportNull$$$0(38);
        }
        return group2;
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable ObjectName[] names, @NotNull ObjectKind kind, TreePatternNode.Group ... children) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(39);
        }
        if (children == null) {
            children = TreePatternNode.NO_GROUPS;
        }
        int nonNulls = 0;
        for (TreePatternNode.Group child : children) {
            if (child == null) continue;
            ++nonNulls;
        }
        if (nonNulls != children.length) {
            if (nonNulls == 0) {
                children = TreePatternNode.NO_GROUPS;
            } else {
                TreePatternNode.Group[] children2 = new TreePatternNode.Group[nonNulls];
                nonNulls = 0;
                for (TreePatternNode.Group child : children) {
                    if (child == null) continue;
                    children2[nonNulls++] = child;
                }
                children = children2;
            }
        }
        TreePatternNode.Group res = names == null ? new TreePatternNode.Group(kind, null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children)) : new TreePatternNode.Group(kind, new TreePatternNode[]{new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(names), children)}, null);
        TreePatternNode.Group group2 = res;
        if (group2 == null) {
            TreePatternUtils.$$$reportNull$$$0(40);
        }
        return group2;
    }

    @NotNull
    public static TreePattern patternProcessor(@NotNull TreePattern processed, @NotNull TreePattern mask, final @NotNull PatternProcessor processor) {
        TreePatternNode.Group[] newRoot;
        if (processed == null) {
            TreePatternUtils.$$$reportNull$$$0(41);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            TreePatternUtils.$$$reportNull$$$0(43);
        }
        TreePattern treePattern = (newRoot = new Object(){

            @Nullable
            public TreePatternNode.Group[] visit(@Nullable TreePatternNode<?> node, @Nullable TreePatternNode<?> checker, @Nullable TreePatternNode.BaseNaming parent, @Nullable ObjectKind parentKind) {
                TreePatternNode.Group processed;
                if (checker == null) {
                    return node == null ? null : node.groups;
                }
                NodeBuilder b = null;
                LinkedHashMap newGroups = ContainerUtil.newLinkedHashMap();
                for (TreePatternNode.Group group2 : checker.groups) {
                    newGroups.put(group2.kind, group2);
                }
                if (node != null) {
                    for (int i2 = 0; i2 < node.groups.length; ++i2) {
                        TreePatternNode.Group group3 = node.groups[i2];
                        newGroups.remove(group3.kind);
                        TreePatternNode.Group checkerGroup = checker.getGroup(group3.kind);
                        processed = group3;
                        if (checkerGroup != null) {
                            processed = this.visit(group3, checkerGroup, parent, parentKind);
                        }
                        if (processed != group3 && b == null) {
                            b = new NodeBuilder();
                            for (int k = 0; k < i2; ++k) {
                                b.addGroup(node.groups[k]);
                            }
                        }
                        if (b == null || processed == null) continue;
                        b.addGroup(processed);
                    }
                }
                Iterator iterator = newGroups.values().iterator();
                while (iterator.hasNext()) {
                    TreePatternNode.Group group4;
                    TreePatternNode.Group temp = new TreePatternNode.Group(group4.kind, null, null);
                    group4 = (TreePatternNode.Group)iterator.next();
                    processed = this.visit(temp, group4, parent, parentKind);
                    if (processed == temp || processed == null) continue;
                    if (b == null) {
                        b = NodeBuilder.from(node);
                    }
                    b.addGroup(processed);
                }
                return b == null ? (node == null ? null : node.groups) : b.buildGroupsOpt();
            }

            @Nullable
            public TreePatternNode.Group visit(@NotNull TreePatternNode.Group group2, @NotNull TreePatternNode.Group checker, @Nullable TreePatternNode.BaseNaming parent, @Nullable ObjectKind parentKind) {
                TreePatternNode n2;
                TreePatternNode.Group procRes;
                if (group2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (checker == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((procRes = processor.process(group2, parent, parentKind)) == SKIP_PROCESSING) {
                    return group2;
                }
                if (procRes == null) {
                    return null;
                }
                group2 = procRes;
                MultiMap gluedPositive = MultiMap.createLinked();
                MultiMap p = MultiMap.createLinked();
                List n = ContainerUtil.newSmartList();
                TreePatternNode.NegativeNaming negativeNaming = TreePatternUtils.subdivideChildren((Iterable<TreePatternNode.Group>)JBIterable.of((Object[])new TreePatternNode.Group[]{group2, checker}), p, n, false);
                for (Map.Entry entry : p.entrySet()) {
                    Iterator it = ((Collection)entry.getValue()).iterator();
                    TreePatternNode p1 = (TreePatternNode)it.next();
                    TreePatternNode p2 = (TreePatternNode)it.next();
                    TreePatternNode.Group[] processed = this.visit(p1, p2, (TreePatternNode.BaseNaming)entry.getKey(), group2.kind);
                    gluedPositive.putValue(new AW<TreePatternNode.Group>(processed), entry.getKey());
                }
                Iterator it = n.iterator();
                TreePatternNode n1 = (TreePatternNode)it.next();
                TreePatternNode.Group[] processedNegative = this.visit(n1, n2 = (TreePatternNode)it.next(), (TreePatternNode.BaseNaming)negativeNaming, group2.kind);
                Collection extra = gluedPositive.remove(new AW<TreePatternNode.Group>(processedNegative));
                if (extra != null) {
                    LinkedHashSet names = ContainerUtil.newLinkedHashSet((Object[])negativeNaming.getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : extra) {
                        ContainerUtil.removeAll((Collection)names, (Object[])naming.getNames());
                    }
                    negativeNaming = new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)names));
                }
                return this.createNewIfChanged(group2, (MultiMap<AW<TreePatternNode.Group>, TreePatternNode.PositiveNaming>)gluedPositive, processedNegative, negativeNaming);
            }

            private TreePatternNode.Group createNewIfChanged(@NotNull TreePatternNode.Group group2, @NotNull MultiMap<AW<TreePatternNode.Group>, TreePatternNode.PositiveNaming> positive, @Nullable TreePatternNode.Group[] negative, @NotNull TreePatternNode.NegativeNaming negativeNaming) {
                if (group2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (positive == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (negativeNaming == null) {
                    4.$$$reportNull$$$0(4);
                }
                HashMap pool = ContainerUtil.newHashMap();
                if (group2.positiveChildren != null) {
                    for (TreePatternNode<TreePatternNode.PositiveNaming> child : group2.positiveChildren) {
                        pool.put(child.naming, child);
                    }
                }
                boolean changed = false;
                GroupBuilder builder = new GroupBuilder();
                if (negative != null) {
                    if (group2.negativeChild != null && negativeNaming.equals(group2.negativeChild.naming) && Arrays.equals(group2.negativeChild.groups, negative)) {
                        builder.negative = group2.negativeChild;
                    } else {
                        changed = true;
                        builder.negative = new TreePatternNode<TreePatternNode.NegativeNaming>(negativeNaming, negative);
                    }
                } else {
                    changed = group2.negativeChild != null;
                }
                changed |= pool.size() != positive.size();
                for (Map.Entry entry : positive.entrySet()) {
                    List names = ContainerUtil.newSmartList();
                    for (TreePatternNode.PositiveNaming naming : (Collection)entry.getValue()) {
                        ContainerUtil.addAll((Collection)names, (Object[])naming.getNames());
                    }
                    TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)names));
                    TreePatternNode node = (TreePatternNode)pool.get(naming);
                    if (node == null || node.groups != ((AW)entry.getKey()).array) {
                        changed = true;
                        node = ((AW)entry.getKey()).array == null ? null : new TreePatternNode<TreePatternNode.PositiveNaming>(naming, (TreePatternNode.Group[])((AW)entry.getKey()).array);
                    }
                    ContainerUtil.addIfNotNull(builder.positives, (Object)node);
                }
                return changed ? builder.build(group2.kind) : group2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "checker";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "positive";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "negativeNaming";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/dialects/TreePatternUtils$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createNewIfChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(processed.root, mask.root, null, null)) == processed.root.groups ? processed : new TreePattern(newRoot);
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(44);
        }
        return treePattern;
    }

    public static boolean isWildcard(@Nullable TreePatternNode.Group g) {
        return g != null && g.positiveChildren == null && TreePatternUtils.isWildcard(g.negativeChild);
    }

    public static boolean isWildcard(@Nullable TreePatternNode<?> n) {
        return n != null && ((TreePatternNode.BaseNaming)n.naming).names.length == 0 && n.groups.length == 0;
    }

    @NotNull
    public static TreePattern sorted(@NotNull TreePattern pattern) {
        TreePatternNode<TreePatternNode.NegativeNaming> sortedRoot;
        if (pattern == null) {
            TreePatternUtils.$$$reportNull$$$0(45);
        }
        TreePattern treePattern = (sortedRoot = TreePatternUtils.sorted(pattern.root)) == pattern.root ? pattern : new TreePattern(sortedRoot);
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(46);
        }
        return treePattern;
    }

    @NotNull
    private static <N extends TreePatternNode.BaseNaming> TreePatternNode<N> sorted(@NotNull TreePatternNode<N> node) {
        if (node == null) {
            TreePatternUtils.$$$reportNull$$$0(47);
        }
        TreePatternNode.Group[] newGroups = TreePatternUtils.sorted(node.groups, TreePatternNode.Group.BY_KIND);
        Object naming = TreePatternUtils.sorted(node.naming);
        TreePatternNode<N> treePatternNode = newGroups == node.groups && naming == node.naming ? node : new TreePatternNode<N>(naming, newGroups);
        if (treePatternNode == null) {
            TreePatternUtils.$$$reportNull$$$0(48);
        }
        return treePatternNode;
    }

    @NotNull
    private static <T> T[] sorted(T[] items, Comparator comp) {
        Object[] newItems = null;
        boolean unsorted = false;
        for (int i2 = 0; i2 < items.length; ++i2) {
            Object newItem;
            Object object = newItem = items[i2] instanceof TreePatternNode.Group ? TreePatternUtils.sorted((TreePatternNode.Group)items[i2]) : TreePatternUtils.sorted((TreePatternNode)items[i2]);
            if (!unsorted && i2 != 0) {
                boolean bl = unsorted = comp.compare(items[i2 - 1], items[i2]) > 0;
            }
            if (newItems == null) {
                if (newItem == items[i2] && !unsorted) continue;
                newItems = (Object[])Array.newInstance(items[i2].getClass(), items.length);
                System.arraycopy(items, 0, newItems, 0, i2);
            }
            newItems[i2] = newItem;
        }
        if (unsorted) {
            Arrays.sort(newItems, comp);
        }
        Object[] objectArray = newItems == null ? items : newItems;
        if (objectArray == null) {
            TreePatternUtils.$$$reportNull$$$0(49);
        }
        return objectArray;
    }

    @NotNull
    private static TreePatternNode.NegativeNaming merge(@NotNull TreePatternNode.NegativeNaming neg, @NotNull Iterable<TreePatternNode.PositiveNaming> pos) {
        if (neg == null) {
            TreePatternUtils.$$$reportNull$$$0(50);
        }
        if (pos == null) {
            TreePatternUtils.$$$reportNull$$$0(51);
        }
        LinkedHashSet names = null;
        for (TreePatternNode.PositiveNaming naming : pos) {
            if (names == null) {
                names = ContainerUtil.newLinkedHashSet((Object[])neg.getAntiNames());
            }
            ContainerUtil.removeAll((Collection)names, (Object[])naming.names);
        }
        TreePatternNode.NegativeNaming negativeNaming = names == null ? neg : new TreePatternNode.NegativeNaming(ObjectName.toArray(names));
        if (negativeNaming == null) {
            TreePatternUtils.$$$reportNull$$$0(52);
        }
        return negativeNaming;
    }

    @Nullable
    private static TreePatternNode.PositiveNaming merge(@NotNull Iterable<TreePatternNode.PositiveNaming> pos) {
        if (pos == null) {
            TreePatternUtils.$$$reportNull$$$0(53);
        }
        LinkedHashSet names = null;
        TreePatternNode.PositiveNaming first = null;
        for (TreePatternNode.PositiveNaming naming : pos) {
            if (first == null) {
                first = naming;
                continue;
            }
            if (names == null) {
                names = ContainerUtil.newLinkedHashSet((Object[])first.names);
            }
            ContainerUtil.addAll((Collection)names, (Object[])naming.names);
        }
        if (names == null) {
            return first;
        }
        Object[] res = ObjectName.toArray(names);
        Arrays.sort(res);
        return new TreePatternNode.PositiveNaming((ObjectName[])res);
    }

    @NotNull
    private static TreePatternNode.Group sorted(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            TreePatternUtils.$$$reportNull$$$0(54);
        }
        Pair<TreePatternNode<TreePatternNode.NegativeNaming>, TreePatternNode<TreePatternNode.PositiveNaming>[]> nodes2 = Pair.create(g.negativeChild == null ? null : TreePatternUtils.sorted(g.negativeChild), g.positiveChildren == null ? null : TreePatternUtils.sorted(g.positiveChildren, TreePatternNode.BY_FIRST));
        nodes2 = TreePatternUtils.tighten((TreePatternNode)nodes2.first, (TreePatternNode[])nodes2.second);
        TreePatternNode.Group group2 = nodes2.first == g.negativeChild && nodes2.second == g.positiveChildren ? g : new TreePatternNode.Group(g.kind, (TreePatternNode[])nodes2.second, (TreePatternNode)nodes2.first);
        if (group2 == null) {
            TreePatternUtils.$$$reportNull$$$0(55);
        }
        return group2;
    }

    @NotNull
    private static Pair<TreePatternNode<TreePatternNode.NegativeNaming>, TreePatternNode<TreePatternNode.PositiveNaming>[]> tighten(@Nullable TreePatternNode<TreePatternNode.NegativeNaming> n, @Nullable TreePatternNode<TreePatternNode.PositiveNaming>[] p) {
        Collection nodes2;
        if (p == null) {
            Pair pair = Pair.create(n, null);
            if (pair == null) {
                TreePatternUtils.$$$reportNull$$$0(56);
            }
            return pair;
        }
        MultiMap grouping = MultiMap.createLinked();
        for (TreePatternNode<TreePatternNode.PositiveNaming> node2 : p) {
            grouping.putValue(new AW<TreePatternNode.Group>(node2.groups), node2);
        }
        if (n != null && (nodes2 = grouping.remove(new AW<TreePatternNode.Group>(n.groups))) != null) {
            n = new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternUtils.merge((TreePatternNode.NegativeNaming)n.naming, (Iterable<TreePatternNode.PositiveNaming>)JBIterable.from((Iterable)nodes2).transform(node -> (TreePatternNode.PositiveNaming)node.naming)), n.groups);
        }
        if (p.length == grouping.size()) {
            Pair pair = Pair.create(n, p);
            if (pair == null) {
                TreePatternUtils.$$$reportNull$$$0(57);
            }
            return pair;
        }
        if (grouping.isEmpty()) {
            Pair pair = Pair.create(n, null);
            if (pair == null) {
                TreePatternUtils.$$$reportNull$$$0(58);
            }
            return pair;
        }
        ArrayList pos = ContainerUtil.newArrayListWithCapacity((int)grouping.size());
        for (Map.Entry entry : grouping.entrySet()) {
            if (((Collection)entry.getValue()).size() == 1) {
                pos.add(ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())));
                continue;
            }
            TreePatternNode.PositiveNaming naming = TreePatternUtils.merge((Iterable<TreePatternNode.PositiveNaming>)JBIterable.from((Iterable)((Iterable)entry.getValue())).transform(node -> (TreePatternNode.PositiveNaming)node.naming));
            if (naming == null) continue;
            pos.add(new TreePatternNode<TreePatternNode.PositiveNaming>(naming, (TreePatternNode.Group[])ObjectUtils.assertNotNull(((AW)entry.getKey()).array)));
        }
        p = pos.toArray(new TreePatternNode[0]);
        Pair pair = Pair.create(n, p);
        if (pair == null) {
            TreePatternUtils.$$$reportNull$$$0(59);
        }
        return pair;
    }

    @NotNull
    private static <N extends TreePatternNode.BaseNaming> N sorted(@NotNull N naming) {
        if (naming == null) {
            TreePatternUtils.$$$reportNull$$$0(60);
        }
        boolean unsorted = false;
        ObjectName[] names = naming.names;
        int s = names.length;
        for (int i2 = 1; i2 < s && !unsorted; ++i2) {
            unsorted = names[i2 - 1].compareTo(names[i2]) > 0;
        }
        if (!unsorted) {
            N n = naming;
            if (n == null) {
                TreePatternUtils.$$$reportNull$$$0(61);
            }
            return n;
        }
        Object[] newNames = new ObjectName[names.length];
        System.arraycopy(names, 0, newNames, 0, names.length);
        Arrays.sort(newNames);
        TreePatternNode.BaseNaming baseNaming = naming instanceof TreePatternNode.NegativeNaming ? new TreePatternNode.NegativeNaming((ObjectName[])newNames) : new TreePatternNode.PositiveNaming((ObjectName[])newNames);
        if (baseNaming == null) {
            TreePatternUtils.$$$reportNull$$$0(62);
        }
        return (N)baseNaming;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/TreePatternUtils";
                break;
            }
            case 4: 
            case 5: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 8: 
            case 13: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pSubdiv";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nSubdiv";
                break;
            }
            case 12: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fac";
                break;
            }
            case 15: 
            case 17: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 18: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 21: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 22: 
            case 33: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mask";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 31: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "neg";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "naming";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/TreePatternUtils";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringArray";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSinkNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "subdivideChildren";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "intersect";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "mask";
                break;
            }
            case 36: 
            case 38: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "patternProcessor";
                break;
            }
            case 46: 
            case 48: 
            case 49: 
            case 55: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "tighten";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toStringArray";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSinkNames";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "subdivideChildren";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processGrouped";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "preserve";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "mask";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 35: 
            case 37: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "patternProcessor";
                break;
            }
            case 45: 
            case 47: 
            case 54: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 50: 
            case 51: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$print$2";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$print$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PatternProcessor {
        @Nullable
        public TreePatternNode.Group process(@NotNull TreePatternNode.Group var1, @Nullable TreePatternNode.BaseNaming var2, @Nullable ObjectKind var3);
    }

    public static class NodeBuilder {
        public final List<TreePatternNode.Group> groups = ContainerUtil.newSmartList();

        public NodeBuilder addGroup(@Nullable TreePatternNode.Group g) {
            if (g != null) {
                this.groups.add(g);
            }
            return this;
        }

        @NotNull
        public <T extends TreePatternNode.BaseNaming> TreePatternNode<T> build(T naming) {
            TreePatternNode<T> treePatternNode = new TreePatternNode<T>(naming, this.buildGroups());
            if (treePatternNode == null) {
                NodeBuilder.$$$reportNull$$$0(0);
            }
            return treePatternNode;
        }

        @Nullable
        public TreePatternNode.Group[] buildGroupsOpt() {
            return this.groups.isEmpty() ? null : this.groups.toArray(new TreePatternNode.Group[0]);
        }

        @NotNull
        public TreePatternNode.Group[] buildGroups() {
            TreePatternNode.Group[] groupArray = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)this.buildGroupsOpt(), (Object)TreePatternNode.NO_GROUPS);
            if (groupArray == null) {
                NodeBuilder.$$$reportNull$$$0(1);
            }
            return groupArray;
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode<?> node) {
            NodeBuilder nodeBuilder = NodeBuilder.from(node == null ? null : node.groups);
            if (nodeBuilder == null) {
                NodeBuilder.$$$reportNull$$$0(2);
            }
            return nodeBuilder;
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode.Group[] groups) {
            NodeBuilder b = new NodeBuilder();
            if (groups != null) {
                ContainerUtil.addAll(b.groups, (Object[])groups);
            }
            NodeBuilder nodeBuilder = b;
            if (nodeBuilder == null) {
                NodeBuilder.$$$reportNull$$$0(3);
            }
            return nodeBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/dialects/TreePatternUtils$NodeBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildGroups";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class GroupBuilder {
        public final List<TreePatternNode<TreePatternNode.PositiveNaming>> positives = ContainerUtil.newSmartList();
        public TreePatternNode<TreePatternNode.NegativeNaming> negative = null;

        @Nullable
        public TreePatternNode.Group build(@NotNull ObjectKind kind) {
            if (kind == null) {
                GroupBuilder.$$$reportNull$$$0(0);
            }
            TreePatternNode[] p = this.positives.isEmpty() ? null : this.positives.toArray(new TreePatternNode[0]);
            return p == null && this.negative == null ? null : new TreePatternNode.Group(kind, p, this.negative);
        }

        @NotNull
        public static GroupBuilder from(@Nullable TreePatternNode.Group g) {
            GroupBuilder builder = new GroupBuilder();
            if (g != null) {
                if (g.positiveChildren != null) {
                    ContainerUtil.addAll(builder.positives, (Object[])g.positiveChildren);
                }
                builder.negative = g.negativeChild;
            }
            GroupBuilder groupBuilder = builder;
            if (groupBuilder == null) {
                GroupBuilder.$$$reportNull$$$0(1);
            }
            return groupBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/TreePatternUtils$GroupBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/TreePatternUtils$GroupBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class GroupedGroupFactory {
        @Nullable
        public TreePatternNode.Group create(@NotNull MultiMap<TreePatternNode.PositiveNaming, TreePatternNode<?>> p, @NotNull TreePatternNode.NegativeNaming nn, @NotNull Iterable<TreePatternNode<?>> n, ObjectKind kind) {
            TreePatternNode[] positive;
            if (p == null) {
                GroupedGroupFactory.$$$reportNull$$$0(0);
            }
            if (nn == null) {
                GroupedGroupFactory.$$$reportNull$$$0(1);
            }
            if (n == null) {
                GroupedGroupFactory.$$$reportNull$$$0(2);
            }
            MultiMap mergedBranches = MultiMap.createLinkedSet();
            for (Map.Entry entry : p.entrySet()) {
                TreePatternNode.Group[] merged = this.mergeNodes((TreePatternNode.BaseNaming)entry.getKey(), kind, (Iterable)entry.getValue());
                if (merged == null) continue;
                mergedBranches.putValue(new AW<TreePatternNode.Group>(merged), entry.getKey());
            }
            TreePatternNode.Group[] negGroups = this.mergeNodes(nn, kind, n);
            if (mergedBranches.isEmpty() && negGroups == null) {
                return null;
            }
            TreePatternNode<TreePatternNode.NegativeNaming> negative = null;
            if (negGroups != null) {
                Collection namings = mergedBranches.remove(new AW<TreePatternNode.Group>(negGroups));
                if (namings != null) {
                    ArrayList antiNames = ContainerUtil.newArrayList((Object[])nn.getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : namings) {
                        ContainerUtil.removeAll((Collection)antiNames, (Object[])naming.getNames());
                    }
                    negative = new TreePatternNode<TreePatternNode.NegativeNaming>(new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)antiNames)), negGroups);
                } else {
                    negative = new TreePatternNode<TreePatternNode.NegativeNaming>(nn, negGroups);
                }
            }
            TreePatternNode[] treePatternNodeArray = positive = mergedBranches.isEmpty() ? null : new TreePatternNode[mergedBranches.size()];
            if (positive != null) {
                int i2 = 0;
                for (Map.Entry entry : mergedBranches.entrySet()) {
                    List names = ContainerUtil.newSmartList();
                    ((Collection)entry.getValue()).forEach(x -> {
                        List cfr_ignored_0 = (List)ContainerUtil.addAll((Collection)names, (Object[])x.getNames());
                    });
                    positive[i2] = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)names)), (TreePatternNode.Group[])((AW)entry.getKey()).array);
                    ++i2;
                }
            }
            return new TreePatternNode.Group(kind, positive, negative);
        }

        @Nullable
        public TreePatternNode.Group[] mergeNodes(@Nullable TreePatternNode.BaseNaming naming, @Nullable ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> nodes2) {
            if (nodes2 == null) {
                GroupedGroupFactory.$$$reportNull$$$0(3);
            }
            this.enter(naming, kind, nodes2);
            if (!this.checkNode(naming, kind, nodes2)) {
                this.leave(naming, kind, nodes2);
                return null;
            }
            MultiMap grouped = this.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
            LinkedHashSet allKinds = ContainerUtil.newLinkedHashSet();
            for (TreePatternNode<?> node : nodes2) {
                if (node == null) continue;
                for (TreePatternNode.Group group2 : node.groups) {
                    allKinds.add(group2.kind);
                }
            }
            for (TreePatternNode<?> node : nodes2) {
                HashSet currentKinds = null;
                if (node != null) {
                    currentKinds = ContainerUtil.newHashSet();
                    for (TreePatternNode.Group group3 : node.groups) {
                        grouped.putValue((Object)group3.kind, (Object)group3);
                        currentKinds.add(group3.kind);
                    }
                }
                for (ObjectKind gkind : allKinds) {
                    if (currentKinds != null && currentKinds.contains(gkind)) continue;
                    grouped.putValue((Object)gkind, null);
                }
            }
            List res = ContainerUtil.newSmartList();
            for (Map.Entry entry : grouped.entrySet()) {
                this.enterGroups(naming, kind, (Iterable)entry.getValue());
                if (this.checkGroup(naming, kind, (Iterable)entry.getValue())) {
                    ContainerUtil.addAllNotNull((Collection)res, (Object[])new TreePatternNode.Group[]{TreePatternUtils.processGrouped((ObjectKind)entry.getKey(), (Iterable)entry.getValue(), this)});
                }
                this.leaveGroups(naming, kind, (Iterable)entry.getValue());
            }
            TreePatternNode.Group[] merged = !res.isEmpty() ? res.toArray(new TreePatternNode.Group[0]) : (this.willDestroyEmpty(naming, kind, nodes2) ? null : TreePatternNode.NO_GROUPS);
            this.leave(naming, kind, nodes2);
            return merged;
        }

        @NotNull
        public TreePattern merge(@NotNull Iterable<TreePattern> patterns) {
            TreePatternNode.Group[] groups;
            if (patterns == null) {
                GroupedGroupFactory.$$$reportNull$$$0(4);
            }
            TreePattern treePattern = (groups = this.mergeRoots((Iterable<TreePatternNode<?>>)JBIterable.from(patterns).transform(p -> p.root))) == null ? TreePattern.EMPTY : new TreePattern(groups);
            if (treePattern == null) {
                GroupedGroupFactory.$$$reportNull$$$0(5);
            }
            return treePattern;
        }

        @Nullable
        public TreePatternNode.Group[] mergeRoots(@NotNull Iterable<TreePatternNode<?>> nodes2) {
            if (nodes2 == null) {
                GroupedGroupFactory.$$$reportNull$$$0(6);
            }
            return this.mergeNodes(TreePatternNode.NegativeNaming.WILDCARD, ObjectKind.NONE, nodes2);
        }

        @Nullable
        public TreePatternNode.Group mergeGroups(@NotNull ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> groups) {
            if (kind == null) {
                GroupedGroupFactory.$$$reportNull$$$0(7);
            }
            if (groups == null) {
                GroupedGroupFactory.$$$reportNull$$$0(8);
            }
            return TreePatternUtils.processGrouped(kind, groups, this);
        }

        protected abstract boolean checkGroup(TreePatternNode.BaseNaming var1, ObjectKind var2, @NotNull Iterable<TreePatternNode.Group> var3);

        protected abstract boolean checkNode(TreePatternNode.BaseNaming var1, ObjectKind var2, @NotNull Iterable<TreePatternNode<?>> var3);

        protected abstract boolean willDestroyEmpty(TreePatternNode.BaseNaming var1, ObjectKind var2, Iterable<TreePatternNode<?>> var3);

        protected void enter(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> nodes2) {
        }

        protected void leave(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> nodes2) {
        }

        protected void enterGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
        }

        protected void leaveGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
        }

        public boolean mergeChildren() {
            return true;
        }

        protected static boolean containsNull(Iterable it) {
            if (it instanceof Collection) {
                return ((Collection)it).contains(null);
            }
            for (Object o : it) {
                if (o != null) continue;
                return true;
            }
            return false;
        }

        protected static boolean containsNotNull(Iterable it) {
            for (Object o : it) {
                if (o == null) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nn";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groups";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeNodes";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeRoots";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeGroups";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class AW<T> {
        public final T[] array;
        private Integer myHashCode;

        public AW(@Nullable T[] array) {
            this.array = array;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AW aw = (AW)o;
            return Arrays.equals(this.array, aw.array);
        }

        public int hashCode() {
            if (this.myHashCode != null) {
                return this.myHashCode;
            }
            this.myHashCode = Arrays.hashCode(this.array);
            return this.myHashCode;
        }
    }
}

