/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.util.containers.ContainerUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreePatternSerialization {
    private static final Logger LOG = Logger.getInstance(TreePatternSerialization.class);

    public static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePattern pattern) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            TreePatternSerialization.$$$reportNull$$$0(1);
        }
        if (pattern.root != null && pattern.root.groups.length != 0) {
            TreePatternSerialization.serialize(writer, pattern.root);
        }
    }

    @Nullable
    public static TreePattern deserialize(@NotNull HierarchicalStreamReader reader) {
        TreePatternNode<TreePatternNode.NegativeNaming> node;
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(2);
        }
        return (node = TreePatternSerialization.deserializeNode(reader, TreePatternNode.NegativeNaming.class)) == null ? null : new TreePattern(node);
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode<?> node) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(3);
        }
        if (node == null) {
            TreePatternSerialization.$$$reportNull$$$0(4);
        }
        writer.startNode("node");
        if (node.naming instanceof TreePatternNode.NegativeNaming) {
            writer.addAttribute("negative", "1");
        }
        for (ObjectName objectName : ((TreePatternNode.BaseNaming)node.naming).names) {
            TreePatternSerialization.serialize(writer, objectName);
        }
        for (TreePatternNode.Group group2 : node.groups) {
            TreePatternSerialization.serialize(writer, group2);
        }
        writer.endNode();
    }

    @Nullable
    private static <T extends TreePatternNode.BaseNaming> TreePatternNode<T> deserializeNode(@NotNull HierarchicalStreamReader reader, Class<T> namingClass) {
        boolean neg2;
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(5);
        }
        if (!"node".equals(reader.getNodeName())) {
            return null;
        }
        boolean neg1 = "1".equals(reader.getAttribute("negative"));
        boolean bl = neg2 = namingClass == TreePatternNode.NegativeNaming.class;
        if (neg1 != neg2) {
            LOG.warn("Unexpected naming type");
            return null;
        }
        List names = ContainerUtil.newSmartList();
        List groups = ContainerUtil.newSmartList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String tag = reader.getNodeName();
            if ("name".equals(tag)) {
                ObjectName name = TreePatternSerialization.deserializeName(reader);
                if (name == null) {
                    return null;
                }
                names.add(name);
            } else if ("group".equals(tag)) {
                TreePatternNode.Group group2 = TreePatternSerialization.deserializeGroup(reader);
                if (group2 == null) {
                    return null;
                }
                groups.add(group2);
            }
            reader.moveUp();
        }
        T naming = TreePatternSerialization.instantiateNaming(namingClass, names);
        return new TreePatternNode<T>(naming, groups.toArray(new TreePatternNode.Group[0]));
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode.Group group2) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(6);
        }
        if (group2 == null) {
            TreePatternSerialization.$$$reportNull$$$0(7);
        }
        writer.startNode("group");
        writer.addAttribute("kind", group2.kind.code());
        if (group2.negativeChild != null) {
            TreePatternSerialization.serialize(writer, group2.negativeChild);
        }
        if (group2.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : group2.positiveChildren) {
                TreePatternSerialization.serialize(writer, child);
            }
        }
        writer.endNode();
    }

    @Nullable
    private static TreePatternNode.Group deserializeGroup(@NotNull HierarchicalStreamReader reader) {
        String code;
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(8);
        }
        if ((code = reader.getAttribute("kind")) == null) {
            return null;
        }
        ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(code);
        if (kind == null && "data-source".equals(code)) {
            kind = SqlImportUtil.DATA_SOURCE;
        }
        if (kind == null) {
            LOG.warn("Unable to find kind: " + code);
            return null;
        }
        TreePatternNode<TreePatternNode.NegativeNaming> n = null;
        List p = ContainerUtil.newSmartList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("node".equals(reader.getNodeName())) {
                boolean neg = "1".equals(reader.getAttribute("negative"));
                if (neg) {
                    if (n != null) {
                        LOG.warn("Unexpected second negative naming");
                        return null;
                    }
                    n = TreePatternSerialization.deserializeNode(reader, TreePatternNode.NegativeNaming.class);
                    if (n == null) {
                        return null;
                    }
                } else {
                    TreePatternNode<TreePatternNode.PositiveNaming> node = TreePatternSerialization.deserializeNode(reader, TreePatternNode.PositiveNaming.class);
                    if (node == null) {
                        return null;
                    }
                    p.add(node);
                }
            }
            reader.moveUp();
        }
        return new TreePatternNode.Group(kind, p.isEmpty() ? null : p.toArray(new TreePatternNode[0]), n);
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull ObjectName name) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(9);
        }
        if (name == null) {
            TreePatternSerialization.$$$reportNull$$$0(10);
        }
        writer.startNode("name");
        writer.addAttribute("name", name.name);
        if (name.quoted) {
            writer.addAttribute("quoted", "1");
        }
        writer.endNode();
    }

    @Nullable
    private static ObjectName deserializeName(HierarchicalStreamReader reader) {
        String name = reader.getAttribute("name");
        if (name == null) {
            return null;
        }
        boolean quoted = "1".equals(reader.getAttribute("quoted"));
        return new ObjectName(name, quoted);
    }

    @NotNull
    private static <T extends TreePatternNode.BaseNaming> T instantiateNaming(@NotNull Class<T> namingClass, List<ObjectName> names) {
        if (namingClass == null) {
            TreePatternSerialization.$$$reportNull$$$0(11);
        }
        if (namingClass == TreePatternNode.NegativeNaming.class) {
            TreePatternNode.NegativeNaming negativeNaming = new TreePatternNode.NegativeNaming(ObjectName.toArray(names));
            if (negativeNaming == null) {
                TreePatternSerialization.$$$reportNull$$$0(12);
            }
            return (T)negativeNaming;
        }
        if (namingClass == TreePatternNode.PositiveNaming.class) {
            TreePatternNode.PositiveNaming positiveNaming = new TreePatternNode.PositiveNaming(ObjectName.toArray(names));
            if (positiveNaming == null) {
                TreePatternSerialization.$$$reportNull$$$0(13);
            }
            return (T)positiveNaming;
        }
        throw new AssertionError((Object)("Unexpected " + namingClass.getSimpleName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingClass";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/TreePatternSerialization";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/TreePatternSerialization";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateNaming";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserializeNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserializeGroup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "instantiateNaming";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

