/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.SchemaEditorHelper;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.ConfigurableDdlGenerator;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreviewBase;
import com.intellij.database.view.ui.ErrorNotificationWrapperPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbOperationDialog
extends DialogWrapper {
    private final DdlPreviewBase myPreview;
    private final DatabaseEditorContext myContext;
    private Processor<SchemaEditorHelper> myGenerator;
    private final List<ConfigurableDdlGenerator.OptionValue<?>> myOptions;
    private final SchemaExportHelper myExportHelper;
    private ErrorNotificationWrapperPanel myErrorNotificationWrapperPanel;
    private static final int OP_COLUMNS = 3;

    public DbOperationDialog(@NotNull DatabaseEditorContext context, @NotNull List<ConfigurableDdlGenerator.OptionValue<?>> options) {
        if (context == null) {
            DbOperationDialog.$$$reportNull$$$0(0);
        }
        if (options == null) {
            DbOperationDialog.$$$reportNull$$$0(1);
        }
        super(context.getProject());
        this.myContext = context;
        this.myOptions = options;
        this.myPreview = new DdlPreviewBase(this.myContext, DatabaseDialogsHelper.createAsyncProcessor((Project)ObjectUtils.assertNotNull((Object)this.myContext.getProject()), "Fetching DDL", this::updatePreview));
        this.myExportHelper = this.myContext.getDialect().getSchemaEditor().createExportHelper(this.myContext, this.myContext.getModel());
        this.init();
    }

    public void setGenerator(@NotNull PairProcessor<SchemaEditorHelper, Iterable<ConfigurableDdlGenerator.OptionValue<?>>> generator) {
        if (generator == null) {
            DbOperationDialog.$$$reportNull$$$0(2);
        }
        this.myGenerator = helper -> {
            if (generator == null) {
                DbOperationDialog.$$$reportNull$$$0(18);
            }
            return generator.process(helper, this.myOptions);
        };
        this.updatePreview();
    }

    protected void updatePreview() {
        this.myPreview.updatePreview(this.myGenerator, this.myExportHelper.getModel());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myPreview.getComponent(), "Center");
        if (!this.myOptions.isEmpty()) {
            panel.add((Component)new OptionEditorPanel(), "South");
        }
        this.myErrorNotificationWrapperPanel = new ErrorNotificationWrapperPanel();
        this.myErrorNotificationWrapperPanel.add((Component)panel, "Center");
        return this.myErrorNotificationWrapperPanel;
    }

    protected void doOKAction() {
        DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler((DbDataSource)ObjectUtils.assertNotNull((Object)this.myContext.getDataSource()), this.myContext.getSearchPath());
        handler.setStatement(this.myPreview.getPreviewText());
        handler.runStatements(true).whenCompleteAsync((r, e) -> {
            if (e != null) {
                AsyncUtil.addUnhandledError(handler.getErrorHandler(), e, handler.getDataSource().getName(), DbImplUtil.getDatabaseDialect((DbElement)handler.getDataSource()).getFamilyId());
                this.myErrorNotificationWrapperPanel.reportError(handler.getErrorHandler().getSummary("Cancelled"));
            } else {
                this.close(0);
            }
        }, AsyncUtil.EDT_EXECUTOR);
    }

    private static int getNumRows(int size) {
        return (int)Math.ceil((double)size / 3.0);
    }

    public static List<ConfigurableDdlGenerator.OptionValue<?>> getDefaults(@NotNull DdlOperations operations, DdlOperation ... ops) {
        if (operations == null) {
            DbOperationDialog.$$$reportNull$$$0(3);
        }
        if (ops == null) {
            DbOperationDialog.$$$reportNull$$$0(4);
        }
        return JBIterable.of((Object[])ops).flatten(operation -> {
            ConfigurableDdlGenerator generator;
            if (operations == null) {
                DbOperationDialog.$$$reportNull$$$0(17);
            }
            if ((generator = (ConfigurableDdlGenerator)ObjectUtils.tryCast(operations.get((DdlOperation)operation), ConfigurableDdlGenerator.class)) == null) {
                return JBIterable.empty();
            }
            return JBIterable.of((Object[])generator.getOptions());
        }).transform(option -> ConfigurableDdlGenerator.OptionValue.defaultOf(option)).toList();
    }

    @NotNull
    public static PairProcessor<SchemaEditorHelper, Iterable<ConfigurableDdlGenerator.OptionValue<?>>> createGenerator(@NotNull DbOperationDialog dialog, @NotNull Iterable<? extends DasObject> objects, DdlOperation ... ops) {
        if (dialog == null) {
            DbOperationDialog.$$$reportNull$$$0(5);
        }
        if (objects == null) {
            DbOperationDialog.$$$reportNull$$$0(6);
        }
        if (ops == null) {
            DbOperationDialog.$$$reportNull$$$0(7);
        }
        ArrayList exported = ContainerUtil.newArrayList();
        JBIterable.from(objects).transform(object -> {
            if (dialog == null) {
                DbOperationDialog.$$$reportNull$$$0(16);
            }
            return dialog.export((DasObject)object, true);
        }).addAllTo((Collection)exported);
        PairProcessor pairProcessor = (helper, values2) -> {
            if (ops == null) {
                DbOperationDialog.$$$reportNull$$$0(15);
            }
            DdlGenerator generator = helper.getDdlGenerator();
            DdlGraphBuilder builder = helper.getDdlGraphBuilder();
            UserDataHolder data = builder.newData(null);
            ConfigurableDdlGenerator.OPTION_VALUES.set(data, values2);
            for (DeObject object : exported) {
                for (DdlOperation op : ops) {
                    generator.addOperation(builder, op, object, data);
                }
            }
            return true;
        };
        if (pairProcessor == null) {
            DbOperationDialog.$$$reportNull$$$0(8);
        }
        return pairProcessor;
    }

    @NotNull
    private DeObject export(@NotNull DasObject object, boolean withChildren) {
        if (object == null) {
            DbOperationDialog.$$$reportNull$$$0(9);
        }
        Object De = this.myExportHelper.exportDeep(this.myContext.getModel(), object, withChildren);
        if (De == null) {
            DbOperationDialog.$$$reportNull$$$0(10);
        }
        return De;
    }

    @NotNull
    public static DbOperationDialog createDialog(@NotNull DatabaseEditorContext context, @NotNull Iterable<? extends DasObject> objects, DdlOperation ... ops) {
        if (context == null) {
            DbOperationDialog.$$$reportNull$$$0(11);
        }
        if (objects == null) {
            DbOperationDialog.$$$reportNull$$$0(12);
        }
        if (ops == null) {
            DbOperationDialog.$$$reportNull$$$0(13);
        }
        DbOperationDialog dialog = new DbOperationDialog(context, DbOperationDialog.getDefaults(context.getDialect().getSchemaEditor().getDdlOperations(), ops));
        dialog.setGenerator(DbOperationDialog.createGenerator(dialog, objects, ops));
        DbOperationDialog dbOperationDialog = dialog;
        if (dbOperationDialog == null) {
            DbOperationDialog.$$$reportNull$$$0(14);
        }
        return dbOperationDialog;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 4: 
            case 7: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ops";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbOperationDialog";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbOperationDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "export";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setGenerator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaults";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createGenerator";
                break;
            }
            case 8: 
            case 10: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createGenerator$5";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createGenerator$4";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDefaults$2";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setGenerator$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class OptionEditorPanel
    extends JPanel {
        public OptionEditorPanel() {
            super((LayoutManager)new GridLayoutManager(DbOperationDialog.getNumRows(DbOperationDialog.this.myOptions.size()), 4));
            Dimension sz = new Dimension(-1, -1);
            for (int i2 = 0; i2 < DbOperationDialog.this.myOptions.size(); ++i2) {
                ConfigurableDdlGenerator.OptionValue option = (ConfigurableDdlGenerator.OptionValue)DbOperationDialog.this.myOptions.get(i2);
                GridConstraints constraints = new GridConstraints(i2 / 3, i2 % 3, 1, 1, 8, 3, 0, 0, sz, sz, sz);
                this.add((Component)this.createEditor(option), constraints);
            }
            this.add(Box.createHorizontalGlue(), new GridConstraints(0, 3, DbOperationDialog.getNumRows(DbOperationDialog.this.myOptions.size()), 1, 8, 3, 6, 0, sz, sz, sz));
        }

        @NotNull
        private JComponent createEditor(@NotNull ConfigurableDdlGenerator.OptionValue<?> option) {
            if (option == null) {
                OptionEditorPanel.$$$reportNull$$$0(0);
            }
            if (option.option.valueClass.isAssignableFrom(Boolean.class)) {
                JComponent jComponent = this.createBooleanEditor(option);
                if (jComponent == null) {
                    OptionEditorPanel.$$$reportNull$$$0(1);
                }
                return jComponent;
            }
            throw new AssertionError((Object)"Unsupported option");
        }

        @NotNull
        private JComponent createBooleanEditor(final @NotNull ConfigurableDdlGenerator.OptionValue<Boolean> option) {
            if (option == null) {
                OptionEditorPanel.$$$reportNull$$$0(2);
            }
            JBCheckBox ed = new JBCheckBox(option.option.name, option.value == Boolean.TRUE);
            ed.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    option.value = e.getStateChange() == 1;
                    DbOperationDialog.this.updatePreview();
                }
            });
            JBCheckBox jBCheckBox = ed;
            if (jBCheckBox == null) {
                OptionEditorPanel.$$$reportNull$$$0(3);
            }
            return jBCheckBox;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DbOperationDialog$OptionEditorPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DbOperationDialog$OptionEditorPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBooleanEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createEditor";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createBooleanEditor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

